<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="docPrivacyAttributes" value="${DataDictionary.PersonDocumentPrivacy.attributes}" />

<c:set var="canModifyPrivacyPreferences" scope="request" value="${KualiForm.canOverrideEntityPrivacyPreferences && !readOnly}" />

<kul:tab tabTitle="Privacy Preferences" defaultOpen="false" tabErrorKey="document.privacy*">
	<div class="tab-container" align="center">
		<table cellpadding="0" cellspacing="0" summary=""> 
	 		<tr>
	 		    <kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressName}" labelFor="document.privacy.suppressName" />
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressName" attributeEntry="${docPrivacyAttributes.suppressName}" readOnly="${!canModifyPrivacyPreferences}" />
  				<kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressAddress}" labelFor="document.privacy.suppressAddress" />
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressAddress" attributeEntry="${docPrivacyAttributes.suppressAddress}" readOnly="${!canModifyPrivacyPreferences}" />
	 		</tr>
	 		<tr>
	 		    <kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressPersonal}" labelFor="document.privacy.suppressPersonal" />
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressPersonal" attributeEntry="${docPrivacyAttributes.suppressPersonal}" readOnly="${!canModifyPrivacyPreferences}" />
  				<kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressEmail}" labelFor="document.privacy.suppressEmail" />
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressEmail" attributeEntry="${docPrivacyAttributes.suppressEmail}" readOnly="${!canModifyPrivacyPreferences}" />
	 		</tr>
	 		<tr>
  				<kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressPhone}" labelFor="document.privacy.suppressPhone" />
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressPhone" attributeEntry="${docPrivacyAttributes.suppressPhone}" readOnly="${!canModifyPrivacyPreferences}" />
		 		<th></th>
		 		<td></td>
	 		</tr>
		</table> 		
	</div>
</kul:tab>
