/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
/* %% Ignore-License */
/*
 * jQuery UI Autocomplete HTML Extension
 *
 * Copyright 2010, Scott Gonz�lez (http://scottgonzalez.com)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 * http://github.com/scottgonzalez/jquery-ui-extensions
 */
// NOTE: The existing extension has been further modified for accessibility
(function( $ ) {

function filter( array, term ) {
	var matcher = new RegExp( $.ui.autocomplete.escapeRegex(term), "i" );
	return $.grep( array, function(value) {
		return matcher.test( $( "<div>" ).html( value.label || value.value || value ).text() );
	});
}

$.widget('ui.autocomplete', $.ui.autocomplete, {
	_initSource: function() {
		if ( this.options.html && $.isArray(this.options.source) ) {
			this.source = function( request, response ) {
				response( filter( this.options.source, request.term ) );
			};
		} else {
			this._super( this );
		}
	},

	_renderItem: function( ul, item) {
		ul.attr('role', 'listbox');
		return $("<li></li>")
			.data("item.autocomplete", item)
			.append($("<a></a>", {role: "option"})[this.options.html ? "html" : "text"](item.label))
			.appendTo(ul);
	},

	_create: function() {
		this._super();
		this.element.data('ui-autocomplete');
		this._off(this.menu.element, 'menufocus');
		// Replace the jQuery supplied menufocus handler with a slightly modified version
		this._on(this.menu.element, {
			menufocus: function( event, ui ) {
				// #7024 - Prevent accidental activation of menu items in Firefox
				if ( this.isNewMenu ) {
					this.isNewMenu = false;
					if ( event.originalEvent && /^mouse/.test( event.originalEvent.type ) ) {
						// noinspection JSPotentiallyInvalidUsageOfThis
						this.menu.blur();

						this.document.one( "mousemove", function() {
							$( event.target ).trigger( event.originalEvent );
						});

						return;
					}
				}

				// back compat for _renderItem using item.autocomplete, via #7810
				var item = ui.item.data( "ui-autocomplete-item" ) || ui.item.data( "item.autocomplete" );
				if ( false !== this._trigger( "focus", event, { item: item } ) ) {
					// use value to match what will end up in the input, if it was a key event
					if ( event.originalEvent && /^key/.test( event.originalEvent.type ) ) {
						this._value( item.value);
					}
				}
				// This is where the method differs from the jQuery version:
				//    - always update the live region
				//    - announce the label instead of the value using the live region (adjusted for the html extension)
				this.liveRegion[this.options.html ? 'html' : 'text']( item.label );
		}});
	}

});

})( jQuery );
