<#--
 #%L
 %%
 Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#macro uif_label element>

    <#if element.labelText?has_content>
        <#local label="${element.labelText}"/>
        <#local colon=""/>

        <#if element.renderColon>
            <#local colon=":"/>
        </#if>

        <#if element.labelForComponentId?has_content>
            <#local for='for="${element.labelForComponentId!}"'>
        </#if>

        <@compress single_line=true>
            <label id="${element.id}" ${for!} ${krad.attrBuild(element)}
                ${element.simpleDataAttributes!}>

                <#if element.richLabelMessage?has_content>
                    <@krad.template component=element.richLabelMessage/>${colon}
                <#else>
                    ${label}${colon}
                </#if>

                <#-- required indicator -->
                <#if element.requiredIndicator?? && element.renderRequiredIndicator>
                    <span class="uif-requiredMessage">${element.requiredIndicator!}</span>
                </#if>

            </label>
        </@compress>
    </#if>
</#macro>
