<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="keyMatch" required="true" description="A concatenated String with properties to match error keys with, each seperated by a comma." %>
<%@ attribute name="auditMatch" required="false" description="Audit information which errors should be matched against if no errors were matched by keyMatch." %>

<c:set var="hasErrors" value="false" scope="request" />

<c:choose>
	<c:when test="${! (empty keyMatch)}">
		<c:forEach items="${fn:split(keyMatch,',')}" var="prefix">
			<c:forEach items="${ErrorPropertyList}" var="key">
				<c:if test="${(fn:endsWith(prefix,'*') && fn:startsWith(key,fn:replace(prefix,'*',''))) || (key eq prefix)}">
					<c:set var="hasErrors" value="true" scope="request"/>
				</c:if>
			</c:forEach>
		</c:forEach>
	</c:when>

	<c:otherwise>
		<logic:messagesPresent>
			<c:set var="hasErrors" value="true" scope="request" />
		</logic:messagesPresent>
	</c:otherwise>
</c:choose>

<c:if test="${!(empty auditMatch) && !hasErrors}">
	<c:forEach items="${fn:split(auditMatch,',')}" var="prefix">
		<c:forEach items="${AuditErrors}" var="cluster">
			<c:forEach items="${cluster.value.auditErrorList}" var="audit">
				<c:if test="${(fn:endsWith(prefix,'*') && fn:startsWith(audit.errorKey,fn:replace(prefix,'*',''))) || (audit.errorKey eq prefix)}">
					<c:set var="hasErrors" value="true" scope="request"/>
				</c:if>
			</c:forEach>
		</c:forEach>
	</c:forEach>
</c:if>


