<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="action" required="true"
		description="What's the action requested? Maintenance copy and edit actions get Old and New." %>
<%@ attribute name="colspan" required="true"
              description="What's the colspan for each header column?" %>
<%@ attribute name="depth" required="true"
		description="What level of recursion are we on?  Avoids putting 'New' on container contents." %>
<%--
	############################################################################################################################# 
	SHOW THE OLD/NEW BAR
	#############################################################################################################################
	--%>

<!--
<c:out value="action is ${action}, colspan is ${colspan}, <br/>" escapeXml="false" />
-->

<c:choose>

    <c:when test="${Constants.MAINTENANCE_COPY_ACTION eq action || Constants.MAINTENANCE_EDIT_ACTION eq action}">
        <c:set var="isCopyActionNotEditAction" value="${Constants.MAINTENANCE_COPY_ACTION eq action}"/>
		<td colspan="${colspan}" class="tab-subhead" width="50%">
			<div class="tab-subhead-r">
                ${isCopyActionNotEditAction ? 'Original' : 'Old'}
			</div>
		</td>
		<td colspan="${colspan}" class="tab-subhead" width="50%">
            ${isCopyActionNotEditAction ? 'New Copy' : 'New'}
		</td>
        </tr><tr>
	</c:when>
	
	<c:when test="${depth eq 0}">
		<%-- Show just one section header that goes all the way across. --%>
		<td colspan="${colspan}" class="tab-subhead">
			New
		</td>
        </tr><tr>
    </c:when>
    
    <c:otherwise>
        <%-- Show nothing. --%>
    </c:otherwise>
	
</c:choose>
