// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.endpoints.internal

import aws.sdk.kotlin.services.s3.S3Client
import aws.sdk.kotlin.services.s3.endpoints.S3EndpointParameters
import aws.sdk.kotlin.services.s3.model.AbortMultipartUploadRequest
import aws.sdk.kotlin.services.s3.model.CompleteMultipartUploadRequest
import aws.sdk.kotlin.services.s3.model.CopyObjectRequest
import aws.sdk.kotlin.services.s3.model.CreateBucketRequest
import aws.sdk.kotlin.services.s3.model.CreateMultipartUploadRequest
import aws.sdk.kotlin.services.s3.model.CreateSessionRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketAnalyticsConfigurationRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketCorsRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketEncryptionRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketInventoryConfigurationRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketLifecycleRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketMetricsConfigurationRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketOwnershipControlsRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketPolicyRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketReplicationRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketTaggingRequest
import aws.sdk.kotlin.services.s3.model.DeleteBucketWebsiteRequest
import aws.sdk.kotlin.services.s3.model.DeleteObjectRequest
import aws.sdk.kotlin.services.s3.model.DeleteObjectTaggingRequest
import aws.sdk.kotlin.services.s3.model.DeleteObjectsRequest
import aws.sdk.kotlin.services.s3.model.DeletePublicAccessBlockRequest
import aws.sdk.kotlin.services.s3.model.GetBucketAccelerateConfigurationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketAclRequest
import aws.sdk.kotlin.services.s3.model.GetBucketAnalyticsConfigurationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketCorsRequest
import aws.sdk.kotlin.services.s3.model.GetBucketEncryptionRequest
import aws.sdk.kotlin.services.s3.model.GetBucketIntelligentTieringConfigurationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketInventoryConfigurationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketLocationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketLoggingRequest
import aws.sdk.kotlin.services.s3.model.GetBucketMetricsConfigurationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketNotificationConfigurationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketOwnershipControlsRequest
import aws.sdk.kotlin.services.s3.model.GetBucketPolicyRequest
import aws.sdk.kotlin.services.s3.model.GetBucketPolicyStatusRequest
import aws.sdk.kotlin.services.s3.model.GetBucketReplicationRequest
import aws.sdk.kotlin.services.s3.model.GetBucketRequestPaymentRequest
import aws.sdk.kotlin.services.s3.model.GetBucketTaggingRequest
import aws.sdk.kotlin.services.s3.model.GetBucketVersioningRequest
import aws.sdk.kotlin.services.s3.model.GetBucketWebsiteRequest
import aws.sdk.kotlin.services.s3.model.GetObjectAclRequest
import aws.sdk.kotlin.services.s3.model.GetObjectAttributesRequest
import aws.sdk.kotlin.services.s3.model.GetObjectLegalHoldRequest
import aws.sdk.kotlin.services.s3.model.GetObjectLockConfigurationRequest
import aws.sdk.kotlin.services.s3.model.GetObjectRequest
import aws.sdk.kotlin.services.s3.model.GetObjectRetentionRequest
import aws.sdk.kotlin.services.s3.model.GetObjectTaggingRequest
import aws.sdk.kotlin.services.s3.model.GetObjectTorrentRequest
import aws.sdk.kotlin.services.s3.model.GetPublicAccessBlockRequest
import aws.sdk.kotlin.services.s3.model.HeadBucketRequest
import aws.sdk.kotlin.services.s3.model.HeadObjectRequest
import aws.sdk.kotlin.services.s3.model.ListBucketAnalyticsConfigurationsRequest
import aws.sdk.kotlin.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
import aws.sdk.kotlin.services.s3.model.ListBucketInventoryConfigurationsRequest
import aws.sdk.kotlin.services.s3.model.ListBucketMetricsConfigurationsRequest
import aws.sdk.kotlin.services.s3.model.ListMultipartUploadsRequest
import aws.sdk.kotlin.services.s3.model.ListObjectVersionsRequest
import aws.sdk.kotlin.services.s3.model.ListObjectsRequest
import aws.sdk.kotlin.services.s3.model.ListObjectsV2Request
import aws.sdk.kotlin.services.s3.model.ListPartsRequest
import aws.sdk.kotlin.services.s3.model.PutBucketAccelerateConfigurationRequest
import aws.sdk.kotlin.services.s3.model.PutBucketAclRequest
import aws.sdk.kotlin.services.s3.model.PutBucketAnalyticsConfigurationRequest
import aws.sdk.kotlin.services.s3.model.PutBucketCorsRequest
import aws.sdk.kotlin.services.s3.model.PutBucketEncryptionRequest
import aws.sdk.kotlin.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
import aws.sdk.kotlin.services.s3.model.PutBucketInventoryConfigurationRequest
import aws.sdk.kotlin.services.s3.model.PutBucketLifecycleConfigurationRequest
import aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest
import aws.sdk.kotlin.services.s3.model.PutBucketMetricsConfigurationRequest
import aws.sdk.kotlin.services.s3.model.PutBucketNotificationConfigurationRequest
import aws.sdk.kotlin.services.s3.model.PutBucketOwnershipControlsRequest
import aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest
import aws.sdk.kotlin.services.s3.model.PutBucketReplicationRequest
import aws.sdk.kotlin.services.s3.model.PutBucketRequestPaymentRequest
import aws.sdk.kotlin.services.s3.model.PutBucketTaggingRequest
import aws.sdk.kotlin.services.s3.model.PutBucketVersioningRequest
import aws.sdk.kotlin.services.s3.model.PutBucketWebsiteRequest
import aws.sdk.kotlin.services.s3.model.PutObjectAclRequest
import aws.sdk.kotlin.services.s3.model.PutObjectLegalHoldRequest
import aws.sdk.kotlin.services.s3.model.PutObjectLockConfigurationRequest
import aws.sdk.kotlin.services.s3.model.PutObjectRequest
import aws.sdk.kotlin.services.s3.model.PutObjectRetentionRequest
import aws.sdk.kotlin.services.s3.model.PutObjectTaggingRequest
import aws.sdk.kotlin.services.s3.model.PutPublicAccessBlockRequest
import aws.sdk.kotlin.services.s3.model.RestoreObjectRequest
import aws.sdk.kotlin.services.s3.model.SelectObjectContentRequest
import aws.sdk.kotlin.services.s3.model.UploadPartCopyRequest
import aws.sdk.kotlin.services.s3.model.UploadPartRequest
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest

internal class EndpointResolverAdapter(
    private val config: S3Client.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: S3Client.Config, request: ResolveEndpointRequest): S3EndpointParameters {
    return S3EndpointParameters {
        region = config.region
        bindAwsBuiltins(config, request)
        endpoint = config.endpointUrl?.toString()
        disableS3ExpressSessionAuth = config.disableS3ExpressSessionAuth
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (S3EndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
    "AbortMultipartUpload" to ::bindAbortMultipartUploadEndpointContext,
    "CompleteMultipartUpload" to ::bindCompleteMultipartUploadEndpointContext,
    "CopyObject" to ::bindCopyObjectEndpointContext,
    "CreateBucket" to ::bindCreateBucketEndpointContext,
    "CreateMultipartUpload" to ::bindCreateMultipartUploadEndpointContext,
    "CreateSession" to ::bindCreateSessionEndpointContext,
    "DeleteBucket" to ::bindDeleteBucketEndpointContext,
    "DeleteBucketAnalyticsConfiguration" to ::bindDeleteBucketAnalyticsConfigurationEndpointContext,
    "DeleteBucketCors" to ::bindDeleteBucketCorsEndpointContext,
    "DeleteBucketEncryption" to ::bindDeleteBucketEncryptionEndpointContext,
    "DeleteBucketIntelligentTieringConfiguration" to ::bindDeleteBucketIntelligentTieringConfigurationEndpointContext,
    "DeleteBucketInventoryConfiguration" to ::bindDeleteBucketInventoryConfigurationEndpointContext,
    "DeleteBucketLifecycle" to ::bindDeleteBucketLifecycleEndpointContext,
    "DeleteBucketMetricsConfiguration" to ::bindDeleteBucketMetricsConfigurationEndpointContext,
    "DeleteBucketOwnershipControls" to ::bindDeleteBucketOwnershipControlsEndpointContext,
    "DeleteBucketPolicy" to ::bindDeleteBucketPolicyEndpointContext,
    "DeleteBucketReplication" to ::bindDeleteBucketReplicationEndpointContext,
    "DeleteBucketTagging" to ::bindDeleteBucketTaggingEndpointContext,
    "DeleteBucketWebsite" to ::bindDeleteBucketWebsiteEndpointContext,
    "DeleteObject" to ::bindDeleteObjectEndpointContext,
    "DeleteObjects" to ::bindDeleteObjectsEndpointContext,
    "DeleteObjectTagging" to ::bindDeleteObjectTaggingEndpointContext,
    "DeletePublicAccessBlock" to ::bindDeletePublicAccessBlockEndpointContext,
    "GetBucketAccelerateConfiguration" to ::bindGetBucketAccelerateConfigurationEndpointContext,
    "GetBucketAcl" to ::bindGetBucketAclEndpointContext,
    "GetBucketAnalyticsConfiguration" to ::bindGetBucketAnalyticsConfigurationEndpointContext,
    "GetBucketCors" to ::bindGetBucketCorsEndpointContext,
    "GetBucketEncryption" to ::bindGetBucketEncryptionEndpointContext,
    "GetBucketIntelligentTieringConfiguration" to ::bindGetBucketIntelligentTieringConfigurationEndpointContext,
    "GetBucketInventoryConfiguration" to ::bindGetBucketInventoryConfigurationEndpointContext,
    "GetBucketLifecycleConfiguration" to ::bindGetBucketLifecycleConfigurationEndpointContext,
    "GetBucketLocation" to ::bindGetBucketLocationEndpointContext,
    "GetBucketLogging" to ::bindGetBucketLoggingEndpointContext,
    "GetBucketMetricsConfiguration" to ::bindGetBucketMetricsConfigurationEndpointContext,
    "GetBucketNotificationConfiguration" to ::bindGetBucketNotificationConfigurationEndpointContext,
    "GetBucketOwnershipControls" to ::bindGetBucketOwnershipControlsEndpointContext,
    "GetBucketPolicy" to ::bindGetBucketPolicyEndpointContext,
    "GetBucketPolicyStatus" to ::bindGetBucketPolicyStatusEndpointContext,
    "GetBucketReplication" to ::bindGetBucketReplicationEndpointContext,
    "GetBucketRequestPayment" to ::bindGetBucketRequestPaymentEndpointContext,
    "GetBucketTagging" to ::bindGetBucketTaggingEndpointContext,
    "GetBucketVersioning" to ::bindGetBucketVersioningEndpointContext,
    "GetBucketWebsite" to ::bindGetBucketWebsiteEndpointContext,
    "GetObject" to ::bindGetObjectEndpointContext,
    "GetObjectAcl" to ::bindGetObjectAclEndpointContext,
    "GetObjectAttributes" to ::bindGetObjectAttributesEndpointContext,
    "GetObjectLegalHold" to ::bindGetObjectLegalHoldEndpointContext,
    "GetObjectLockConfiguration" to ::bindGetObjectLockConfigurationEndpointContext,
    "GetObjectRetention" to ::bindGetObjectRetentionEndpointContext,
    "GetObjectTagging" to ::bindGetObjectTaggingEndpointContext,
    "GetObjectTorrent" to ::bindGetObjectTorrentEndpointContext,
    "GetPublicAccessBlock" to ::bindGetPublicAccessBlockEndpointContext,
    "HeadBucket" to ::bindHeadBucketEndpointContext,
    "HeadObject" to ::bindHeadObjectEndpointContext,
    "ListBucketAnalyticsConfigurations" to ::bindListBucketAnalyticsConfigurationsEndpointContext,
    "ListBucketIntelligentTieringConfigurations" to ::bindListBucketIntelligentTieringConfigurationsEndpointContext,
    "ListBucketInventoryConfigurations" to ::bindListBucketInventoryConfigurationsEndpointContext,
    "ListBucketMetricsConfigurations" to ::bindListBucketMetricsConfigurationsEndpointContext,
    "ListDirectoryBuckets" to ::bindListDirectoryBucketsEndpointContext,
    "ListMultipartUploads" to ::bindListMultipartUploadsEndpointContext,
    "ListObjects" to ::bindListObjectsEndpointContext,
    "ListObjectsV2" to ::bindListObjectsV2EndpointContext,
    "ListObjectVersions" to ::bindListObjectVersionsEndpointContext,
    "ListParts" to ::bindListPartsEndpointContext,
    "PutBucketAccelerateConfiguration" to ::bindPutBucketAccelerateConfigurationEndpointContext,
    "PutBucketAcl" to ::bindPutBucketAclEndpointContext,
    "PutBucketAnalyticsConfiguration" to ::bindPutBucketAnalyticsConfigurationEndpointContext,
    "PutBucketCors" to ::bindPutBucketCorsEndpointContext,
    "PutBucketEncryption" to ::bindPutBucketEncryptionEndpointContext,
    "PutBucketIntelligentTieringConfiguration" to ::bindPutBucketIntelligentTieringConfigurationEndpointContext,
    "PutBucketInventoryConfiguration" to ::bindPutBucketInventoryConfigurationEndpointContext,
    "PutBucketLifecycleConfiguration" to ::bindPutBucketLifecycleConfigurationEndpointContext,
    "PutBucketLogging" to ::bindPutBucketLoggingEndpointContext,
    "PutBucketMetricsConfiguration" to ::bindPutBucketMetricsConfigurationEndpointContext,
    "PutBucketNotificationConfiguration" to ::bindPutBucketNotificationConfigurationEndpointContext,
    "PutBucketOwnershipControls" to ::bindPutBucketOwnershipControlsEndpointContext,
    "PutBucketPolicy" to ::bindPutBucketPolicyEndpointContext,
    "PutBucketReplication" to ::bindPutBucketReplicationEndpointContext,
    "PutBucketRequestPayment" to ::bindPutBucketRequestPaymentEndpointContext,
    "PutBucketTagging" to ::bindPutBucketTaggingEndpointContext,
    "PutBucketVersioning" to ::bindPutBucketVersioningEndpointContext,
    "PutBucketWebsite" to ::bindPutBucketWebsiteEndpointContext,
    "PutObject" to ::bindPutObjectEndpointContext,
    "PutObjectAcl" to ::bindPutObjectAclEndpointContext,
    "PutObjectLegalHold" to ::bindPutObjectLegalHoldEndpointContext,
    "PutObjectLockConfiguration" to ::bindPutObjectLockConfigurationEndpointContext,
    "PutObjectRetention" to ::bindPutObjectRetentionEndpointContext,
    "PutObjectTagging" to ::bindPutObjectTaggingEndpointContext,
    "PutPublicAccessBlock" to ::bindPutPublicAccessBlockEndpointContext,
    "RestoreObject" to ::bindRestoreObjectEndpointContext,
    "SelectObjectContent" to ::bindSelectObjectContentEndpointContext,
    "UploadPart" to ::bindUploadPartEndpointContext,
    "UploadPartCopy" to ::bindUploadPartCopyEndpointContext,
    "WriteGetObjectResponse" to ::bindWriteGetObjectResponseEndpointContext,
)

private fun S3EndpointParameters.Builder.bindAwsBuiltins(config: S3Client.Config, request: ResolveEndpointRequest) {
    useFips = config.useFips
    useDualStack = config.useDualStack
    forcePathStyle = config.forcePathStyle
    accelerate = config.enableAccelerate
    useGlobalEndpoint = false
    disableMultiRegionAccessPoints = config.disableMrap
    useArnRegion = config.useArnRegion
}

private fun bindAbortMultipartUploadEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as AbortMultipartUploadRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindCompleteMultipartUploadEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CompleteMultipartUploadRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindCopyObjectEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CopyObjectRequest
    builder.bucket = input.bucket
    builder.disableS3ExpressSessionAuth = true
}

private fun bindCreateBucketEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateBucketRequest
    builder.bucket = input.bucket
    builder.disableAccessPoints = true
    builder.useS3ExpressControlEndpoint = true
}

private fun bindCreateMultipartUploadEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateMultipartUploadRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindCreateSessionEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as CreateSessionRequest
    builder.bucket = input.bucket
    builder.disableS3ExpressSessionAuth = true
}

private fun bindDeleteBucketEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketAnalyticsConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketAnalyticsConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketCorsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketCorsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketEncryptionEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketEncryptionRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketIntelligentTieringConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketIntelligentTieringConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketInventoryConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketInventoryConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketLifecycleEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketLifecycleRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketMetricsConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketMetricsConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketOwnershipControlsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketOwnershipControlsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketPolicyEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketPolicyRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketReplicationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketReplicationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketTaggingEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketTaggingRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteBucketWebsiteEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteBucketWebsiteRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindDeleteObjectEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteObjectRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindDeleteObjectsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteObjectsRequest
    builder.bucket = input.bucket
}

private fun bindDeleteObjectTaggingEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteObjectTaggingRequest
    builder.bucket = input.bucket
}

private fun bindDeletePublicAccessBlockEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeletePublicAccessBlockRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketAccelerateConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketAccelerateConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketAclEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketAclRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketAnalyticsConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketAnalyticsConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketCorsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketCorsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketEncryptionEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketEncryptionRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketIntelligentTieringConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketIntelligentTieringConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketInventoryConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketInventoryConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketLifecycleConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketLifecycleConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketLocationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketLocationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketLoggingEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketLoggingRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketMetricsConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketMetricsConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketNotificationConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketNotificationConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketOwnershipControlsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketOwnershipControlsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketPolicyEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketPolicyRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketPolicyStatusEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketPolicyStatusRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketReplicationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketReplicationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketRequestPaymentEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketRequestPaymentRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketTaggingEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketTaggingRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketVersioningEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketVersioningRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetBucketWebsiteEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetBucketWebsiteRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindGetObjectEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetObjectRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindGetObjectAclEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetObjectAclRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindGetObjectAttributesEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetObjectAttributesRequest
    builder.bucket = input.bucket
}

private fun bindGetObjectLegalHoldEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetObjectLegalHoldRequest
    builder.bucket = input.bucket
}

private fun bindGetObjectLockConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetObjectLockConfigurationRequest
    builder.bucket = input.bucket
}

private fun bindGetObjectRetentionEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetObjectRetentionRequest
    builder.bucket = input.bucket
}

private fun bindGetObjectTaggingEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetObjectTaggingRequest
    builder.bucket = input.bucket
}

private fun bindGetObjectTorrentEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetObjectTorrentRequest
    builder.bucket = input.bucket
}

private fun bindGetPublicAccessBlockEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetPublicAccessBlockRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindHeadBucketEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as HeadBucketRequest
    builder.bucket = input.bucket
}

private fun bindHeadObjectEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as HeadObjectRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindListBucketAnalyticsConfigurationsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListBucketAnalyticsConfigurationsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindListBucketIntelligentTieringConfigurationsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListBucketIntelligentTieringConfigurationsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindListBucketInventoryConfigurationsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListBucketInventoryConfigurationsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindListBucketMetricsConfigurationsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListBucketMetricsConfigurationsRequest
    builder.bucket = input.bucket
}

private fun bindListDirectoryBucketsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.useS3ExpressControlEndpoint = true
}

private fun bindListMultipartUploadsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListMultipartUploadsRequest
    builder.bucket = input.bucket
    builder.prefix = input.prefix
}

private fun bindListObjectsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListObjectsRequest
    builder.bucket = input.bucket
    builder.prefix = input.prefix
}

private fun bindListObjectsV2EndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListObjectsV2Request
    builder.bucket = input.bucket
    builder.prefix = input.prefix
}

private fun bindListObjectVersionsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListObjectVersionsRequest
    builder.bucket = input.bucket
    builder.prefix = input.prefix
}

private fun bindListPartsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListPartsRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindPutBucketAccelerateConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketAccelerateConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketAclEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketAclRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketAnalyticsConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketAnalyticsConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketCorsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketCorsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketEncryptionEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketEncryptionRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketIntelligentTieringConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketIntelligentTieringConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketInventoryConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketInventoryConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketLifecycleConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketLifecycleConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketLoggingEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketLoggingRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketMetricsConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketMetricsConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketNotificationConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketNotificationConfigurationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketOwnershipControlsEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketOwnershipControlsRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketPolicyEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketPolicyRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketReplicationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketReplicationRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketRequestPaymentEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketRequestPaymentRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketTaggingEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketTaggingRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketVersioningEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketVersioningRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutBucketWebsiteEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutBucketWebsiteRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindPutObjectEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutObjectRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindPutObjectAclEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutObjectAclRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindPutObjectLegalHoldEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutObjectLegalHoldRequest
    builder.bucket = input.bucket
}

private fun bindPutObjectLockConfigurationEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutObjectLockConfigurationRequest
    builder.bucket = input.bucket
}

private fun bindPutObjectRetentionEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutObjectRetentionRequest
    builder.bucket = input.bucket
}

private fun bindPutObjectTaggingEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutObjectTaggingRequest
    builder.bucket = input.bucket
}

private fun bindPutPublicAccessBlockEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutPublicAccessBlockRequest
    builder.bucket = input.bucket
    builder.useS3ExpressControlEndpoint = true
}

private fun bindRestoreObjectEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as RestoreObjectRequest
    builder.bucket = input.bucket
}

private fun bindSelectObjectContentEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as SelectObjectContentRequest
    builder.bucket = input.bucket
}

private fun bindUploadPartEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UploadPartRequest
    builder.bucket = input.bucket
    builder.key = input.key
}

private fun bindUploadPartCopyEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UploadPartCopyRequest
    builder.bucket = input.bucket
    builder.disableS3ExpressSessionAuth = true
}

private fun bindWriteGetObjectResponseEndpointContext(builder: S3EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.useObjectLambdaEndpoint = true
}
