// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * The container element for an ownership control rule.
 */
public class OwnershipControlsRule private constructor(builder: Builder) {
    /**
     * The container element for object ownership for a bucket's ownership controls.
     *
     * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
     *
     * `ObjectWriter` - The uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
     *
     * `BucketOwnerEnforced` - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or specify bucket owner full control ACLs (such as the predefined `bucket-owner-full-control` canned ACL or a custom ACL in XML format that grants the same permissions).
     *
     * By default, `ObjectOwnership` is set to `BucketOwnerEnforced` and ACLs are disabled. We recommend keeping ACLs disabled, except in uncommon use cases where you must control access for each object individually. For more information about S3 Object Ownership, see [Controlling ownership of objects and disabling ACLs for your bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets. Directory buckets use the bucket owner enforced setting for S3 Object Ownership.
     */
    public val objectOwnership: aws.sdk.kotlin.services.s3.model.ObjectOwnership = requireNotNull(builder.objectOwnership) { "A non-null value must be provided for objectOwnership" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.OwnershipControlsRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OwnershipControlsRule(")
        append("objectOwnership=$objectOwnership")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = objectOwnership.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OwnershipControlsRule

        if (objectOwnership != other.objectOwnership) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.OwnershipControlsRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The container element for object ownership for a bucket's ownership controls.
         *
         * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
         *
         * `ObjectWriter` - The uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
         *
         * `BucketOwnerEnforced` - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or specify bucket owner full control ACLs (such as the predefined `bucket-owner-full-control` canned ACL or a custom ACL in XML format that grants the same permissions).
         *
         * By default, `ObjectOwnership` is set to `BucketOwnerEnforced` and ACLs are disabled. We recommend keeping ACLs disabled, except in uncommon use cases where you must control access for each object individually. For more information about S3 Object Ownership, see [Controlling ownership of objects and disabling ACLs for your bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets. Directory buckets use the bucket owner enforced setting for S3 Object Ownership.
         */
        public var objectOwnership: aws.sdk.kotlin.services.s3.model.ObjectOwnership? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.OwnershipControlsRule) : this() {
            this.objectOwnership = x.objectOwnership
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.OwnershipControlsRule = OwnershipControlsRule(this)

        internal fun correctErrors(): Builder {
            if (objectOwnership == null) objectOwnership = ObjectOwnership.SdkUnknown("no value provided")
            return this
        }
    }
}
