// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies a cross-origin access rule for an Amazon S3 bucket.
 */
public class CorsRule private constructor(builder: Builder) {
    /**
     * Headers that are specified in the `Access-Control-Request-Headers` header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.
     */
    public val allowedHeaders: List<String>? = builder.allowedHeaders
    /**
     * An HTTP method that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
     */
    public val allowedMethods: List<String> = requireNotNull(builder.allowedMethods) { "A non-null value must be provided for allowedMethods" }
    /**
     * One or more origins you want customers to be able to access the bucket from.
     */
    public val allowedOrigins: List<String> = requireNotNull(builder.allowedOrigins) { "A non-null value must be provided for allowedOrigins" }
    /**
     * One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    public val exposeHeaders: List<String>? = builder.exposeHeaders
    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The time in seconds that your browser is to cache the preflight response for the specified resource.
     */
    public val maxAgeSeconds: kotlin.Int? = builder.maxAgeSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.CorsRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CorsRule(")
        append("allowedHeaders=$allowedHeaders,")
        append("allowedMethods=$allowedMethods,")
        append("allowedOrigins=$allowedOrigins,")
        append("exposeHeaders=$exposeHeaders,")
        append("id=$id,")
        append("maxAgeSeconds=$maxAgeSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedHeaders?.hashCode() ?: 0
        result = 31 * result + (allowedMethods.hashCode())
        result = 31 * result + (allowedOrigins.hashCode())
        result = 31 * result + (exposeHeaders?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (maxAgeSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CorsRule

        if (allowedHeaders != other.allowedHeaders) return false
        if (allowedMethods != other.allowedMethods) return false
        if (allowedOrigins != other.allowedOrigins) return false
        if (exposeHeaders != other.exposeHeaders) return false
        if (id != other.id) return false
        if (maxAgeSeconds != other.maxAgeSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.CorsRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Headers that are specified in the `Access-Control-Request-Headers` header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.
         */
        public var allowedHeaders: List<String>? = null
        /**
         * An HTTP method that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
         */
        public var allowedMethods: List<String>? = null
        /**
         * One or more origins you want customers to be able to access the bucket from.
         */
        public var allowedOrigins: List<String>? = null
        /**
         * One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
         */
        public var exposeHeaders: List<String>? = null
        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         */
        public var id: kotlin.String? = null
        /**
         * The time in seconds that your browser is to cache the preflight response for the specified resource.
         */
        public var maxAgeSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.CorsRule) : this() {
            this.allowedHeaders = x.allowedHeaders
            this.allowedMethods = x.allowedMethods
            this.allowedOrigins = x.allowedOrigins
            this.exposeHeaders = x.exposeHeaders
            this.id = x.id
            this.maxAgeSeconds = x.maxAgeSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.CorsRule = CorsRule(this)

        internal fun correctErrors(): Builder {
            if (allowedMethods == null) allowedMethods = emptyList()
            if (allowedOrigins == null) allowedOrigins = emptyList()
            return this
        }
    }
}
