// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



public class ListObjectsV2Response private constructor(builder: Builder) {
    /**
     * All of the keys (up to 1,000) that share the same prefix are grouped together. When counting the total numbers of returns by this API operation, this group of keys is considered as one item.
     *
     * A response can contain `CommonPrefixes` only if you specify a delimiter.
     *
     * `CommonPrefixes` contains all (if there are any) keys between `Prefix` and the next occurrence of the string specified by a delimiter.
     *
     * `CommonPrefixes` lists keys that act like subdirectories in the directory specified by `Prefix`.
     *
     * For example, if the prefix is `notes/` and the delimiter is a slash (`/`) as in `notes/summer/july`, the common prefix is `notes/summer/`. All of the keys that roll up into a common prefix count as a single return when calculating the number of returns.
     *
     * + **Directory buckets** - For directory buckets, only prefixes that end in a delimiter (`/`) are supported.
     * + **Directory buckets ** - When you query `ListObjectsV2` with a delimiter during in-progress multipart uploads, the `CommonPrefixes` response parameter contains the prefixes that are associated with the in-progress multipart uploads. For more information about multipart uploads, see [Multipart Upload Overview](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html) in the *Amazon S3 User Guide*.
     */
    public val commonPrefixes: List<CommonPrefix>? = builder.commonPrefixes
    /**
     * Metadata about each object returned.
     */
    public val contents: List<Object>? = builder.contents
    /**
     * If `ContinuationToken` was sent with the request, it is included in the response. You can use the returned `ContinuationToken` for pagination of the list response. You can use this `ContinuationToken` for pagination of the list results.
     */
    public val continuationToken: kotlin.String? = builder.continuationToken
    /**
     * Causes keys that contain the same string between the `prefix` and the first occurrence of the delimiter to be rolled up into a single result element in the `CommonPrefixes` collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up result counts as only one return against the `MaxKeys` value.
     *
     * **Directory buckets** - For directory buckets, `/` is the only supported delimiter.
     */
    public val delimiter: kotlin.String? = builder.delimiter
    /**
     * Encoding type used by Amazon S3 to encode object key names in the XML response.
     *
     * If you specify the `encoding-type` request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:
     *
     * `Delimiter, Prefix, Key,` and `StartAfter`.
     */
    public val encodingType: aws.sdk.kotlin.services.s3.model.EncodingType? = builder.encodingType
    /**
     * Set to `false` if all of the results were returned. Set to `true` if more keys are available to return. If the number of results exceeds that specified by `MaxKeys`, all of the results might not be returned.
     */
    public val isTruncated: kotlin.Boolean? = builder.isTruncated
    /**
     * `KeyCount` is the number of keys returned with this request. `KeyCount` will always be less than or equal to the `MaxKeys` field. For example, if you ask for 50 keys, your result will include 50 keys or fewer.
     */
    public val keyCount: kotlin.Int? = builder.keyCount
    /**
     * Sets the maximum number of keys returned in the response. By default, the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.
     */
    public val maxKeys: kotlin.Int? = builder.maxKeys
    /**
     * The bucket name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * `NextContinuationToken` is sent when `isTruncated` is true, which means there are more keys in the bucket that can be listed. The next list requests to Amazon S3 can be continued with this `NextContinuationToken`. `NextContinuationToken` is obfuscated and is not a real key
     */
    public val nextContinuationToken: kotlin.String? = builder.nextContinuationToken
    /**
     * Keys that begin with the indicated prefix.
     *
     * **Directory buckets** - For directory buckets, only prefixes that end in a delimiter (`/`) are supported.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * If present, indicates that the requester was successfully charged for the request.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = builder.requestCharged
    /**
     * If StartAfter was sent with the request, it is included in the response.
     *
     * This functionality is not supported for directory buckets.
     */
    public val startAfter: kotlin.String? = builder.startAfter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ListObjectsV2Response = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListObjectsV2Response(")
        append("commonPrefixes=$commonPrefixes,")
        append("contents=$contents,")
        append("continuationToken=$continuationToken,")
        append("delimiter=$delimiter,")
        append("encodingType=$encodingType,")
        append("isTruncated=$isTruncated,")
        append("keyCount=$keyCount,")
        append("maxKeys=$maxKeys,")
        append("name=$name,")
        append("nextContinuationToken=$nextContinuationToken,")
        append("prefix=$prefix,")
        append("requestCharged=$requestCharged,")
        append("startAfter=$startAfter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = commonPrefixes?.hashCode() ?: 0
        result = 31 * result + (contents?.hashCode() ?: 0)
        result = 31 * result + (continuationToken?.hashCode() ?: 0)
        result = 31 * result + (delimiter?.hashCode() ?: 0)
        result = 31 * result + (encodingType?.hashCode() ?: 0)
        result = 31 * result + (isTruncated?.hashCode() ?: 0)
        result = 31 * result + (keyCount ?: 0)
        result = 31 * result + (maxKeys ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextContinuationToken?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (requestCharged?.hashCode() ?: 0)
        result = 31 * result + (startAfter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListObjectsV2Response

        if (commonPrefixes != other.commonPrefixes) return false
        if (contents != other.contents) return false
        if (continuationToken != other.continuationToken) return false
        if (delimiter != other.delimiter) return false
        if (encodingType != other.encodingType) return false
        if (isTruncated != other.isTruncated) return false
        if (keyCount != other.keyCount) return false
        if (maxKeys != other.maxKeys) return false
        if (name != other.name) return false
        if (nextContinuationToken != other.nextContinuationToken) return false
        if (prefix != other.prefix) return false
        if (requestCharged != other.requestCharged) return false
        if (startAfter != other.startAfter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ListObjectsV2Response = Builder(this).apply(block).build()

    public class Builder {
        /**
         * All of the keys (up to 1,000) that share the same prefix are grouped together. When counting the total numbers of returns by this API operation, this group of keys is considered as one item.
         *
         * A response can contain `CommonPrefixes` only if you specify a delimiter.
         *
         * `CommonPrefixes` contains all (if there are any) keys between `Prefix` and the next occurrence of the string specified by a delimiter.
         *
         * `CommonPrefixes` lists keys that act like subdirectories in the directory specified by `Prefix`.
         *
         * For example, if the prefix is `notes/` and the delimiter is a slash (`/`) as in `notes/summer/july`, the common prefix is `notes/summer/`. All of the keys that roll up into a common prefix count as a single return when calculating the number of returns.
         *
         * + **Directory buckets** - For directory buckets, only prefixes that end in a delimiter (`/`) are supported.
         * + **Directory buckets ** - When you query `ListObjectsV2` with a delimiter during in-progress multipart uploads, the `CommonPrefixes` response parameter contains the prefixes that are associated with the in-progress multipart uploads. For more information about multipart uploads, see [Multipart Upload Overview](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html) in the *Amazon S3 User Guide*.
         */
        public var commonPrefixes: List<CommonPrefix>? = null
        /**
         * Metadata about each object returned.
         */
        public var contents: List<Object>? = null
        /**
         * If `ContinuationToken` was sent with the request, it is included in the response. You can use the returned `ContinuationToken` for pagination of the list response. You can use this `ContinuationToken` for pagination of the list results.
         */
        public var continuationToken: kotlin.String? = null
        /**
         * Causes keys that contain the same string between the `prefix` and the first occurrence of the delimiter to be rolled up into a single result element in the `CommonPrefixes` collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up result counts as only one return against the `MaxKeys` value.
         *
         * **Directory buckets** - For directory buckets, `/` is the only supported delimiter.
         */
        public var delimiter: kotlin.String? = null
        /**
         * Encoding type used by Amazon S3 to encode object key names in the XML response.
         *
         * If you specify the `encoding-type` request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:
         *
         * `Delimiter, Prefix, Key,` and `StartAfter`.
         */
        public var encodingType: aws.sdk.kotlin.services.s3.model.EncodingType? = null
        /**
         * Set to `false` if all of the results were returned. Set to `true` if more keys are available to return. If the number of results exceeds that specified by `MaxKeys`, all of the results might not be returned.
         */
        public var isTruncated: kotlin.Boolean? = null
        /**
         * `KeyCount` is the number of keys returned with this request. `KeyCount` will always be less than or equal to the `MaxKeys` field. For example, if you ask for 50 keys, your result will include 50 keys or fewer.
         */
        public var keyCount: kotlin.Int? = null
        /**
         * Sets the maximum number of keys returned in the response. By default, the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.
         */
        public var maxKeys: kotlin.Int? = null
        /**
         * The bucket name.
         */
        public var name: kotlin.String? = null
        /**
         * `NextContinuationToken` is sent when `isTruncated` is true, which means there are more keys in the bucket that can be listed. The next list requests to Amazon S3 can be continued with this `NextContinuationToken`. `NextContinuationToken` is obfuscated and is not a real key
         */
        public var nextContinuationToken: kotlin.String? = null
        /**
         * Keys that begin with the indicated prefix.
         *
         * **Directory buckets** - For directory buckets, only prefixes that end in a delimiter (`/`) are supported.
         */
        public var prefix: kotlin.String? = null
        /**
         * If present, indicates that the requester was successfully charged for the request.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = null
        /**
         * If StartAfter was sent with the request, it is included in the response.
         *
         * This functionality is not supported for directory buckets.
         */
        public var startAfter: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ListObjectsV2Response) : this() {
            this.commonPrefixes = x.commonPrefixes
            this.contents = x.contents
            this.continuationToken = x.continuationToken
            this.delimiter = x.delimiter
            this.encodingType = x.encodingType
            this.isTruncated = x.isTruncated
            this.keyCount = x.keyCount
            this.maxKeys = x.maxKeys
            this.name = x.name
            this.nextContinuationToken = x.nextContinuationToken
            this.prefix = x.prefix
            this.requestCharged = x.requestCharged
            this.startAfter = x.startAfter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ListObjectsV2Response = ListObjectsV2Response(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
