// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.GetObjectTorrentRequest
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class GetObjectTorrentOperationSerializer: HttpSerialize<GetObjectTorrentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetObjectTorrentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                "${input.key}".split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters {
                add("torrent", "")
            }
        }

        builder.headers {
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
        }

        return builder
    }
}
