// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ObjectLockLegalHoldStatus
import aws.sdk.kotlin.services.s3.model.ObjectLockMode
import aws.sdk.kotlin.services.s3.model.ReplicationStatus
import aws.sdk.kotlin.services.s3.model.RequestCharged
import aws.sdk.kotlin.services.s3.model.ServerSideEncryption
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.sdk.kotlin.services.s3.model.WriteGetObjectResponseRequest
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class WriteGetObjectResponseOperationSerializer: HttpSerialize<WriteGetObjectResponseRequest> {
    override suspend fun serialize(context: ExecutionContext, input: WriteGetObjectResponseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/WriteGetObjectResponse"
            parameters.decodedParameters {
                add("x-id", "WriteGetObjectResponse")
            }
        }

        builder.headers {
            if (input.acceptRanges?.isNotEmpty() == true) append("x-amz-fwd-header-accept-ranges", input.acceptRanges)
            if (input.bucketKeyEnabled != null) append("x-amz-fwd-header-x-amz-server-side-encryption-bucket-key-enabled", "${input.bucketKeyEnabled}")
            if (input.cacheControl?.isNotEmpty() == true) append("x-amz-fwd-header-Cache-Control", input.cacheControl)
            if (input.checksumCrc32?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-checksum-crc32", input.checksumCrc32)
            if (input.checksumCrc32C?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-checksum-crc32c", input.checksumCrc32C)
            if (input.checksumSha1?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-checksum-sha1", input.checksumSha1)
            if (input.checksumSha256?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-checksum-sha256", input.checksumSha256)
            if (input.contentDisposition?.isNotEmpty() == true) append("x-amz-fwd-header-Content-Disposition", input.contentDisposition)
            if (input.contentEncoding?.isNotEmpty() == true) append("x-amz-fwd-header-Content-Encoding", input.contentEncoding)
            if (input.contentLanguage?.isNotEmpty() == true) append("x-amz-fwd-header-Content-Language", input.contentLanguage)
            if (input.contentLength != null) append("Content-Length", "${input.contentLength}")
            if (input.contentRange?.isNotEmpty() == true) append("x-amz-fwd-header-Content-Range", input.contentRange)
            if (input.contentType?.isNotEmpty() == true) append("x-amz-fwd-header-Content-Type", input.contentType)
            if (input.deleteMarker != null) append("x-amz-fwd-header-x-amz-delete-marker", "${input.deleteMarker}")
            if (input.eTag?.isNotEmpty() == true) append("x-amz-fwd-header-ETag", input.eTag)
            if (input.errorCode?.isNotEmpty() == true) append("x-amz-fwd-error-code", input.errorCode)
            if (input.errorMessage?.isNotEmpty() == true) append("x-amz-fwd-error-message", input.errorMessage)
            if (input.expiration?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-expiration", input.expiration)
            if (input.expires != null) append("x-amz-fwd-header-Expires", input.expires.format(TimestampFormat.RFC_5322))
            if (input.lastModified != null) append("x-amz-fwd-header-Last-Modified", input.lastModified.format(TimestampFormat.RFC_5322))
            if (input.missingMeta != null) append("x-amz-fwd-header-x-amz-missing-meta", "${input.missingMeta}")
            if (input.objectLockLegalHoldStatus != null) append("x-amz-fwd-header-x-amz-object-lock-legal-hold", input.objectLockLegalHoldStatus.value)
            if (input.objectLockMode != null) append("x-amz-fwd-header-x-amz-object-lock-mode", input.objectLockMode.value)
            if (input.objectLockRetainUntilDate != null) append("x-amz-fwd-header-x-amz-object-lock-retain-until-date", input.objectLockRetainUntilDate.format(TimestampFormat.ISO_8601))
            if (input.partsCount != null) append("x-amz-fwd-header-x-amz-mp-parts-count", "${input.partsCount}")
            if (input.replicationStatus != null) append("x-amz-fwd-header-x-amz-replication-status", input.replicationStatus.value)
            if (input.requestCharged != null) append("x-amz-fwd-header-x-amz-request-charged", input.requestCharged.value)
            if (input.requestRoute?.isNotEmpty() == true) append("x-amz-request-route", input.requestRoute)
            if (input.requestToken?.isNotEmpty() == true) append("x-amz-request-token", input.requestToken)
            if (input.restore?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-restore", input.restore)
            if (input.sseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-server-side-encryption-customer-algorithm", input.sseCustomerAlgorithm)
            if (input.sseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-server-side-encryption-customer-key-MD5", input.sseCustomerKeyMd5)
            if (input.ssekmsKeyId?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-server-side-encryption-aws-kms-key-id", input.ssekmsKeyId)
            if (input.serverSideEncryption != null) append("x-amz-fwd-header-x-amz-server-side-encryption", input.serverSideEncryption.value)
            if (input.statusCode != null) append("x-amz-fwd-status", "${input.statusCode}")
            if (input.storageClass != null) append("x-amz-fwd-header-x-amz-storage-class", input.storageClass.value)
            if (input.tagCount != null) append("x-amz-fwd-header-x-amz-tagging-count", "${input.tagCount}")
            if (input.versionId?.isNotEmpty() == true) append("x-amz-fwd-header-x-amz-version-id", input.versionId)
            input.metadata?.forEach { (key, value) ->
                append("x-amz-meta-$key", value)
            }
        }

        if (input.body != null) {
            builder.body = input.body.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
