// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Container for the `MultipartUpload` for the Amazon S3 object.
 */
public class MultipartUpload private constructor(builder: Builder) {
    /**
     * The algorithm that was used to create a checksum of the object.
     */
    public val checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     * Date and time at which the multipart upload was initiated.
     */
    public val initiated: aws.smithy.kotlin.runtime.time.Instant? = builder.initiated
    /**
     * Identifies who initiated the multipart upload.
     */
    public val initiator: aws.sdk.kotlin.services.s3.model.Initiator? = builder.initiator
    /**
     * Key of the object for which the multipart upload was initiated.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Specifies the owner of the object that is part of the multipart upload.
     *
     * **Directory buckets** - The bucket owner is returned as the object owner for all the objects.
     */
    public val owner: aws.sdk.kotlin.services.s3.model.Owner? = builder.owner
    /**
     * The class of storage used to store the object.
     *
     * **Directory buckets** - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
     */
    public val storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = builder.storageClass
    /**
     * Upload ID that identifies the multipart upload.
     */
    public val uploadId: kotlin.String? = builder.uploadId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.MultipartUpload = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MultipartUpload(")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("initiated=$initiated,")
        append("initiator=$initiator,")
        append("key=$key,")
        append("owner=$owner,")
        append("storageClass=$storageClass,")
        append("uploadId=$uploadId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = checksumAlgorithm?.hashCode() ?: 0
        result = 31 * result + (initiated?.hashCode() ?: 0)
        result = 31 * result + (initiator?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MultipartUpload

        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (initiated != other.initiated) return false
        if (initiator != other.initiator) return false
        if (key != other.key) return false
        if (owner != other.owner) return false
        if (storageClass != other.storageClass) return false
        if (uploadId != other.uploadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.MultipartUpload = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The algorithm that was used to create a checksum of the object.
         */
        public var checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = null
        /**
         * Date and time at which the multipart upload was initiated.
         */
        public var initiated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Identifies who initiated the multipart upload.
         */
        public var initiator: aws.sdk.kotlin.services.s3.model.Initiator? = null
        /**
         * Key of the object for which the multipart upload was initiated.
         */
        public var key: kotlin.String? = null
        /**
         * Specifies the owner of the object that is part of the multipart upload.
         *
         * **Directory buckets** - The bucket owner is returned as the object owner for all the objects.
         */
        public var owner: aws.sdk.kotlin.services.s3.model.Owner? = null
        /**
         * The class of storage used to store the object.
         *
         * **Directory buckets** - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
         */
        public var storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = null
        /**
         * Upload ID that identifies the multipart upload.
         */
        public var uploadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.MultipartUpload) : this() {
            this.checksumAlgorithm = x.checksumAlgorithm
            this.initiated = x.initiated
            this.initiator = x.initiator
            this.key = x.key
            this.owner = x.owner
            this.storageClass = x.storageClass
            this.uploadId = x.uploadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.MultipartUpload = MultipartUpload(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Initiator] inside the given [block]
         */
        public fun initiator(block: aws.sdk.kotlin.services.s3.model.Initiator.Builder.() -> kotlin.Unit) {
            this.initiator = aws.sdk.kotlin.services.s3.model.Initiator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Owner] inside the given [block]
         */
        public fun owner(block: aws.sdk.kotlin.services.s3.model.Owner.Builder.() -> kotlin.Unit) {
            this.owner = aws.sdk.kotlin.services.s3.model.Owner.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
