// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.DeleteMarkerEntry
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDeleteMarkerEntryDocument(reader: XmlTagReader): DeleteMarkerEntry {
    val builder = DeleteMarkerEntry.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Owner com.amazonaws.s3#DeleteMarkerEntry$Owner
            "Owner" -> builder.owner = deserializeOwnerDocument(curr)
            // Key com.amazonaws.s3#DeleteMarkerEntry$Key
            "Key" -> builder.key = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ObjectKey`)" }
            // VersionId com.amazonaws.s3#DeleteMarkerEntry$VersionId
            "VersionId" -> builder.versionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ObjectVersionId`)" }
            // IsLatest com.amazonaws.s3#DeleteMarkerEntry$IsLatest
            "IsLatest" -> builder.isLatest = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsLatest`)" }
            // LastModified com.amazonaws.s3#DeleteMarkerEntry$LastModified
            "LastModified" -> builder.lastModified = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3#LastModified`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
