// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeGetObjectAttributesPartsDocument(reader: XmlTagReader): GetObjectAttributesParts {
    val builder = GetObjectAttributesParts.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // TotalPartsCount com.amazonaws.s3#GetObjectAttributesParts$TotalPartsCount
            "PartsCount" -> builder.totalPartsCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3#PartsCount`)" }
            // PartNumberMarker com.amazonaws.s3#GetObjectAttributesParts$PartNumberMarker
            "PartNumberMarker" -> builder.partNumberMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#PartNumberMarker`)" }
            // NextPartNumberMarker com.amazonaws.s3#GetObjectAttributesParts$NextPartNumberMarker
            "NextPartNumberMarker" -> builder.nextPartNumberMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NextPartNumberMarker`)" }
            // MaxParts com.amazonaws.s3#GetObjectAttributesParts$MaxParts
            "MaxParts" -> builder.maxParts = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3#MaxParts`)" }
            // IsTruncated com.amazonaws.s3#GetObjectAttributesParts$IsTruncated
            "IsTruncated" -> builder.isTruncated = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsTruncated`)" }
            // Parts com.amazonaws.s3#GetObjectAttributesParts$Parts
            "Part" -> builder.parts = run {
                val el = deserializeObjectPartDocument(curr)
                createOrAppend(builder.parts, el)
            }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
