// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.InventoryConfiguration
import aws.sdk.kotlin.services.s3.model.InventoryIncludedObjectVersions
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeInventoryConfigurationDocument(reader: XmlTagReader): InventoryConfiguration {
    val builder = InventoryConfiguration.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Destination com.amazonaws.s3#InventoryConfiguration$Destination
            "Destination" -> builder.destination = deserializeInventoryDestinationDocument(curr)
            // IsEnabled com.amazonaws.s3#InventoryConfiguration$IsEnabled
            "IsEnabled" -> builder.isEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsEnabled`)" }
            // Filter com.amazonaws.s3#InventoryConfiguration$Filter
            "Filter" -> builder.filter = deserializeInventoryFilterDocument(curr)
            // Id com.amazonaws.s3#InventoryConfiguration$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#InventoryId`)" }
            // IncludedObjectVersions com.amazonaws.s3#InventoryConfiguration$IncludedObjectVersions
            "IncludedObjectVersions" -> builder.includedObjectVersions = curr.tryData()
                .parse { InventoryIncludedObjectVersions.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#InventoryIncludedObjectVersions`)" }
            // OptionalFields com.amazonaws.s3#InventoryConfiguration$OptionalFields
            "OptionalFields" -> builder.optionalFields = deserializeInventoryOptionalFieldsShape(curr)
            // Schedule com.amazonaws.s3#InventoryConfiguration$Schedule
            "Schedule" -> builder.schedule = deserializeInventoryScheduleDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
