// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.Event
import aws.sdk.kotlin.services.s3.model.LambdaFunctionConfiguration
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeLambdaFunctionConfigurationDocument(reader: XmlTagReader): LambdaFunctionConfiguration {
    val builder = LambdaFunctionConfiguration.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Id com.amazonaws.s3#LambdaFunctionConfiguration$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NotificationId`)" }
            // LambdaFunctionArn com.amazonaws.s3#LambdaFunctionConfiguration$LambdaFunctionArn
            "CloudFunction" -> builder.lambdaFunctionArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#LambdaFunctionArn`)" }
            // Events com.amazonaws.s3#LambdaFunctionConfiguration$Events
            "Event" -> builder.events = run {
                val el = curr.tryData()
                    .parse { Event.fromValue(it) }
                    .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#Event`)" }
                createOrAppend(builder.events, el)
            }
            // Filter com.amazonaws.s3#LambdaFunctionConfiguration$Filter
            "Filter" -> builder.filter = deserializeNotificationConfigurationFilterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
