// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm
import aws.sdk.kotlin.services.s3.model.ObjectVersion
import aws.sdk.kotlin.services.s3.model.ObjectVersionStorageClass
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeObjectVersionDocument(reader: XmlTagReader): ObjectVersion {
    val builder = ObjectVersion.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ETag com.amazonaws.s3#ObjectVersion$ETag
            "ETag" -> builder.eTag = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ETag`)" }
            // ChecksumAlgorithm com.amazonaws.s3#ObjectVersion$ChecksumAlgorithm
            "ChecksumAlgorithm" -> builder.checksumAlgorithm = run {
                val el = curr.tryData()
                    .parse { ChecksumAlgorithm.fromValue(it) }
                    .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#ChecksumAlgorithm`)" }
                createOrAppend(builder.checksumAlgorithm, el)
            }
            // Size com.amazonaws.s3#ObjectVersion$Size
            "Size" -> builder.size = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.s3#Size`)" }
            // StorageClass com.amazonaws.s3#ObjectVersion$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { ObjectVersionStorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#ObjectVersionStorageClass`)" }
            // Key com.amazonaws.s3#ObjectVersion$Key
            "Key" -> builder.key = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ObjectKey`)" }
            // VersionId com.amazonaws.s3#ObjectVersion$VersionId
            "VersionId" -> builder.versionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ObjectVersionId`)" }
            // IsLatest com.amazonaws.s3#ObjectVersion$IsLatest
            "IsLatest" -> builder.isLatest = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsLatest`)" }
            // LastModified com.amazonaws.s3#ObjectVersion$LastModified
            "LastModified" -> builder.lastModified = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3#LastModified`)" }
            // Owner com.amazonaws.s3#ObjectVersion$Owner
            "Owner" -> builder.owner = deserializeOwnerDocument(curr)
            // RestoreStatus com.amazonaws.s3#ObjectVersion$RestoreStatus
            "RestoreStatus" -> builder.restoreStatus = deserializeRestoreStatusDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
