/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3.serde;

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails;
import aws.sdk.kotlin.services.s3.internal.S3ErrorMetadataKt;
import aws.sdk.kotlin.services.s3.model.GetBucketAclResponse;
import aws.sdk.kotlin.services.s3.model.S3Exception;
import aws.sdk.kotlin.services.s3.serde.GrantsShapeDeserializerKt;
import aws.sdk.kotlin.services.s3.serde.OwnerDocumentDeserializerKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\f"}, d2={"deserializeGetBucketAclOperationBody", "", "builder", "Laws/sdk/kotlin/services/s3/model/GetBucketAclResponse$Builder;", "payload", "", "throwGetBucketAclError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "s3"})
@SourceDebugExtension(value={"SMAP\nGetBucketAclOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetBucketAclOperationDeserializer.kt\naws/sdk/kotlin/services/s3/serde/GetBucketAclOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class GetBucketAclOperationDeserializerKt {
    private static final Void throwGetBucketAclError(ExecutionContext context, HttpCall call, byte[] payload) {
        S3ErrorDetails $i$a$-checkNotNull-GetBucketAclOperationDeserializerKt$throwGetBucketAclError$errorDetails$222;
        HttpResponse wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        HttpCall wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            S3ErrorDetails s3ErrorDetails;
            if (payload == null && Intrinsics.areEqual((Object)call.getResponse().getStatus(), (Object)HttpStatusCode.Companion.getNotFound())) {
                s3ErrorDetails = new S3ErrorDetails("NotFound", null, null, null, 14, null);
            } else {
                byte[] byArray = payload;
                if (payload == null) {
                    boolean $i$a$-checkNotNull-GetBucketAclOperationDeserializerKt$throwGetBucketAclError$errorDetails$222 = false;
                    String $i$a$-checkNotNull-GetBucketAclOperationDeserializerKt$throwGetBucketAclError$errorDetails$222 = "unable to parse error from empty response";
                    throw new IllegalStateException($i$a$-checkNotNull-GetBucketAclOperationDeserializerKt$throwGetBucketAclError$errorDetails$222.toString());
                }
                s3ErrorDetails = S3ErrorMetadataKt.parseS3ErrorResponse(payload);
            }
            $i$a$-checkNotNull-GetBucketAclOperationDeserializerKt$throwGetBucketAclError$errorDetails$222 = s3ErrorDetails;
        }
        catch (Exception ex) {
            S3Exception s3Exception;
            S3Exception it = s3Exception = new S3Exception("Failed to parse response as 'restXml' error", ex);
            boolean bl = false;
            S3ErrorMetadataKt.setS3ErrorMetadata((Object)it, wrappedCall.getResponse(), null);
            throw (Throwable)((Object)s3Exception);
        }
        S3ErrorDetails errorDetails = $i$a$-checkNotNull-GetBucketAclOperationDeserializerKt$throwGetBucketAclError$errorDetails$222;
        errorDetails.getCode();
        S3Exception ex = new S3Exception(errorDetails.getMessage());
        S3ErrorMetadataKt.setS3ErrorMetadata((Object)ex, wrappedResponse, errorDetails);
        throw ex;
    }

    private static final void deserializeGetBucketAclOperationBody(GetBucketAclResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        while (root.nextTag() != null) {
            XmlTagReader curr;
            String string = curr.getTagName();
            if (Intrinsics.areEqual((Object)string, (Object)"AccessControlList")) {
                builder.setGrants(GrantsShapeDeserializerKt.deserializeGrantsShape(curr));
            } else if (Intrinsics.areEqual((Object)string, (Object)"Owner")) {
                builder.setOwner(OwnerDocumentDeserializerKt.deserializeOwnerDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwGetBucketAclError(ExecutionContext context, HttpCall call, byte[] payload) {
        return GetBucketAclOperationDeserializerKt.throwGetBucketAclError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeGetBucketAclOperationBody(GetBucketAclResponse.Builder builder, byte[] payload) {
        GetBucketAclOperationDeserializerKt.deserializeGetBucketAclOperationBody(builder, payload);
    }
}

