/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awssigning.AwsSignatureType;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSignerKt;
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification;
import aws.smithy.kotlin.runtime.auth.awssigning.SignatureCalculator;
import aws.smithy.kotlin.runtime.auth.awssigning.SignatureCalculatorKt;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.HashFunctionKt;
import aws.smithy.kotlin.runtime.hashing.HmacKt;
import aws.smithy.kotlin.runtime.text.encoding.HexKt;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J \u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0018\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Laws/smithy/kotlin/runtime/auth/awssigning/DefaultSignatureCalculator;", "Laws/smithy/kotlin/runtime/auth/awssigning/SignatureCalculator;", "sha256Provider", "Lkotlin/Function0;", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "Laws/smithy/kotlin/runtime/hashing/HashSupplier;", "(Lkotlin/jvm/functions/Function0;)V", "calculate", "", "signingKey", "", "stringToSign", "chunkStringToSign", "chunkBody", "prevSignature", "config", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "chunkTrailerStringToSign", "trailingHeaders", "canonicalRequest", "aws-signing-default"})
public final class DefaultSignatureCalculator
implements SignatureCalculator {
    @NotNull
    private final Function0<HashFunction> sha256Provider;

    public DefaultSignatureCalculator(@NotNull Function0<? extends HashFunction> sha256Provider) {
        Intrinsics.checkNotNullParameter(sha256Provider, (String)"sha256Provider");
        this.sha256Provider = sha256Provider;
    }

    public /* synthetic */ DefaultSignatureCalculator(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<? extends HashFunction>)function0);
    }

    @Override
    @NotNull
    public String calculate(@NotNull byte[] signingKey, @NotNull String stringToSign) {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)stringToSign, (String)"stringToSign");
        return HexKt.encodeToHex((byte[])HmacKt.hmac((byte[])signingKey, (byte[])StringsKt.encodeToByteArray((String)stringToSign), this.sha256Provider));
    }

    @Override
    @NotNull
    public String chunkStringToSign(@NotNull byte[] chunkBody, @NotNull byte[] prevSignature, @NotNull AwsSigningConfig config) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)chunkBody, (String)"chunkBody");
        Intrinsics.checkNotNullParameter((Object)prevSignature, (String)"prevSignature");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        StringBuilder $this$chunkStringToSign_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$chunkStringToSign_u24lambda_u240.append("AWS4-HMAC-SHA256-PAYLOAD");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$chunkStringToSign_u24lambda_u240.append(config.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$chunkStringToSign_u24lambda_u240.append(DefaultAwsSignerKt.getCredentialScope(config));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$chunkStringToSign_u24lambda_u240.append(StringsKt.decodeToString((byte[])prevSignature));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        String nonSignatureHeadersHash = WhenMappings.$EnumSwitchMapping$0[config.getSignatureType().ordinal()] == 1 ? SignatureCalculatorKt.access$eventStreamNonSignatureHeaders(config.getSigningDate()) : HashSpecification.EmptyBody.INSTANCE.getHash();
        StringBuilder stringBuilder6 = $this$chunkStringToSign_u24lambda_u240.append(nonSignatureHeadersHash);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        $this$chunkStringToSign_u24lambda_u240.append(HexKt.encodeToHex((byte[])HashFunctionKt.hash((byte[])chunkBody, this.sha256Provider)));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String chunkTrailerStringToSign(@NotNull byte[] trailingHeaders, @NotNull byte[] prevSignature, @NotNull AwsSigningConfig config) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)trailingHeaders, (String)"trailingHeaders");
        Intrinsics.checkNotNullParameter((Object)prevSignature, (String)"prevSignature");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        StringBuilder $this$chunkTrailerStringToSign_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$chunkTrailerStringToSign_u24lambda_u241.append("AWS4-HMAC-SHA256-TRAILER");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$chunkTrailerStringToSign_u24lambda_u241.append(config.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$chunkTrailerStringToSign_u24lambda_u241.append(DefaultAwsSignerKt.getCredentialScope(config));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$chunkTrailerStringToSign_u24lambda_u241.append(StringsKt.decodeToString((byte[])prevSignature));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        $this$chunkTrailerStringToSign_u24lambda_u241.append(HexKt.encodeToHex((byte[])HashFunctionKt.hash((byte[])trailingHeaders, this.sha256Provider)));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public byte[] signingKey(@NotNull AwsSigningConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] initialKey = StringsKt.encodeToByteArray((String)("AWS4" + config.getCredentials().getSecretAccessKey()));
        byte[] kDate = DefaultSignatureCalculator.signingKey$hmac(this, initialKey, config.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED_DATE));
        byte[] kRegion = DefaultSignatureCalculator.signingKey$hmac(this, kDate, config.getRegion());
        byte[] kService = DefaultSignatureCalculator.signingKey$hmac(this, kRegion, config.getService());
        return DefaultSignatureCalculator.signingKey$hmac(this, kService, "aws4_request");
    }

    @Override
    @NotNull
    public String stringToSign(@NotNull String canonicalRequest2, @NotNull AwsSigningConfig config) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)canonicalRequest2, (String)"canonicalRequest");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        StringBuilder $this$stringToSign_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$stringToSign_u24lambda_u242.append("AWS4-HMAC-SHA256");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$stringToSign_u24lambda_u242.append(config.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$stringToSign_u24lambda_u242.append(DefaultAwsSignerKt.getCredentialScope(config));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        $this$stringToSign_u24lambda_u242.append(HexKt.encodeToHex((byte[])HashFunctionKt.hash((byte[])StringsKt.encodeToByteArray((String)canonicalRequest2), this.sha256Provider)));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final byte[] signingKey$hmac(DefaultSignatureCalculator this$0, byte[] key, String message) {
        return HmacKt.hmac((byte[])key, (byte[])StringsKt.encodeToByteArray((String)message), this$0.sha256Provider);
    }

    public DefaultSignatureCalculator() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AwsSignatureType.values().length];
            try {
                nArray[AwsSignatureType.HTTP_REQUEST_EVENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

