/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awssigning.AwsSignatureType;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.CanonicalRequest;
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSignerKt;
import aws.smithy.kotlin.runtime.auth.awssigning.RequestMutator;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Laws/smithy/kotlin/runtime/auth/awssigning/DefaultRequestMutator;", "Laws/smithy/kotlin/runtime/auth/awssigning/RequestMutator;", "()V", "appendAuth", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "config", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "canonical", "Laws/smithy/kotlin/runtime/auth/awssigning/CanonicalRequest;", "signatureHex", "", "aws-signing-default"})
public final class DefaultRequestMutator
implements RequestMutator {
    @Override
    @NotNull
    public HttpRequest appendAuth(@NotNull AwsSigningConfig config, @NotNull CanonicalRequest canonical, @NotNull String signatureHex) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)canonical, (String)"canonical");
        Intrinsics.checkNotNullParameter((Object)signatureHex, (String)"signatureHex");
        switch (WhenMappings.$EnumSwitchMapping$0[config.getSignatureType().ordinal()]) {
            case 1: {
                String credential = "Credential=" + DefaultAwsSignerKt.credentialValue(config);
                String signedHeaders2 = "SignedHeaders=" + canonical.getSignedHeaders();
                String signature = "Signature=" + signatureHex;
                canonical.getRequest().getHeaders().set("Authorization", (Object)("AWS4-HMAC-SHA256 " + credential + ", " + signedHeaders2 + ", " + signature));
                break;
            }
            case 2: {
                canonical.getRequest().getUrl().getParameters().getDecodedParameters().put((Object)"X-Amz-Signature", (Object)signatureHex);
                break;
            }
            default: {
                String string = "Support for " + config.getSignatureType() + " is not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return canonical.getRequest().build();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AwsSignatureType.values().length];
            try {
                nArray[AwsSignatureType.HTTP_REQUEST_VIA_HEADERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AwsSignatureType.HTTP_REQUEST_VIA_QUERY_PARAMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

