/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.internal;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.http.engine.internal.HttpClientMetricAttributes;
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider;
import aws.smithy.kotlin.runtime.telemetry.metrics.AsyncMeasurement;
import aws.smithy.kotlin.runtime.telemetry.metrics.AsyncMeasurementHandle;
import aws.smithy.kotlin.runtime.telemetry.metrics.Histogram;
import aws.smithy.kotlin.runtime.telemetry.metrics.Meter;
import aws.smithy.kotlin.runtime.telemetry.metrics.MonotonicCounter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010E\u001a\u00020D\u0012\u0006\u00104\u001a\u000203\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\n\u001a\u00020\u00032\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\f\u001a\u00020\u00032\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\bH\u0002\u00a2\u0006\u0004\b\f\u0010\u000bR$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017R!\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R!\u0010$\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c8\u0006\u00a2\u0006\f\n\u0004\b$\u0010\u001e\u001a\u0004\b%\u0010 R\u0014\u0010&\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010#R$\u0010)\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u000f\"\u0004\b(\u0010\u0011R$\u0010,\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u000f\"\u0004\b+\u0010\u0011R$\u0010/\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010\u000f\"\u0004\b.\u0010\u0011R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0017\u00104\u001a\u0002038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R$\u0010:\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u000f\"\u0004\b9\u0010\u0011R$\u0010=\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u000f\"\u0004\b<\u0010\u0011R\u0014\u0010>\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010#R\u0014\u0010?\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010#R!\u0010@\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c8\u0006\u00a2\u0006\f\n\u0004\b@\u0010\u001e\u001a\u0004\bA\u0010 R!\u0010B\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c8\u0006\u00a2\u0006\f\n\u0004\bB\u0010\u001e\u001a\u0004\bC\u0010 \u00a8\u0006H"}, d2={"Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;", "Ljava/io/Closeable;", "Laws/smithy/kotlin/runtime/io/Closeable;", "", "close", "()V", "Laws/smithy/kotlin/runtime/telemetry/metrics/AsyncMeasurement;", "", "Laws/smithy/kotlin/runtime/telemetry/metrics/LongAsyncMeasurement;", "measurement", "recordConnectionState", "(Laws/smithy/kotlin/runtime/telemetry/metrics/AsyncMeasurement;)V", "recordRequestsState", "value", "getAcquiredConnections", "()J", "setAcquiredConnections", "(J)V", "acquiredConnections", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "bytesReceived", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "getBytesReceived", "()Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "bytesSent", "getBytesSent", "Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "", "Laws/smithy/kotlin/runtime/telemetry/metrics/DoubleHistogram;", "connectionAcquireDuration", "Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "getConnectionAcquireDuration", "()Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "Laws/smithy/kotlin/runtime/telemetry/metrics/AsyncMeasurementHandle;", "connectionLimitHandle", "Laws/smithy/kotlin/runtime/telemetry/metrics/AsyncMeasurementHandle;", "connectionUptime", "getConnectionUptime", "connectionUsageHandle", "getConnectionsLimit", "setConnectionsLimit", "connectionsLimit", "getIdleConnections", "setIdleConnections", "idleConnections", "getInFlightRequests", "setInFlightRequests", "inFlightRequests", "Laws/smithy/kotlin/runtime/telemetry/metrics/Meter;", "meter", "Laws/smithy/kotlin/runtime/telemetry/metrics/Meter;", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "provider", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "getProvider", "()Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "getQueuedRequests", "setQueuedRequests", "queuedRequests", "getRequestConcurrencyLimit", "setRequestConcurrencyLimit", "requestConcurrencyLimit", "requestsConcurrencyLimitHandle", "requestsHandle", "requestsQueuedDuration", "getRequestsQueuedDuration", "timeToFirstByteDuration", "getTimeToFirstByteDuration", "", "scope", "<init>", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;)V", "http-client"})
@SourceDebugExtension(value={"SMAP\nHttpClientMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientMetrics.kt\naws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics\n+ 2 AtomicFU.common.kt\nkotlinx/atomicfu/AtomicFU_commonKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n476#2,4:204\n476#2,4:208\n476#2,4:212\n476#2,4:216\n476#2,4:220\n476#2,4:224\n1#3:228\n1#3:239\n1603#4,9:229\n1855#4:238\n1856#4:240\n1612#4:241\n1855#4,2:242\n*S KotlinDebug\n*F\n+ 1 HttpClientMetrics.kt\naws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics\n*L\n131#1:204,4\n140#1:208,4\n149#1:212,4\n158#1:216,4\n167#1:220,4\n176#1:224,4\n195#1:239\n195#1:229,9\n195#1:238\n195#1:240\n195#1:241\n198#1:242,2\n*E\n"})
public final class HttpClientMetrics
implements Closeable {
    @NotNull
    private final TelemetryProvider provider;
    @NotNull
    private final Meter meter;
    @NotNull
    volatile /* synthetic */ long _connectionsLimit;
    static final /* synthetic */ AtomicLongFieldUpdater _connectionsLimit$FU;
    @NotNull
    private volatile /* synthetic */ long _idleConnections;
    private static final /* synthetic */ AtomicLongFieldUpdater _idleConnections$FU;
    @NotNull
    private volatile /* synthetic */ long _acquiredConnections;
    private static final /* synthetic */ AtomicLongFieldUpdater _acquiredConnections$FU;
    @NotNull
    volatile /* synthetic */ long _requestConcurrencyLimit;
    static final /* synthetic */ AtomicLongFieldUpdater _requestConcurrencyLimit$FU;
    @NotNull
    private volatile /* synthetic */ long _queuedRequests;
    private static final /* synthetic */ AtomicLongFieldUpdater _queuedRequests$FU;
    @NotNull
    private volatile /* synthetic */ long _inFlightRequests;
    private static final /* synthetic */ AtomicLongFieldUpdater _inFlightRequests$FU;
    @NotNull
    private final Histogram<Double> connectionAcquireDuration;
    @NotNull
    private final Histogram<Double> requestsQueuedDuration;
    @NotNull
    private final Histogram<Double> connectionUptime;
    @NotNull
    private final AsyncMeasurementHandle connectionLimitHandle;
    @NotNull
    private final AsyncMeasurementHandle connectionUsageHandle;
    @NotNull
    private final AsyncMeasurementHandle requestsConcurrencyLimitHandle;
    @NotNull
    private final AsyncMeasurementHandle requestsHandle;
    @NotNull
    private final MonotonicCounter bytesSent;
    @NotNull
    private final MonotonicCounter bytesReceived;
    @NotNull
    private final Histogram<Double> timeToFirstByteDuration;

    public HttpClientMetrics(@NotNull String scope, @NotNull TelemetryProvider provider) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        this.meter = this.provider.getMeterProvider().getOrCreateMeter(scope);
        this._connectionsLimit = 0L;
        this._idleConnections = 0L;
        this._acquiredConnections = 0L;
        this._requestConcurrencyLimit = 0L;
        this._queuedRequests = 0L;
        this._inFlightRequests = 0L;
        this.connectionAcquireDuration = this.meter.createDoubleHistogram("smithy.client.http.connections.acquire_duration", "s", "The amount of time requests take to acquire a connection from the pool");
        this.requestsQueuedDuration = this.meter.createDoubleHistogram("smithy.client.http.requests.queued_duration", "s", "The amount of time a request spent queued waiting to be executed by the HTTP client");
        this.connectionUptime = this.meter.createDoubleHistogram("smithy.client.http.connections.uptime", "s", "The amount of time a connection has been open");
        this.connectionLimitHandle = this.meter.createAsyncUpDownCounter("smithy.client.http.connections.limit", (Function1)new Function1<AsyncMeasurement<Long>, Unit>(this){
            final /* synthetic */ HttpClientMetrics this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AsyncMeasurement<Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                AsyncMeasurement.DefaultImpls.record$default(it, (Number)this.this$0._connectionsLimit, null, null, (int)6, null);
            }
        }, "{connection}", "Max connections configured for the HTTP client");
        this.connectionUsageHandle = this.meter.createAsyncUpDownCounter("smithy.client.http.connections.usage", (Function1)new Function1<AsyncMeasurement<Long>, Unit>((Object)this){

            public final void invoke(@NotNull AsyncMeasurement<Long> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                HttpClientMetrics.access$recordConnectionState((HttpClientMetrics)this.receiver, p0);
            }
        }, "{connection}", "Current state of connections (idle, acquired)");
        this.requestsConcurrencyLimitHandle = this.meter.createAsyncUpDownCounter("smithy.client.http.requests.limit", (Function1)new Function1<AsyncMeasurement<Long>, Unit>(this){
            final /* synthetic */ HttpClientMetrics this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AsyncMeasurement<Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                AsyncMeasurement.DefaultImpls.record$default(it, (Number)this.this$0._requestConcurrencyLimit, null, null, (int)6, null);
            }
        }, "{request}", "Max concurrent requests configured for the HTTP client");
        this.requestsHandle = this.meter.createAsyncUpDownCounter("smithy.client.http.requests.usage", (Function1)new Function1<AsyncMeasurement<Long>, Unit>((Object)this){

            public final void invoke(@NotNull AsyncMeasurement<Long> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                HttpClientMetrics.access$recordRequestsState((HttpClientMetrics)this.receiver, p0);
            }
        }, "{request}", "The current state of HTTP client request concurrency (queued, in-flight)");
        this.bytesSent = this.meter.createMonotonicCounter("smithy.client.http.bytes_sent", "By", "The total number of bytes sent by the HTTP client");
        this.bytesReceived = this.meter.createMonotonicCounter("smithy.client.http.bytes_received", "By", "The total number of bytes received by the HTTP client");
        this.timeToFirstByteDuration = this.meter.createDoubleHistogram("smithy.client.http.time_to_first_byte", "s", "The amount of time after a request has been sent spent waiting on a response from the remote server");
    }

    @NotNull
    public final TelemetryProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final Histogram<Double> getConnectionAcquireDuration() {
        return this.connectionAcquireDuration;
    }

    @NotNull
    public final Histogram<Double> getRequestsQueuedDuration() {
        return this.requestsQueuedDuration;
    }

    @NotNull
    public final Histogram<Double> getConnectionUptime() {
        return this.connectionUptime;
    }

    @NotNull
    public final MonotonicCounter getBytesSent() {
        return this.bytesSent;
    }

    @NotNull
    public final MonotonicCounter getBytesReceived() {
        return this.bytesReceived;
    }

    @NotNull
    public final Histogram<Double> getTimeToFirstByteDuration() {
        return this.timeToFirstByteDuration;
    }

    public final long getConnectionsLimit() {
        return this._connectionsLimit;
    }

    public final void setConnectionsLimit(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._connectionsLimit;
            boolean bl = false;
        } while (!_connectionsLimit$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getRequestConcurrencyLimit() {
        return this._requestConcurrencyLimit;
    }

    public final void setRequestConcurrencyLimit(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._requestConcurrencyLimit;
            boolean bl = false;
        } while (!_requestConcurrencyLimit$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getIdleConnections() {
        return this._idleConnections;
    }

    public final void setIdleConnections(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._idleConnections;
            boolean bl = false;
        } while (!_idleConnections$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getAcquiredConnections() {
        return this._acquiredConnections;
    }

    public final void setAcquiredConnections(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._acquiredConnections;
            boolean bl = false;
        } while (!_acquiredConnections$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getQueuedRequests() {
        return this._queuedRequests;
    }

    public final void setQueuedRequests(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._queuedRequests;
            boolean bl = false;
        } while (!_queuedRequests$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getInFlightRequests() {
        return this._inFlightRequests;
    }

    public final void setInFlightRequests(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._inFlightRequests;
            boolean bl = false;
        } while (!_inFlightRequests$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    private final void recordRequestsState(AsyncMeasurement<Long> measurement) {
        AsyncMeasurement.DefaultImpls.record$default(measurement, (Number)this.getInFlightRequests(), (Attributes)HttpClientMetricAttributes.INSTANCE.getInFlightRequest(), null, (int)4, null);
        AsyncMeasurement.DefaultImpls.record$default(measurement, (Number)this.getQueuedRequests(), (Attributes)HttpClientMetricAttributes.INSTANCE.getQueuedRequest(), null, (int)4, null);
    }

    private final void recordConnectionState(AsyncMeasurement<Long> measurement) {
        AsyncMeasurement.DefaultImpls.record$default(measurement, (Number)this.getIdleConnections(), (Attributes)HttpClientMetricAttributes.INSTANCE.getIdleConnection(), null, (int)4, null);
        AsyncMeasurement.DefaultImpls.record$default(measurement, (Number)this.getAcquiredConnections(), (Attributes)HttpClientMetricAttributes.INSTANCE.getAcquiredConnection(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$mapNotNullTo$iv$iv;
        Object $i$a$-runCatching-HttpClientMetrics$close$exceptions$82;
        Object $i$a$-runCatching-HttpClientMetrics$close$exceptions$72;
        Object $i$a$-runCatching-HttpClientMetrics$close$exceptions$62;
        Object $i$a$-runCatching-HttpClientMetrics$close$exceptions$52;
        Object object = new Result[4];
        AsyncMeasurementHandle asyncMeasurementHandle = this.connectionLimitHandle;
        int n = 0;
        Object[] objectArray = object;
        try {
            boolean $i$a$-runCatching-HttpClientMetrics$close$exceptions$52 = false;
            asyncMeasurementHandle.stop();
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$52 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$52 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = $i$a$-runCatching-HttpClientMetrics$close$exceptions$52;
        objectArray[n] = Result.box-impl((Object)object2);
        asyncMeasurementHandle = this.connectionUsageHandle;
        n = 1;
        objectArray = object;
        try {
            boolean $i$a$-runCatching-HttpClientMetrics$close$exceptions$62 = false;
            asyncMeasurementHandle.stop();
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$62 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$62 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = $i$a$-runCatching-HttpClientMetrics$close$exceptions$62;
        objectArray[n] = Result.box-impl((Object)object2);
        asyncMeasurementHandle = this.requestsHandle;
        n = 2;
        objectArray = object;
        try {
            boolean $i$a$-runCatching-HttpClientMetrics$close$exceptions$72 = false;
            asyncMeasurementHandle.stop();
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$72 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$72 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = $i$a$-runCatching-HttpClientMetrics$close$exceptions$72;
        objectArray[n] = Result.box-impl((Object)object2);
        asyncMeasurementHandle = this.requestsConcurrencyLimitHandle;
        n = 3;
        objectArray = object;
        try {
            boolean $i$a$-runCatching-HttpClientMetrics$close$exceptions$82 = false;
            asyncMeasurementHandle.stop();
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$82 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$82 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = $i$a$-runCatching-HttpClientMetrics$close$exceptions$82;
        objectArray[n] = Result.box-impl((Object)object2);
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])object);
        boolean $i$f$mapNotNull = false;
        $i$a$-runCatching-HttpClientMetrics$close$exceptions$82 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Throwable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object p0 = ((Result)element$iv$iv).unbox-impl();
            boolean bl2 = false;
            if (Result.exceptionOrNull-impl((Object)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List exceptions = (List)destination$iv$iv;
        object = (Throwable)CollectionsKt.firstOrNull((List)exceptions);
        if (object != null) {
            Object first = object;
            boolean bl = false;
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)exceptions, (int)1);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable p0 = (Throwable)element$iv;
                boolean bl4 = false;
                ExceptionsKt.addSuppressed((Throwable)first, (Throwable)p0);
            }
            throw first;
        }
    }

    public static final /* synthetic */ void access$recordConnectionState(HttpClientMetrics $this, AsyncMeasurement measurement) {
        $this.recordConnectionState((AsyncMeasurement<Long>)measurement);
    }

    public static final /* synthetic */ void access$recordRequestsState(HttpClientMetrics $this, AsyncMeasurement measurement) {
        $this.recordRequestsState((AsyncMeasurement<Long>)measurement);
    }

    static {
        _connectionsLimit$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_connectionsLimit");
        _idleConnections$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_idleConnections");
        _acquiredConnections$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_acquiredConnections");
        _requestConcurrencyLimit$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_requestConcurrencyLimit");
        _queuedRequests$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_queuedRequests");
        _inFlightRequests$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_inFlightRequests");
    }
}

