/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.json;

import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.json.JsonLexer;
import aws.smithy.kotlin.runtime.serde.json.JsonLexerKt;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamReader;
import aws.smithy.kotlin.runtime.serde.json.JsonToken;
import aws.smithy.kotlin.runtime.serde.json.LexerState;
import aws.smithy.kotlin.runtime.serde.json.StateManager;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\bH\u0002J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\u00062\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J)\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0016\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0082\bJ\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010 \u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u000eH\u0002J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\u000f\u0010$\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010&J\u000f\u0010'\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u000eH\u0002J\u0014\u0010*\u001a\u00020\f2\n\u0010+\u001a\u00060,j\u0002`-H\u0002J\b\u0010.\u001a\u00020\bH\u0002J\u0018\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\bH\u0002J\b\u00102\u001a\u00020\bH\u0002J\b\u00103\u001a\u00020\bH\u0002J\b\u00104\u001a\u00020\u000fH\u0002J\b\u00105\u001a\u00020\bH\u0002J\b\u00106\u001a\u00020\fH\u0016J\b\u00107\u001a\u00020\bH\u0002J\b\u00108\u001a\u00020\bH\u0002J\b\u00109\u001a\u00020\bH\u0002J\b\u0010:\u001a\u00020\bH\u0002J\b\u0010;\u001a\u00020\bH\u0002J\b\u0010<\u001a\u00020\bH\u0002J\b\u0010=\u001a\u00020\bH\u0002J+\u0010>\u001a\u00020\u00142\b\u0010?\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0@\"\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010AR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonLexer;", "Laws/smithy/kotlin/runtime/serde/json/JsonStreamReader;", "data", "", "([B)V", "idx", "", "peeked", "Laws/smithy/kotlin/runtime/serde/json/JsonToken;", "state", "Laws/smithy/kotlin/runtime/serde/json/StateManager;", "consume", "", "expected", "", "", "doPeek", "endArray", "endObject", "fail", "", "message", "offset", "cause", "", "lexerCheck", "value", "", "lazyMessage", "Lkotlin/Function0;", "", "nextNonWhitespace", "peek", "(Z)Ljava/lang/Character;", "nextOrThrow", "nextToken", "peekByte", "", "()Ljava/lang/Byte;", "peekChar", "()Ljava/lang/Character;", "peekOrThrow", "readDigits", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "readKeyword", "readLiteral", "expectedString", "token", "readName", "readNumber", "readQuoted", "readToken", "skipNext", "startArray", "startObject", "stateArrayFirstValueOrEnd", "stateArrayNextValueOrEnd", "stateObjectFieldValue", "stateObjectFirstKeyOrEnd", "stateObjectNextKeyOrEnd", "unexpectedToken", "found", "", "(Ljava/lang/Character;[Ljava/lang/String;)Ljava/lang/Void;", "serde-json"})
@SourceDebugExtension(value={"SMAP\nJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLexer.kt\naws/smithy/kotlin/runtime/serde/json/JsonLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,444:1\n360#1,5:446\n360#1,5:451\n359#1,6:456\n359#1,6:464\n1#2:445\n1174#3,2:462\n*S KotlinDebug\n*F\n+ 1 JsonLexer.kt\naws/smithy/kotlin/runtime/serde/json/JsonLexer\n*L\n161#1:446,5\n177#1:451,5\n227#1:456,6\n318#1:464,6\n311#1:462,2\n*E\n"})
public final class JsonLexer
implements JsonStreamReader {
    @NotNull
    private final byte[] data;
    @Nullable
    private JsonToken peeked;
    @NotNull
    private final StateManager state;
    private int idx;

    public JsonLexer(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.state = new StateManager(null, null, 3, null);
    }

    @Override
    @NotNull
    public JsonToken nextToken() {
        JsonToken next = this.peek();
        this.peeked = null;
        this.state.update();
        return next;
    }

    @Override
    @NotNull
    public JsonToken peek() {
        JsonToken jsonToken = this.peeked;
        if (jsonToken == null) {
            JsonToken jsonToken2;
            JsonToken it = jsonToken2 = this.doPeek();
            boolean bl = false;
            this.peeked = it;
            jsonToken = jsonToken2;
        }
        return jsonToken;
    }

    @Override
    public void skipNext() {
        int startDepth = this.state.getSize();
        this.nextToken();
        while (this.state.getSize() > startDepth) {
            this.nextToken();
        }
    }

    private final JsonToken doPeek() {
        JsonToken jsonToken;
        try {
            JsonToken jsonToken2;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.getCurrent().ordinal()]) {
                case 1: {
                    jsonToken2 = this.readToken();
                    break;
                }
                case 2: {
                    jsonToken2 = this.stateArrayFirstValueOrEnd();
                    break;
                }
                case 3: {
                    jsonToken2 = this.stateArrayNextValueOrEnd();
                    break;
                }
                case 4: {
                    jsonToken2 = this.stateObjectFirstKeyOrEnd();
                    break;
                }
                case 5: {
                    jsonToken2 = this.stateObjectNextKeyOrEnd();
                    break;
                }
                case 6: {
                    jsonToken2 = this.stateObjectFieldValue();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            jsonToken = jsonToken2;
        }
        catch (DeserializationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DeserializationException((Throwable)ex);
        }
        return jsonToken;
    }

    private final JsonToken stateObjectFirstKeyOrEnd() {
        JsonToken jsonToken;
        Character chr;
        Character c = chr = this.nextNonWhitespace(true);
        char c2 = '}';
        if (c != null && c.charValue() == c2) {
            jsonToken = this.endObject();
        } else {
            Character c3 = chr;
            c2 = '\"';
            if (c3 != null && c3.charValue() == c2) {
                jsonToken = this.readName();
            } else {
                String[] stringArray = new String[]{"\"", "}"};
                this.unexpectedToken(chr, stringArray);
                throw new KotlinNothingValueException();
            }
        }
        return jsonToken;
    }

    private final JsonToken stateObjectNextKeyOrEnd() {
        JsonToken jsonToken;
        Character chr;
        Character c = chr = this.nextNonWhitespace(true);
        char c2 = '}';
        if (c != null && c.charValue() == c2) {
            jsonToken = this.endObject();
        } else {
            Character c3 = chr;
            c2 = ',';
            if (c3 != null && c3.charValue() == c2) {
                this.consume(',');
                this.nextNonWhitespace(true);
                jsonToken = this.readName();
            } else {
                String[] stringArray = new String[]{",", "}"};
                this.unexpectedToken(chr, stringArray);
                throw new KotlinNothingValueException();
            }
        }
        return jsonToken;
    }

    private final JsonToken stateObjectFieldValue() {
        Character chr;
        Character c = chr = this.nextNonWhitespace(true);
        char c2 = ':';
        if (c == null || c.charValue() != c2) {
            String[] stringArray = new String[]{":"};
            this.unexpectedToken(chr, stringArray);
            throw new KotlinNothingValueException();
        }
        this.consume(':');
        this.state.mutate((Function1<? super List<LexerState>, Unit>)((Function1)stateObjectFieldValue.1.INSTANCE));
        return this.readToken();
    }

    private final JsonToken stateArrayFirstValueOrEnd() {
        JsonToken jsonToken;
        Character c = this.nextNonWhitespace(true);
        char c2 = ']';
        if (c != null && c.charValue() == c2) {
            jsonToken = this.endArray();
        } else {
            this.state.mutate((Function1<? super List<LexerState>, Unit>)((Function1)stateArrayFirstValueOrEnd.1.INSTANCE));
            jsonToken = this.readToken();
        }
        return jsonToken;
    }

    private final JsonToken stateArrayNextValueOrEnd() {
        JsonToken jsonToken;
        Character chr;
        Character c = chr = this.nextNonWhitespace(true);
        char c2 = ']';
        if (c != null && c.charValue() == c2) {
            jsonToken = this.endArray();
        } else {
            Character c3 = chr;
            c2 = ',';
            if (c3 != null && c3.charValue() == c2) {
                this.consume(',');
                jsonToken = this.readToken();
            } else {
                String[] stringArray = new String[]{",", "]"};
                this.unexpectedToken(chr, stringArray);
                throw new KotlinNothingValueException();
            }
        }
        return jsonToken;
    }

    private final JsonToken startObject() {
        this.consume('{');
        this.state.mutate((Function1<? super List<LexerState>, Unit>)((Function1)startObject.1.INSTANCE));
        return JsonToken.BeginObject.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonToken endObject() {
        void value$iv;
        this.consume('}');
        LexerState top = this.state.getCurrent();
        JsonLexer jsonLexer = this;
        boolean bl = top == LexerState.ObjectFirstKeyOrEnd || top == LexerState.ObjectNextKeyOrEnd;
        int offset$iv = this.idx - 1;
        boolean $i$f$lexerCheck = false;
        if (value$iv == false) {
            void this_$iv;
            boolean bl2 = false;
            String message$iv = "Unexpected close `}` encountered";
            JsonLexer.fail$default((JsonLexer)this_$iv, message$iv.toString(), offset$iv, null, 4, null);
            throw new KotlinNothingValueException();
        }
        this.state.mutate((Function1<? super List<LexerState>, Unit>)((Function1)endObject.2.INSTANCE));
        return JsonToken.EndObject.INSTANCE;
    }

    private final JsonToken startArray() {
        this.consume('[');
        this.state.mutate((Function1<? super List<LexerState>, Unit>)((Function1)startArray.1.INSTANCE));
        return JsonToken.BeginArray.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonToken endArray() {
        void value$iv;
        this.consume(']');
        LexerState top = this.state.getCurrent();
        JsonLexer jsonLexer = this;
        boolean bl = top == LexerState.ArrayFirstValueOrEnd || top == LexerState.ArrayNextValueOrEnd;
        int offset$iv = this.idx - 1;
        boolean $i$f$lexerCheck = false;
        if (value$iv == false) {
            void this_$iv;
            boolean bl2 = false;
            String message$iv = "Unexpected close `]` encountered";
            JsonLexer.fail$default((JsonLexer)this_$iv, message$iv.toString(), offset$iv, null, 4, null);
            throw new KotlinNothingValueException();
        }
        this.state.mutate((Function1<? super List<LexerState>, Unit>)((Function1)endArray.2.INSTANCE));
        return JsonToken.EndArray.INSTANCE;
    }

    private final JsonToken readName() {
        char chr = this.peekOrThrow();
        if (chr != '\"') {
            String[] stringArray = new String[]{"\""};
            this.unexpectedToken(Character.valueOf(chr), stringArray);
            throw new KotlinNothingValueException();
        }
        String name = this.readQuoted();
        this.state.mutate((Function1<? super List<LexerState>, Unit>)((Function1)readName.1.INSTANCE));
        return new JsonToken.Name(name);
    }

    private final JsonToken readToken() {
        JsonToken jsonToken;
        Character chr;
        Character c = chr = this.nextNonWhitespace(true);
        char c2 = '{';
        if (c != null && c.charValue() == c2) {
            jsonToken = this.startObject();
        } else {
            Character c3 = chr;
            c2 = '[';
            if (c3 != null && c3.charValue() == c2) {
                jsonToken = this.startArray();
            } else {
                Character c4 = chr;
                c2 = '\"';
                if (c4 != null && c4.charValue() == c2) {
                    jsonToken = new JsonToken.String(this.readQuoted());
                } else {
                    boolean bl;
                    boolean bl2;
                    Character c5 = chr;
                    c2 = 't';
                    if (c5 != null && c5.charValue() == c2) {
                        bl2 = true;
                    } else {
                        Character c6 = chr;
                        c2 = 'f';
                        bl2 = c6 != null && c6.charValue() == c2;
                    }
                    if (bl2) {
                        bl = true;
                    } else {
                        Character c7 = chr;
                        c2 = 'n';
                        bl = c7 != null && c7.charValue() == c2;
                    }
                    if (bl) {
                        jsonToken = this.readKeyword();
                    } else {
                        boolean bl3;
                        Character c8 = chr;
                        c2 = '-';
                        if (c8 != null && c8.charValue() == c2) {
                            bl3 = true;
                        } else {
                            CharRange charRange = new CharRange('0', '9');
                            bl3 = chr != null && charRange.contains(chr.charValue());
                        }
                        if (bl3) {
                            jsonToken = this.readNumber();
                        } else if (chr == null) {
                            jsonToken = JsonToken.EndDocument.INSTANCE;
                        } else {
                            String[] stringArray = new String[]{"{", "[", "\"", "null", "true", "false", "<number>"};
                            this.unexpectedToken(chr, stringArray);
                            throw new KotlinNothingValueException();
                        }
                    }
                }
            }
        }
        return jsonToken;
    }

    private final JsonToken readNumber() {
        StringBuilder stringBuilder;
        StringBuilder $this$readNumber_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Character c = this.peekChar();
        char c2 = '-';
        if (c != null && c.charValue() == c2) {
            $this$readNumber_u24lambda_u243.append(this.nextOrThrow());
        }
        this.readDigits($this$readNumber_u24lambda_u243);
        Character c3 = this.peekChar();
        c2 = '.';
        if (c3 != null && c3.charValue() == c2) {
            $this$readNumber_u24lambda_u243.append(this.nextOrThrow());
            this.readDigits($this$readNumber_u24lambda_u243);
        }
        if (CollectionsKt.contains((Iterable)JsonLexerKt.access$getEXP$p(), (Object)this.peekChar())) {
            $this$readNumber_u24lambda_u243.append(this.nextOrThrow());
            if (CollectionsKt.contains((Iterable)JsonLexerKt.access$getPLUS_MINUS$p(), (Object)this.peekChar())) {
                $this$readNumber_u24lambda_u243.append(this.nextOrThrow());
            }
            this.readDigits($this$readNumber_u24lambda_u243);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String value = string;
        boolean value$iv = ((CharSequence)value).length() > 0;
        int offset$iv = this.idx;
        boolean $i$f$lexerCheck = false;
        if (!value$iv) {
            boolean bl2 = false;
            String message$iv = "Invalid number, expected `-` || 0..9, found `" + this.peekChar() + '`';
            JsonLexer.fail$default(this, message$iv.toString(), offset$iv, null, 4, null);
            throw new KotlinNothingValueException();
        }
        return new JsonToken.Number(value);
    }

    private final void readDigits(Appendable appendable) {
        while (CollectionsKt.contains((Iterable)JsonLexerKt.access$getDIGITS$p(), (Object)this.peekChar())) {
            appendable.append(this.nextOrThrow());
        }
    }

    private final String readQuoted() {
        String string;
        this.consume('\"');
        int start = this.idx;
        char chr = this.peekOrThrow();
        boolean needsUnescaped = false;
        while (chr != '\"') {
            if (chr == '\\') {
                needsUnescaped = true;
                this.nextOrThrow();
                char c = this.nextOrThrow();
                if (c == 'u') {
                    if (this.idx + 4 >= this.data.length) {
                        JsonLexer.fail$default(this, "Unexpected EOF reading escaped unicode string", this.idx, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                    this.idx += 4;
                } else if (!(((((((c == '\\' ? true : c == '/') ? true : c == '\"') ? true : c == 'b') ? true : c == 'f') ? true : c == 'r') ? true : c == 'n') ? true : c == 't')) {
                    JsonLexer.fail$default(this, "Invalid escape character: `" + c + '`', this.idx - 1, null, 4, null);
                    throw new KotlinNothingValueException();
                }
            } else {
                if (JsonLexerKt.access$isControl(chr)) {
                    JsonLexer.fail$default(this, "Unexpected control character: `" + chr + '`', 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                int n = this.idx;
                this.idx = n + 1;
            }
            chr = this.peekOrThrow();
        }
        String value = StringsKt.decodeToString$default((byte[])this.data, (int)start, (int)this.idx, (boolean)false, (int)4, null);
        this.consume('\"');
        if (needsUnescaped) {
            String string2;
            try {
                string2 = JsonLexerKt.access$unescape(value);
            }
            catch (Exception ex) {
                String string3 = ex.getMessage();
                if (string3 == null) {
                    string3 = "Invalid escaped string";
                }
                JsonLexer.fail$default(this, string3, start - 1, null, 4, null);
                throw new KotlinNothingValueException();
            }
            string = string2;
        } else {
            string = value;
        }
        return string;
    }

    private final JsonToken readKeyword() {
        JsonToken jsonToken;
        char ch = this.peekOrThrow();
        if (ch == 't') {
            jsonToken = this.readLiteral("true", new JsonToken.Bool(true));
        } else if (ch == 'f') {
            jsonToken = this.readLiteral("false", new JsonToken.Bool(false));
        } else if (ch == 'n') {
            jsonToken = this.readLiteral("null", JsonToken.Null.INSTANCE);
        } else {
            JsonLexer.fail$default(this, "Unable to handle keyword starting with '" + ch + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return jsonToken;
    }

    private final JsonToken readLiteral(String expectedString, JsonToken token) {
        this.consume(expectedString);
        return token;
    }

    private final Character nextNonWhitespace(boolean peek) {
        while (true) {
            Character c = this.peekChar();
            boolean bl = c != null ? CharsKt.isWhitespace((char)c.charValue()) : false;
            if (!bl) break;
            int n = this.idx;
            this.idx = n + 1;
        }
        return peek ? this.peekChar() : Character.valueOf(this.nextOrThrow());
    }

    static /* synthetic */ Character nextNonWhitespace$default(JsonLexer jsonLexer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return jsonLexer.nextNonWhitespace(bl);
    }

    private final void consume(String expected) {
        CharSequence $this$forEach$iv = expected;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            this.consume(it);
        }
    }

    private final void consume(char expected) {
        char chr = (char)this.data[this.idx];
        boolean value$iv = chr == expected;
        int offset$iv = this.idx;
        boolean $i$f$lexerCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Unexpected char `" + chr + "` expected `" + expected + '`';
            JsonLexer.fail$default(this, message$iv.toString(), offset$iv, null, 4, null);
            throw new KotlinNothingValueException();
        }
        int n = this.idx;
        this.idx = n + 1;
    }

    private final Byte peekByte() {
        return ArraysKt.getOrNull((byte[])this.data, (int)this.idx);
    }

    private final Character peekChar() {
        Byte by = this.peekByte();
        return by != null ? Character.valueOf((char)by.byteValue()) : null;
    }

    private final char peekOrThrow() {
        Character c = this.peekChar();
        if (c == null) {
            throw new IllegalStateException("Unexpected EOF");
        }
        return c.charValue();
    }

    private final char nextOrThrow() {
        char c;
        char it = c = this.peekOrThrow();
        boolean bl = false;
        int n = this.idx;
        this.idx = n + 1;
        return c;
    }

    private final Void unexpectedToken(Character found, String ... expected) {
        String pluralModifier = expected.length > 1 ? " one of" : "";
        String formatted2 = ArraysKt.joinToString$default((Object[])expected, (CharSequence)", ", null, null, (int)0, null, (Function1)unexpectedToken.formatted.1.INSTANCE, (int)30, null);
        JsonLexer.fail$default(this, "found `" + found + "`, expected" + pluralModifier + ' ' + formatted2, 0, null, 6, null);
        throw new KotlinNothingValueException();
    }

    private final Void fail(String message, int offset, Throwable cause) {
        throw new DeserializationException("Unexpected JSON token at offset " + offset + "; " + message, cause);
    }

    static /* synthetic */ Void fail$default(JsonLexer jsonLexer, String string, int n, Throwable throwable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = jsonLexer.idx;
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        return jsonLexer.fail(string, n, throwable);
    }

    private final void lexerCheck(boolean value, int offset, Function0<? extends Object> lazyMessage) {
        boolean $i$f$lexerCheck = false;
        if (!value) {
            Object message = lazyMessage.invoke();
            JsonLexer.fail$default(this, message.toString(), offset, null, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    static /* synthetic */ void lexerCheck$default(JsonLexer $this, boolean value, int offset, Function0 lazyMessage, int n, Object object) {
        if ((n & 2) != 0) {
            offset = $this.idx;
        }
        boolean $i$f$lexerCheck = false;
        if (!value) {
            Object message = lazyMessage.invoke();
            JsonLexer.fail$default($this, message.toString(), offset, null, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LexerState.values().length];
            try {
                nArray[LexerState.Initial.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ArrayFirstValueOrEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ArrayNextValueOrEnd.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ObjectFirstKeyOrEnd.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ObjectNextKeyOrEnd.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ObjectFieldValue.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

