package co.kuali.coeus.s3.conv;


import java.util.List;

public class ConversionInfo {
    private String targetSchema;
    private String table;
    private String dataColumn;
    private List<String> pkColumns;
    private String contentTypeColumn;
    private String fileNameColumn;
    private List<String> additionalMetadataColumns;
    private boolean nullConverted;

    public String getTargetSchema() {
        return targetSchema;
    }

    /**
     * @param targetSchema the target schema.  Optional.  Can be null or blank.
     */
    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public String getTable() {
        return table;
    }

    /**
     * @param table the target table.  Required.  Cannot be null or blank.
     */
    public void setTable(String table) {
        this.table = table;
    }

    public String getDataColumn() {
        return dataColumn;
    }

    /**
     * @param dataColumn the data column.  Required.  Cannot be null or blank.
     */
    public void setDataColumn(String dataColumn) {
        this.dataColumn = dataColumn;
    }

    public List<String> getPkColumns() {
        return pkColumns;
    }

    /**
     * @param pkColumns the primary key column.  At least one is required.
     */
    public void setPkColumns(List<String> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public String getContentTypeColumn() {
        return contentTypeColumn;
    }

    /**
     * @param contentTypeColumn the content type column. Optional. Can be null or blank.
     */
    public void setContentTypeColumn(String contentTypeColumn) {
        this.contentTypeColumn = contentTypeColumn;
    }

    public String getFileNameColumn() {
        return fileNameColumn;
    }

    /**
     * @param fileNameColumn the file name column. Optional. Can be null or blank.
     */
    public void setFileNameColumn(String fileNameColumn) {
        this.fileNameColumn = fileNameColumn;
    }

    public List<String> getAdditionalMetadataColumns() {
        return additionalMetadataColumns;
    }

    /**
     * @param additionalMetadataColumns any additional metadata to add to S3.  Optional. Can be null. Elements can be null or blank
     */
    public void setAdditionalMetadataColumns(List<String> additionalMetadataColumns) {
        this.additionalMetadataColumns = additionalMetadataColumns;
    }

    public boolean isNullConverted() {
        return nullConverted;
    }

    /**
     * @param nullConverted Whether or not to clear files from the database after they have been converted.
     */
    public void setNullConverted(boolean nullConverted) {
        this.nullConverted = nullConverted;
    }


}
