package co.kuali.coeus.s3.conv;

public interface ConversionService {

    /**
     * Moves binary data from a table to S3 while adding an S3_ID column to the target table and removing
     * the binary data from the target table. As each record is processed, the db transaction will be committed
     * @param info the information related to the source table to be converted.  See {@link ConversionInfo} for more
     *             information about which fields are required or optional.  Cannot be null.
     * @throws IllegalArgumentException if any of the required fields on the info are not valid or the info object is null
     */
    void convert(ConversionInfo info);
}
