/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.dialog.directives;

import com.amazon.speech.slu.ConfirmationStatus;
import com.amazon.speech.slu.Intent;
import com.amazon.speech.slu.Slot;
import com.amazon.speech.speechlet.dialog.directives.DialogSlot;
import java.util.HashMap;
import java.util.Map;

public class DialogIntent {
    private String name;
    private ConfirmationStatus confirmationStatus;
    private Map<String, DialogSlot> slots;

    public DialogIntent(String name, ConfirmationStatus confirmationStatus, Map<String, DialogSlot> slots) {
        this.name = name;
        this.confirmationStatus = confirmationStatus;
        this.slots = slots == null ? null : new HashMap<String, DialogSlot>(slots);
    }

    public DialogIntent(String name, ConfirmationStatus confirmationStatus) {
        this(name, confirmationStatus, null);
    }

    public DialogIntent(String name) {
        this(name, null, null);
    }

    public DialogIntent(String name, Map<String, DialogSlot> slots) {
        this(name, null, slots);
    }

    public DialogIntent() {
        this(null, null, null);
    }

    public DialogIntent(Intent requestIntent) {
        this(requestIntent.getName(), requestIntent.getConfirmationStatus(), DialogIntent.convertSlots(requestIntent.getSlots()));
    }

    private static Map<String, DialogSlot> convertSlots(Map<String, Slot> requestSlots) {
        HashMap<String, DialogSlot> slots = new HashMap<String, DialogSlot>();
        for (Map.Entry<String, Slot> entry : requestSlots.entrySet()) {
            slots.put(entry.getKey(), new DialogSlot(entry.getValue()));
        }
        return slots;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConfirmationStatus getConfirmationStatus() {
        return this.confirmationStatus;
    }

    public void setConfirmationStatus(ConfirmationStatus confirmationStatus) {
        this.confirmationStatus = confirmationStatus;
    }

    public Map<String, DialogSlot> getSlots() {
        return this.slots;
    }

    public void setSlots(Map<String, DialogSlot> slots) {
        this.slots = slots == null ? null : new HashMap<String, DialogSlot>(slots);
    }
}

