/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.interfaces.audioplayer.request;

import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.AudioPlayerRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="AudioPlayer.PlaybackFinished")
public class PlaybackFinishedRequest
extends AudioPlayerRequest {
    private final long offsetInMilliseconds;
    private final String token;

    public static Builder builder() {
        return new Builder();
    }

    private PlaybackFinishedRequest(Builder builder) {
        super(builder);
        this.offsetInMilliseconds = builder.offsetInMilliseconds;
        this.token = builder.token;
    }

    private PlaybackFinishedRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="intent") long offsetInMilliseconds, @JsonProperty(value="token") String token) {
        super(requestId, timestamp, locale);
        this.offsetInMilliseconds = offsetInMilliseconds;
        this.token = token;
    }

    public long getOffsetInMilliseconds() {
        return this.offsetInMilliseconds;
    }

    public String getToken() {
        return this.token;
    }

    public static final class Builder
    extends SpeechletRequest.SpeechletRequestBuilder<Builder, PlaybackFinishedRequest> {
        private long offsetInMilliseconds;
        private String token;

        private Builder() {
        }

        public Builder withOffsetInMilliseconds(long offsetInMilliseconds) {
            this.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @Override
        public PlaybackFinishedRequest build() {
            Validate.notBlank((CharSequence)this.getRequestId(), (String)"RequestId must be defined", (Object[])new Object[0]);
            return new PlaybackFinishedRequest(this);
        }
    }
}

