/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.services;

import com.amazon.speech.speechlet.services.ApiClient;
import com.amazon.speech.speechlet.services.ApiClientResponse;
import com.amazon.speech.speechlet.services.DirectiveEnvelope;
import com.amazon.speech.speechlet.services.DirectiveService;
import com.amazon.speech.speechlet.services.ServiceException;
import java.io.IOException;
import java.util.HashMap;

public class DirectiveServiceClient
implements DirectiveService {
    private static final String directiveApiPath = "/v1/directives";
    private ApiClient apiClient;

    public DirectiveServiceClient() {
        this(new ApiClient());
    }

    protected DirectiveServiceClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void enqueue(DirectiveEnvelope directiveEnvelope, String apiEndpoint, String token) throws ServiceException {
        String url = apiEndpoint + directiveApiPath;
        this.dispatch(directiveEnvelope, url, token);
    }

    private void dispatch(DirectiveEnvelope directiveEnvelope, String url, String token) throws ServiceException {
        ApiClientResponse apiClientResponse;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        headers.put("Content-Type", "application/json");
        try {
            apiClientResponse = this.apiClient.post(url, headers, directiveEnvelope.toJsonString());
        }
        catch (IOException e) {
            throw new ServiceException("Call to directive service failed: " + e.getMessage(), e);
        }
        int apiClientResponseCode = apiClientResponse.getResponseCode();
        if (apiClientResponseCode < 200 || apiClientResponseCode >= 300) {
            throw new ServiceException("Directive Service returned an error with code " + apiClientResponseCode + " and with body " + apiClientResponse.getResponseBody());
        }
    }
}

