/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.servlet;

import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.SpeechletToSpeechletV2Adapter;
import com.amazon.speech.speechlet.SpeechletV2;
import com.amazon.speech.speechlet.authentication.SpeechletRequestSignatureVerifier;
import com.amazon.speech.speechlet.servlet.ServletSpeechletRequestHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechletServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SpeechletServlet.class);
    private static final long serialVersionUID = 3257254794185762002L;
    private transient SpeechletV2 speechlet;
    private transient ServletSpeechletRequestHandler speechletRequestHandler;
    private final boolean disableRequestSignatureCheck = Boolean.parseBoolean(System.getProperty("com.amazon.speech.speechlet.servlet.disableRequestSignatureCheck"));

    public SpeechletServlet() {
        this.speechletRequestHandler = new ServletSpeechletRequestHandler();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        byte[] serializedSpeechletRequest = IOUtils.toByteArray((InputStream)request.getInputStream());
        byte[] outputBytes = null;
        try {
            if (this.disableRequestSignatureCheck) {
                log.warn("Warning: Speechlet request signature verification has been disabled!");
            } else {
                SpeechletRequestSignatureVerifier.checkRequestSignature(serializedSpeechletRequest, request.getHeader("Signature"), request.getHeader("SignatureCertChainUrl"));
            }
            outputBytes = this.speechletRequestHandler.handleSpeechletCall(this.speechlet, serializedSpeechletRequest);
        }
        catch (SpeechletRequestHandlerException | SecurityException ex) {
            int statusCode = 400;
            log.error("Exception occurred in doPost, returning status code {}", (Object)statusCode, (Object)ex);
            response.sendError(statusCode, ex.getMessage());
            return;
        }
        catch (Exception ex) {
            int statusCode = 500;
            log.error("Exception occurred in doPost, returning status code {}", (Object)statusCode, (Object)ex);
            response.sendError(statusCode, ex.getMessage());
            return;
        }
        response.setContentType("application/json");
        response.setStatus(200);
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentLength(outputBytes.length);
            out.write(outputBytes);
        }
    }

    public Speechlet getSpeechlet() {
        if (this.speechlet instanceof SpeechletToSpeechletV2Adapter) {
            return ((SpeechletToSpeechletV2Adapter)this.speechlet).getSpeechlet();
        }
        return null;
    }

    public SpeechletV2 getSpeechletV2() {
        return this.speechlet;
    }

    public void setSpeechlet(Speechlet speechlet) {
        this.speechlet = new SpeechletToSpeechletV2Adapter(speechlet);
    }

    public void setSpeechlet(SpeechletV2 speechlet) {
        this.speechlet = speechlet;
    }
}

