/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appintegrations;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.appintegrations.AmazonAppIntegrationsAsync;
import com.amazonaws.services.appintegrations.AmazonAppIntegrationsAsyncClientBuilder;
import com.amazonaws.services.appintegrations.AmazonAppIntegrationsClient;
import com.amazonaws.services.appintegrations.model.CreateEventIntegrationRequest;
import com.amazonaws.services.appintegrations.model.CreateEventIntegrationResult;
import com.amazonaws.services.appintegrations.model.DeleteEventIntegrationRequest;
import com.amazonaws.services.appintegrations.model.DeleteEventIntegrationResult;
import com.amazonaws.services.appintegrations.model.GetEventIntegrationRequest;
import com.amazonaws.services.appintegrations.model.GetEventIntegrationResult;
import com.amazonaws.services.appintegrations.model.ListEventIntegrationAssociationsRequest;
import com.amazonaws.services.appintegrations.model.ListEventIntegrationAssociationsResult;
import com.amazonaws.services.appintegrations.model.ListEventIntegrationsRequest;
import com.amazonaws.services.appintegrations.model.ListEventIntegrationsResult;
import com.amazonaws.services.appintegrations.model.ListTagsForResourceRequest;
import com.amazonaws.services.appintegrations.model.ListTagsForResourceResult;
import com.amazonaws.services.appintegrations.model.TagResourceRequest;
import com.amazonaws.services.appintegrations.model.TagResourceResult;
import com.amazonaws.services.appintegrations.model.UntagResourceRequest;
import com.amazonaws.services.appintegrations.model.UntagResourceResult;
import com.amazonaws.services.appintegrations.model.UpdateEventIntegrationRequest;
import com.amazonaws.services.appintegrations.model.UpdateEventIntegrationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonAppIntegrationsAsyncClient
extends AmazonAppIntegrationsClient
implements AmazonAppIntegrationsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonAppIntegrationsAsyncClientBuilder asyncBuilder() {
        return AmazonAppIntegrationsAsyncClientBuilder.standard();
    }

    AmazonAppIntegrationsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonAppIntegrationsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateEventIntegrationResult> createEventIntegrationAsync(CreateEventIntegrationRequest request) {
        return this.createEventIntegrationAsync(request, null);
    }

    @Override
    public Future<CreateEventIntegrationResult> createEventIntegrationAsync(CreateEventIntegrationRequest request, final AsyncHandler<CreateEventIntegrationRequest, CreateEventIntegrationResult> asyncHandler) {
        final CreateEventIntegrationRequest finalRequest = (CreateEventIntegrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEventIntegrationResult>(){

            @Override
            public CreateEventIntegrationResult call() throws Exception {
                CreateEventIntegrationResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeCreateEventIntegration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEventIntegrationResult> deleteEventIntegrationAsync(DeleteEventIntegrationRequest request) {
        return this.deleteEventIntegrationAsync(request, null);
    }

    @Override
    public Future<DeleteEventIntegrationResult> deleteEventIntegrationAsync(DeleteEventIntegrationRequest request, final AsyncHandler<DeleteEventIntegrationRequest, DeleteEventIntegrationResult> asyncHandler) {
        final DeleteEventIntegrationRequest finalRequest = (DeleteEventIntegrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEventIntegrationResult>(){

            @Override
            public DeleteEventIntegrationResult call() throws Exception {
                DeleteEventIntegrationResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeDeleteEventIntegration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEventIntegrationResult> getEventIntegrationAsync(GetEventIntegrationRequest request) {
        return this.getEventIntegrationAsync(request, null);
    }

    @Override
    public Future<GetEventIntegrationResult> getEventIntegrationAsync(GetEventIntegrationRequest request, final AsyncHandler<GetEventIntegrationRequest, GetEventIntegrationResult> asyncHandler) {
        final GetEventIntegrationRequest finalRequest = (GetEventIntegrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEventIntegrationResult>(){

            @Override
            public GetEventIntegrationResult call() throws Exception {
                GetEventIntegrationResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeGetEventIntegration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventIntegrationAssociationsResult> listEventIntegrationAssociationsAsync(ListEventIntegrationAssociationsRequest request) {
        return this.listEventIntegrationAssociationsAsync(request, null);
    }

    @Override
    public Future<ListEventIntegrationAssociationsResult> listEventIntegrationAssociationsAsync(ListEventIntegrationAssociationsRequest request, final AsyncHandler<ListEventIntegrationAssociationsRequest, ListEventIntegrationAssociationsResult> asyncHandler) {
        final ListEventIntegrationAssociationsRequest finalRequest = (ListEventIntegrationAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEventIntegrationAssociationsResult>(){

            @Override
            public ListEventIntegrationAssociationsResult call() throws Exception {
                ListEventIntegrationAssociationsResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeListEventIntegrationAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventIntegrationsResult> listEventIntegrationsAsync(ListEventIntegrationsRequest request) {
        return this.listEventIntegrationsAsync(request, null);
    }

    @Override
    public Future<ListEventIntegrationsResult> listEventIntegrationsAsync(ListEventIntegrationsRequest request, final AsyncHandler<ListEventIntegrationsRequest, ListEventIntegrationsResult> asyncHandler) {
        final ListEventIntegrationsRequest finalRequest = (ListEventIntegrationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEventIntegrationsResult>(){

            @Override
            public ListEventIntegrationsResult call() throws Exception {
                ListEventIntegrationsResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeListEventIntegrations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEventIntegrationResult> updateEventIntegrationAsync(UpdateEventIntegrationRequest request) {
        return this.updateEventIntegrationAsync(request, null);
    }

    @Override
    public Future<UpdateEventIntegrationResult> updateEventIntegrationAsync(UpdateEventIntegrationRequest request, final AsyncHandler<UpdateEventIntegrationRequest, UpdateEventIntegrationResult> asyncHandler) {
        final UpdateEventIntegrationRequest finalRequest = (UpdateEventIntegrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEventIntegrationResult>(){

            @Override
            public UpdateEventIntegrationResult call() throws Exception {
                UpdateEventIntegrationResult result = null;
                try {
                    result = AmazonAppIntegrationsAsyncClient.this.executeUpdateEventIntegration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

