/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscovery;
import com.amazonaws.services.applicationdiscovery.model.AuthorizationErrorException;
import com.amazonaws.services.applicationdiscovery.model.CreateTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.CreateTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DeleteTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.DeleteTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeTagsResult;
import com.amazonaws.services.applicationdiscovery.model.ExportConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.ExportConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.InvalidParameterException;
import com.amazonaws.services.applicationdiscovery.model.InvalidParameterValueException;
import com.amazonaws.services.applicationdiscovery.model.ListConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.ListConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.OperationNotPermittedException;
import com.amazonaws.services.applicationdiscovery.model.ResourceNotFoundException;
import com.amazonaws.services.applicationdiscovery.model.ServerInternalErrorException;
import com.amazonaws.services.applicationdiscovery.model.StartDataCollectionByAgentIdsRequest;
import com.amazonaws.services.applicationdiscovery.model.StartDataCollectionByAgentIdsResult;
import com.amazonaws.services.applicationdiscovery.model.StopDataCollectionByAgentIdsRequest;
import com.amazonaws.services.applicationdiscovery.model.StopDataCollectionByAgentIdsResult;
import com.amazonaws.services.applicationdiscovery.model.transform.CreateTagsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.CreateTagsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DeleteTagsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DeleteTagsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DescribeAgentsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DescribeAgentsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DescribeConfigurationsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DescribeConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DescribeExportConfigurationsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DescribeExportConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DescribeTagsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.DescribeTagsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.ExportConfigurationsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.ExportConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.ListConfigurationsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.ListConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.StartDataCollectionByAgentIdsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.StartDataCollectionByAgentIdsResultJsonUnmarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.StopDataCollectionByAgentIdsRequestMarshaller;
import com.amazonaws.services.applicationdiscovery.model.transform.StopDataCollectionByAgentIdsResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSApplicationDiscoveryClient
extends AmazonWebServiceClient
implements AWSApplicationDiscovery {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSApplicationDiscovery.class);
    private static final String DEFAULT_SIGNING_NAME = "discovery";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerInternalErrorException").withModeledClass(ServerInternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedException").withModeledClass(OperationNotPermittedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AuthorizationErrorException").withModeledClass(AuthorizationErrorException.class)));

    public AWSApplicationDiscoveryClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AWSApplicationDiscoveryClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSApplicationDiscoveryClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSApplicationDiscoveryClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSApplicationDiscoveryClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSApplicationDiscoveryClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSApplicationDiscoveryClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSApplicationDiscoveryClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://discovery.us-west-2.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/applicationdiscovery/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/applicationdiscovery/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTagsResult createTags(CreateTagsRequest createTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTagsRequestMarshaller(this.protocolFactory).marshall((CreateTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTagsResult createTagsResult = (CreateTagsResult)response.getAwsResponse();
            return createTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest deleteTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTagsRequestMarshaller(this.protocolFactory).marshall((DeleteTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTagsResult deleteTagsResult = (DeleteTagsResult)response.getAwsResponse();
            return deleteTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAgentsResult describeAgents(DescribeAgentsRequest describeAgentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAgentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAgentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAgentsRequestMarshaller(this.protocolFactory).marshall((DescribeAgentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAgentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAgentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAgentsResult describeAgentsResult = (DescribeAgentsResult)response.getAwsResponse();
            return describeAgentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationsResult describeConfigurations(DescribeConfigurationsRequest describeConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigurationsRequestMarshaller(this.protocolFactory).marshall((DescribeConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConfigurationsResult describeConfigurationsResult = (DescribeConfigurationsResult)response.getAwsResponse();
            return describeConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExportConfigurationsResult describeExportConfigurations(DescribeExportConfigurationsRequest describeExportConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeExportConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeExportConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeExportConfigurationsRequestMarshaller(this.protocolFactory).marshall((DescribeExportConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeExportConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeExportConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeExportConfigurationsResult describeExportConfigurationsResult = (DescribeExportConfigurationsResult)response.getAwsResponse();
            return describeExportConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResult describeTags(DescribeTagsRequest describeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTagsRequestMarshaller(this.protocolFactory).marshall((DescribeTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTagsResult describeTagsResult = (DescribeTagsResult)response.getAwsResponse();
            return describeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportConfigurationsResult exportConfigurations(ExportConfigurationsRequest exportConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportConfigurationsRequestMarshaller(this.protocolFactory).marshall((ExportConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportConfigurationsResult exportConfigurationsResult = (ExportConfigurationsResult)response.getAwsResponse();
            return exportConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigurationsResult listConfigurations(ListConfigurationsRequest listConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListConfigurationsRequestMarshaller(this.protocolFactory).marshall((ListConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListConfigurationsResult listConfigurationsResult = (ListConfigurationsResult)response.getAwsResponse();
            return listConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDataCollectionByAgentIdsResult startDataCollectionByAgentIds(StartDataCollectionByAgentIdsRequest startDataCollectionByAgentIdsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDataCollectionByAgentIdsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDataCollectionByAgentIdsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDataCollectionByAgentIdsRequestMarshaller(this.protocolFactory).marshall((StartDataCollectionByAgentIdsRequest)super.beforeMarshalling((AmazonWebServiceRequest)startDataCollectionByAgentIdsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartDataCollectionByAgentIdsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDataCollectionByAgentIdsResult startDataCollectionByAgentIdsResult = (StartDataCollectionByAgentIdsResult)response.getAwsResponse();
            return startDataCollectionByAgentIdsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDataCollectionByAgentIdsResult stopDataCollectionByAgentIds(StopDataCollectionByAgentIdsRequest stopDataCollectionByAgentIdsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopDataCollectionByAgentIdsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopDataCollectionByAgentIdsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopDataCollectionByAgentIdsRequestMarshaller(this.protocolFactory).marshall((StopDataCollectionByAgentIdsRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopDataCollectionByAgentIdsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopDataCollectionByAgentIdsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopDataCollectionByAgentIdsResult stopDataCollectionByAgentIdsResult = (StopDataCollectionByAgentIdsResult)response.getAwsResponse();
            return stopDataCollectionByAgentIdsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

