/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Shard;
import com.amazonaws.services.dynamodbv2.model.StreamDescription;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ShardJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class StreamDescriptionJsonMarshaller {
    private static StreamDescriptionJsonMarshaller instance;

    public void marshall(StreamDescription streamDescription, JSONWriter jsonWriter) {
        if (streamDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Shard> shardsList;
            List<KeySchemaElement> keySchemaList;
            jsonWriter.object();
            if (streamDescription.getStreamArn() != null) {
                jsonWriter.key("StreamArn").value((Object)streamDescription.getStreamArn());
            }
            if (streamDescription.getStreamLabel() != null) {
                jsonWriter.key("StreamLabel").value((Object)streamDescription.getStreamLabel());
            }
            if (streamDescription.getStreamStatus() != null) {
                jsonWriter.key("StreamStatus").value((Object)streamDescription.getStreamStatus());
            }
            if (streamDescription.getStreamViewType() != null) {
                jsonWriter.key("StreamViewType").value((Object)streamDescription.getStreamViewType());
            }
            if (streamDescription.getCreationRequestDateTime() != null) {
                jsonWriter.key("CreationRequestDateTime").value(streamDescription.getCreationRequestDateTime());
            }
            if (streamDescription.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)streamDescription.getTableName());
            }
            if ((keySchemaList = streamDescription.getKeySchema()) != null) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((shardsList = streamDescription.getShards()) != null) {
                jsonWriter.key("Shards");
                jsonWriter.array();
                for (Shard shardsListValue : shardsList) {
                    if (shardsListValue == null) continue;
                    ShardJsonMarshaller.getInstance().marshall(shardsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (streamDescription.getLastEvaluatedShardId() != null) {
                jsonWriter.key("LastEvaluatedShardId").value((Object)streamDescription.getLastEvaluatedShardId());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamDescriptionJsonMarshaller();
        }
        return instance;
    }
}

