/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.forecast.model.EncryptionConfig;
import com.amazonaws.services.forecast.model.EvaluationParameters;
import com.amazonaws.services.forecast.model.FeaturizationConfig;
import com.amazonaws.services.forecast.model.HyperParameterTuningJobConfig;
import com.amazonaws.services.forecast.model.InputDataConfig;
import com.amazonaws.services.forecast.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreatePredictorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String predictorName;
    private String algorithmArn;
    private Integer forecastHorizon;
    private Boolean performAutoML;
    private Boolean performHPO;
    private Map<String, String> trainingParameters;
    private EvaluationParameters evaluationParameters;
    private HyperParameterTuningJobConfig hPOConfig;
    private InputDataConfig inputDataConfig;
    private FeaturizationConfig featurizationConfig;
    private EncryptionConfig encryptionConfig;
    private List<Tag> tags;

    public void setPredictorName(String predictorName) {
        this.predictorName = predictorName;
    }

    public String getPredictorName() {
        return this.predictorName;
    }

    public CreatePredictorRequest withPredictorName(String predictorName) {
        this.setPredictorName(predictorName);
        return this;
    }

    public void setAlgorithmArn(String algorithmArn) {
        this.algorithmArn = algorithmArn;
    }

    public String getAlgorithmArn() {
        return this.algorithmArn;
    }

    public CreatePredictorRequest withAlgorithmArn(String algorithmArn) {
        this.setAlgorithmArn(algorithmArn);
        return this;
    }

    public void setForecastHorizon(Integer forecastHorizon) {
        this.forecastHorizon = forecastHorizon;
    }

    public Integer getForecastHorizon() {
        return this.forecastHorizon;
    }

    public CreatePredictorRequest withForecastHorizon(Integer forecastHorizon) {
        this.setForecastHorizon(forecastHorizon);
        return this;
    }

    public void setPerformAutoML(Boolean performAutoML) {
        this.performAutoML = performAutoML;
    }

    public Boolean getPerformAutoML() {
        return this.performAutoML;
    }

    public CreatePredictorRequest withPerformAutoML(Boolean performAutoML) {
        this.setPerformAutoML(performAutoML);
        return this;
    }

    public Boolean isPerformAutoML() {
        return this.performAutoML;
    }

    public void setPerformHPO(Boolean performHPO) {
        this.performHPO = performHPO;
    }

    public Boolean getPerformHPO() {
        return this.performHPO;
    }

    public CreatePredictorRequest withPerformHPO(Boolean performHPO) {
        this.setPerformHPO(performHPO);
        return this;
    }

    public Boolean isPerformHPO() {
        return this.performHPO;
    }

    public Map<String, String> getTrainingParameters() {
        return this.trainingParameters;
    }

    public void setTrainingParameters(Map<String, String> trainingParameters) {
        this.trainingParameters = trainingParameters;
    }

    public CreatePredictorRequest withTrainingParameters(Map<String, String> trainingParameters) {
        this.setTrainingParameters(trainingParameters);
        return this;
    }

    public CreatePredictorRequest addTrainingParametersEntry(String key, String value) {
        if (null == this.trainingParameters) {
            this.trainingParameters = new HashMap<String, String>();
        }
        if (this.trainingParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.trainingParameters.put(key, value);
        return this;
    }

    public CreatePredictorRequest clearTrainingParametersEntries() {
        this.trainingParameters = null;
        return this;
    }

    public void setEvaluationParameters(EvaluationParameters evaluationParameters) {
        this.evaluationParameters = evaluationParameters;
    }

    public EvaluationParameters getEvaluationParameters() {
        return this.evaluationParameters;
    }

    public CreatePredictorRequest withEvaluationParameters(EvaluationParameters evaluationParameters) {
        this.setEvaluationParameters(evaluationParameters);
        return this;
    }

    public void setHPOConfig(HyperParameterTuningJobConfig hPOConfig) {
        this.hPOConfig = hPOConfig;
    }

    public HyperParameterTuningJobConfig getHPOConfig() {
        return this.hPOConfig;
    }

    public CreatePredictorRequest withHPOConfig(HyperParameterTuningJobConfig hPOConfig) {
        this.setHPOConfig(hPOConfig);
        return this;
    }

    public void setInputDataConfig(InputDataConfig inputDataConfig) {
        this.inputDataConfig = inputDataConfig;
    }

    public InputDataConfig getInputDataConfig() {
        return this.inputDataConfig;
    }

    public CreatePredictorRequest withInputDataConfig(InputDataConfig inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setFeaturizationConfig(FeaturizationConfig featurizationConfig) {
        this.featurizationConfig = featurizationConfig;
    }

    public FeaturizationConfig getFeaturizationConfig() {
        return this.featurizationConfig;
    }

    public CreatePredictorRequest withFeaturizationConfig(FeaturizationConfig featurizationConfig) {
        this.setFeaturizationConfig(featurizationConfig);
        return this;
    }

    public void setEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.encryptionConfig = encryptionConfig;
    }

    public EncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public CreatePredictorRequest withEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.setEncryptionConfig(encryptionConfig);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreatePredictorRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreatePredictorRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPredictorName() != null) {
            sb.append("PredictorName: ").append(this.getPredictorName()).append(",");
        }
        if (this.getAlgorithmArn() != null) {
            sb.append("AlgorithmArn: ").append(this.getAlgorithmArn()).append(",");
        }
        if (this.getForecastHorizon() != null) {
            sb.append("ForecastHorizon: ").append(this.getForecastHorizon()).append(",");
        }
        if (this.getPerformAutoML() != null) {
            sb.append("PerformAutoML: ").append(this.getPerformAutoML()).append(",");
        }
        if (this.getPerformHPO() != null) {
            sb.append("PerformHPO: ").append(this.getPerformHPO()).append(",");
        }
        if (this.getTrainingParameters() != null) {
            sb.append("TrainingParameters: ").append(this.getTrainingParameters()).append(",");
        }
        if (this.getEvaluationParameters() != null) {
            sb.append("EvaluationParameters: ").append(this.getEvaluationParameters()).append(",");
        }
        if (this.getHPOConfig() != null) {
            sb.append("HPOConfig: ").append(this.getHPOConfig()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getFeaturizationConfig() != null) {
            sb.append("FeaturizationConfig: ").append(this.getFeaturizationConfig()).append(",");
        }
        if (this.getEncryptionConfig() != null) {
            sb.append("EncryptionConfig: ").append(this.getEncryptionConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePredictorRequest)) {
            return false;
        }
        CreatePredictorRequest other = (CreatePredictorRequest)obj;
        if (other.getPredictorName() == null ^ this.getPredictorName() == null) {
            return false;
        }
        if (other.getPredictorName() != null && !other.getPredictorName().equals(this.getPredictorName())) {
            return false;
        }
        if (other.getAlgorithmArn() == null ^ this.getAlgorithmArn() == null) {
            return false;
        }
        if (other.getAlgorithmArn() != null && !other.getAlgorithmArn().equals(this.getAlgorithmArn())) {
            return false;
        }
        if (other.getForecastHorizon() == null ^ this.getForecastHorizon() == null) {
            return false;
        }
        if (other.getForecastHorizon() != null && !other.getForecastHorizon().equals(this.getForecastHorizon())) {
            return false;
        }
        if (other.getPerformAutoML() == null ^ this.getPerformAutoML() == null) {
            return false;
        }
        if (other.getPerformAutoML() != null && !other.getPerformAutoML().equals(this.getPerformAutoML())) {
            return false;
        }
        if (other.getPerformHPO() == null ^ this.getPerformHPO() == null) {
            return false;
        }
        if (other.getPerformHPO() != null && !other.getPerformHPO().equals(this.getPerformHPO())) {
            return false;
        }
        if (other.getTrainingParameters() == null ^ this.getTrainingParameters() == null) {
            return false;
        }
        if (other.getTrainingParameters() != null && !other.getTrainingParameters().equals(this.getTrainingParameters())) {
            return false;
        }
        if (other.getEvaluationParameters() == null ^ this.getEvaluationParameters() == null) {
            return false;
        }
        if (other.getEvaluationParameters() != null && !other.getEvaluationParameters().equals(this.getEvaluationParameters())) {
            return false;
        }
        if (other.getHPOConfig() == null ^ this.getHPOConfig() == null) {
            return false;
        }
        if (other.getHPOConfig() != null && !other.getHPOConfig().equals(this.getHPOConfig())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getFeaturizationConfig() == null ^ this.getFeaturizationConfig() == null) {
            return false;
        }
        if (other.getFeaturizationConfig() != null && !other.getFeaturizationConfig().equals(this.getFeaturizationConfig())) {
            return false;
        }
        if (other.getEncryptionConfig() == null ^ this.getEncryptionConfig() == null) {
            return false;
        }
        if (other.getEncryptionConfig() != null && !other.getEncryptionConfig().equals(this.getEncryptionConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPredictorName() == null ? 0 : this.getPredictorName().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmArn() == null ? 0 : this.getAlgorithmArn().hashCode());
        hashCode = 31 * hashCode + (this.getForecastHorizon() == null ? 0 : this.getForecastHorizon().hashCode());
        hashCode = 31 * hashCode + (this.getPerformAutoML() == null ? 0 : this.getPerformAutoML().hashCode());
        hashCode = 31 * hashCode + (this.getPerformHPO() == null ? 0 : this.getPerformHPO().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingParameters() == null ? 0 : this.getTrainingParameters().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationParameters() == null ? 0 : this.getEvaluationParameters().hashCode());
        hashCode = 31 * hashCode + (this.getHPOConfig() == null ? 0 : this.getHPOConfig().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getFeaturizationConfig() == null ? 0 : this.getFeaturizationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfig() == null ? 0 : this.getEncryptionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreatePredictorRequest clone() {
        return (CreatePredictorRequest)super.clone();
    }
}

