/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fsx.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.fsx.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CreateFileSystemLustreConfiguration JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateFileSystemLustreConfigurationJsonUnmarshaller implements Unmarshaller<CreateFileSystemLustreConfiguration, JsonUnmarshallerContext> {

    public CreateFileSystemLustreConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        CreateFileSystemLustreConfiguration createFileSystemLustreConfiguration = new CreateFileSystemLustreConfiguration();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("WeeklyMaintenanceStartTime", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setWeeklyMaintenanceStartTime(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ImportPath", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setImportPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExportPath", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setExportPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ImportedFileChunkSize", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setImportedFileChunkSize(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("DeploymentType", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setDeploymentType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AutoImportPolicy", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setAutoImportPolicy(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PerUnitStorageThroughput", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setPerUnitStorageThroughput(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("DailyAutomaticBackupStartTime", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setDailyAutomaticBackupStartTime(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AutomaticBackupRetentionDays", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setAutomaticBackupRetentionDays(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("CopyTagsToBackups", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setCopyTagsToBackups(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("DriveCacheType", targetDepth)) {
                    context.nextToken();
                    createFileSystemLustreConfiguration.setDriveCacheType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return createFileSystemLustreConfiguration;
    }

    private static CreateFileSystemLustreConfigurationJsonUnmarshaller instance;

    public static CreateFileSystemLustreConfigurationJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new CreateFileSystemLustreConfigurationJsonUnmarshaller();
        return instance;
    }
}
