/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.GameSessionDetail;
import com.amazonaws.services.gamelift.model.transform.GameSessionJsonMarshaller;

public class GameSessionDetailJsonMarshaller {
    private static GameSessionDetailJsonMarshaller instance;

    public void marshall(GameSessionDetail gameSessionDetail, StructuredJsonGenerator jsonGenerator) {
        if (gameSessionDetail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (gameSessionDetail.getGameSession() != null) {
                jsonGenerator.writeFieldName("GameSession");
                GameSessionJsonMarshaller.getInstance().marshall(gameSessionDetail.getGameSession(), jsonGenerator);
            }
            if (gameSessionDetail.getProtectionPolicy() != null) {
                jsonGenerator.writeFieldName("ProtectionPolicy").writeValue(gameSessionDetail.getProtectionPolicy());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GameSessionDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GameSessionDetailJsonMarshaller();
        }
        return instance;
    }
}

