/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrassv2.model.ComponentDependencyRequirement;
import com.amazonaws.services.greengrassv2.model.ComponentPlatform;
import com.amazonaws.services.greengrassv2.model.LambdaExecutionParameters;
import com.amazonaws.services.greengrassv2.model.transform.LambdaFunctionRecipeSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaFunctionRecipeSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String lambdaArn;
    private String componentName;
    private String componentVersion;
    private List<ComponentPlatform> componentPlatforms;
    private Map<String, ComponentDependencyRequirement> componentDependencies;
    private LambdaExecutionParameters componentLambdaParameters;

    public void setLambdaArn(String lambdaArn) {
        this.lambdaArn = lambdaArn;
    }

    public String getLambdaArn() {
        return this.lambdaArn;
    }

    public LambdaFunctionRecipeSource withLambdaArn(String lambdaArn) {
        this.setLambdaArn(lambdaArn);
        return this;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public LambdaFunctionRecipeSource withComponentName(String componentName) {
        this.setComponentName(componentName);
        return this;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public LambdaFunctionRecipeSource withComponentVersion(String componentVersion) {
        this.setComponentVersion(componentVersion);
        return this;
    }

    public List<ComponentPlatform> getComponentPlatforms() {
        return this.componentPlatforms;
    }

    public void setComponentPlatforms(Collection<ComponentPlatform> componentPlatforms) {
        if (componentPlatforms == null) {
            this.componentPlatforms = null;
            return;
        }
        this.componentPlatforms = new ArrayList<ComponentPlatform>(componentPlatforms);
    }

    public LambdaFunctionRecipeSource withComponentPlatforms(ComponentPlatform ... componentPlatforms) {
        if (this.componentPlatforms == null) {
            this.setComponentPlatforms(new ArrayList<ComponentPlatform>(componentPlatforms.length));
        }
        for (ComponentPlatform ele : componentPlatforms) {
            this.componentPlatforms.add(ele);
        }
        return this;
    }

    public LambdaFunctionRecipeSource withComponentPlatforms(Collection<ComponentPlatform> componentPlatforms) {
        this.setComponentPlatforms(componentPlatforms);
        return this;
    }

    public Map<String, ComponentDependencyRequirement> getComponentDependencies() {
        return this.componentDependencies;
    }

    public void setComponentDependencies(Map<String, ComponentDependencyRequirement> componentDependencies) {
        this.componentDependencies = componentDependencies;
    }

    public LambdaFunctionRecipeSource withComponentDependencies(Map<String, ComponentDependencyRequirement> componentDependencies) {
        this.setComponentDependencies(componentDependencies);
        return this;
    }

    public LambdaFunctionRecipeSource addComponentDependenciesEntry(String key, ComponentDependencyRequirement value) {
        if (null == this.componentDependencies) {
            this.componentDependencies = new HashMap<String, ComponentDependencyRequirement>();
        }
        if (this.componentDependencies.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.componentDependencies.put(key, value);
        return this;
    }

    public LambdaFunctionRecipeSource clearComponentDependenciesEntries() {
        this.componentDependencies = null;
        return this;
    }

    public void setComponentLambdaParameters(LambdaExecutionParameters componentLambdaParameters) {
        this.componentLambdaParameters = componentLambdaParameters;
    }

    public LambdaExecutionParameters getComponentLambdaParameters() {
        return this.componentLambdaParameters;
    }

    public LambdaFunctionRecipeSource withComponentLambdaParameters(LambdaExecutionParameters componentLambdaParameters) {
        this.setComponentLambdaParameters(componentLambdaParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLambdaArn() != null) {
            sb.append("LambdaArn: ").append(this.getLambdaArn()).append(",");
        }
        if (this.getComponentName() != null) {
            sb.append("ComponentName: ").append(this.getComponentName()).append(",");
        }
        if (this.getComponentVersion() != null) {
            sb.append("ComponentVersion: ").append(this.getComponentVersion()).append(",");
        }
        if (this.getComponentPlatforms() != null) {
            sb.append("ComponentPlatforms: ").append(this.getComponentPlatforms()).append(",");
        }
        if (this.getComponentDependencies() != null) {
            sb.append("ComponentDependencies: ").append(this.getComponentDependencies()).append(",");
        }
        if (this.getComponentLambdaParameters() != null) {
            sb.append("ComponentLambdaParameters: ").append(this.getComponentLambdaParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionRecipeSource)) {
            return false;
        }
        LambdaFunctionRecipeSource other = (LambdaFunctionRecipeSource)obj;
        if (other.getLambdaArn() == null ^ this.getLambdaArn() == null) {
            return false;
        }
        if (other.getLambdaArn() != null && !other.getLambdaArn().equals(this.getLambdaArn())) {
            return false;
        }
        if (other.getComponentName() == null ^ this.getComponentName() == null) {
            return false;
        }
        if (other.getComponentName() != null && !other.getComponentName().equals(this.getComponentName())) {
            return false;
        }
        if (other.getComponentVersion() == null ^ this.getComponentVersion() == null) {
            return false;
        }
        if (other.getComponentVersion() != null && !other.getComponentVersion().equals(this.getComponentVersion())) {
            return false;
        }
        if (other.getComponentPlatforms() == null ^ this.getComponentPlatforms() == null) {
            return false;
        }
        if (other.getComponentPlatforms() != null && !other.getComponentPlatforms().equals(this.getComponentPlatforms())) {
            return false;
        }
        if (other.getComponentDependencies() == null ^ this.getComponentDependencies() == null) {
            return false;
        }
        if (other.getComponentDependencies() != null && !other.getComponentDependencies().equals(this.getComponentDependencies())) {
            return false;
        }
        if (other.getComponentLambdaParameters() == null ^ this.getComponentLambdaParameters() == null) {
            return false;
        }
        return other.getComponentLambdaParameters() == null || other.getComponentLambdaParameters().equals(this.getComponentLambdaParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLambdaArn() == null ? 0 : this.getLambdaArn().hashCode());
        hashCode = 31 * hashCode + (this.getComponentName() == null ? 0 : this.getComponentName().hashCode());
        hashCode = 31 * hashCode + (this.getComponentVersion() == null ? 0 : this.getComponentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getComponentPlatforms() == null ? 0 : this.getComponentPlatforms().hashCode());
        hashCode = 31 * hashCode + (this.getComponentDependencies() == null ? 0 : this.getComponentDependencies().hashCode());
        hashCode = 31 * hashCode + (this.getComponentLambdaParameters() == null ? 0 : this.getComponentLambdaParameters().hashCode());
        return hashCode;
    }

    public LambdaFunctionRecipeSource clone() {
        try {
            return (LambdaFunctionRecipeSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaFunctionRecipeSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

