/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.kinesisanalytics.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * OutputDescription JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OutputDescriptionJsonUnmarshaller implements Unmarshaller<OutputDescription, JsonUnmarshallerContext> {

    public OutputDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        OutputDescription outputDescription = new OutputDescription();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("OutputId", targetDepth)) {
                    context.nextToken();
                    outputDescription.setOutputId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    outputDescription.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KinesisStreamsOutputDescription", targetDepth)) {
                    context.nextToken();
                    outputDescription.setKinesisStreamsOutputDescription(KinesisStreamsOutputDescriptionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseOutputDescription", targetDepth)) {
                    context.nextToken();
                    outputDescription.setKinesisFirehoseOutputDescription(KinesisFirehoseOutputDescriptionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LambdaOutputDescription", targetDepth)) {
                    context.nextToken();
                    outputDescription.setLambdaOutputDescription(LambdaOutputDescriptionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DestinationSchema", targetDepth)) {
                    context.nextToken();
                    outputDescription.setDestinationSchema(DestinationSchemaJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return outputDescription;
    }

    private static OutputDescriptionJsonUnmarshaller instance;

    public static OutputDescriptionJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new OutputDescriptionJsonUnmarshaller();
        return instance;
    }
}
