/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property.source;

import com.codiform.moo.MissingSourcePropertyValueException;
import com.codiform.moo.property.source.SourceProperty;
import java.io.Serializable;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.PropertyAccessException;

public class MvelSourceProperty
implements SourceProperty {
    private String expression;
    private Serializable compiledExpression;

    public MvelSourceProperty(String expression, Serializable compiledExpression) {
        this.expression = expression;
        this.compiledExpression = compiledExpression;
    }

    public Object getValue(Object source) {
        try {
            return MVEL.executeExpression((Object)this.compiledExpression, (Object)source);
        }
        catch (PropertyAccessException exception) {
            throw new MissingSourcePropertyValueException(this.expression, source.getClass(), (Throwable)exception);
        }
    }

    public Object getValue(Object source, Map<String, Object> variables) {
        try {
            return MVEL.executeExpression((Object)this.compiledExpression, (Object)source, variables);
        }
        catch (PropertyAccessException exception) {
            throw new MissingSourcePropertyValueException(this.expression, source.getClass(), (Throwable)exception);
        }
    }

    public String getExpression() {
        return this.expression;
    }
}

