/*
 * Decompiled with CFR 0.152.
 */
package com.damick.dropwizard.metrics.cloudwatch;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.internal.EC2MetadataClient;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClient;
import com.amazonaws.util.EC2MetadataUtils;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.damick.dropwizard.metrics.cloudwatch.CloudWatchClientConfiguration;
import com.damick.dropwizard.metrics.cloudwatch.CloudWatchMachineDimensionReporter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Strings;
import io.dropwizard.metrics.BaseReporterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="cloudwatch")
public class CloudWatchReporterFactory
extends BaseReporterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudWatchReporterFactory.class);
    private static final String DEFAULT_REGION = "us-east-1";
    @JsonIgnore
    private AmazonCloudWatchAsync client;
    @NotNull
    private String namespace = "";
    @JsonIgnore
    private String awsSecretKey = null;
    @JsonIgnore
    private String awsAccessKeyId = null;
    @JsonIgnore
    private String awsRegion = "us-east-1";
    @JsonIgnore
    private String machineDimension;
    @JsonIgnore
    private Boolean ec2MetadataAvailable = null;
    @JsonIgnore
    private List<String> globalDimensions = new ArrayList<String>();
    @JsonIgnore
    private CloudWatchClientConfiguration clientConfig = new CloudWatchClientConfiguration();

    @JsonProperty
    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    @JsonProperty
    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    @JsonProperty
    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    @JsonProperty
    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    @JsonProperty
    public String getAwsRegion() {
        return this.awsRegion;
    }

    @JsonProperty
    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    @JsonProperty
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty
    public String getMachineDimension() {
        return this.machineDimension;
    }

    @JsonProperty
    public void setMachineDimension(String machineDimension) {
        this.machineDimension = machineDimension;
    }

    @JsonProperty
    public List<String> getGlobalDimensions() {
        return this.globalDimensions;
    }

    @JsonProperty
    public void setGlobalDimensions(List<String> globalDimensions) {
        this.globalDimensions = globalDimensions;
    }

    @JsonProperty
    public void setAwsClientConfiguration(CloudWatchClientConfiguration clientConfig) {
        this.clientConfig = clientConfig;
    }

    @JsonProperty
    public CloudWatchClientConfiguration getAwsClientConfiguration() {
        return this.clientConfig;
    }

    @JsonIgnore
    public void setClient(AmazonCloudWatchAsync client) {
        this.client = client;
    }

    public ScheduledReporter build(MetricRegistry registry) {
        if (this.client == null) {
            this.client = !Strings.isNullOrEmpty((String)this.awsAccessKeyId) && !Strings.isNullOrEmpty((String)this.awsSecretKey) ? new AmazonCloudWatchAsyncClient((AWSCredentials)new BasicAWSCredentials(this.awsAccessKeyId, this.awsSecretKey), (ClientConfiguration)this.clientConfig, Executors.newCachedThreadPool()) : new AmazonCloudWatchAsyncClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), (ClientConfiguration)this.clientConfig);
            Region region = this.region();
            this.client.setRegion(region);
            LOGGER.info("CloudWatch reporting configure to send to region: {}", (Object)region);
        }
        this.globalDimensions.add("machine=" + this.machineId() + "*");
        return new CloudWatchMachineDimensionReporter(registry, this.namespace, this.globalDimensions, this.getFilter(), this.client);
    }

    protected String machineId() {
        String machine = this.machineDimension;
        if (machine == null && this.isEC2MetadataAvailable()) {
            machine = EC2MetadataUtils.getInstanceId();
        }
        if (Strings.isNullOrEmpty((String)machine)) {
            machine = "localhost";
        }
        return machine;
    }

    protected Region region() {
        String az = null;
        if (this.isEC2MetadataAvailable()) {
            az = EC2MetadataUtils.getAvailabilityZone();
        }
        String regionName = this.awsRegion;
        if (!Strings.isNullOrEmpty((String)az)) {
            regionName = az.substring(0, az.length() - 1);
        }
        return RegionUtils.getRegion((String)regionName);
    }

    protected boolean isEC2MetadataAvailable() {
        if (this.ec2MetadataAvailable == null) {
            EC2MetadataClient client = new EC2MetadataClient();
            try {
                client.readResource("/");
                this.ec2MetadataAvailable = true;
            }
            catch (IOException e) {
                LOGGER.error("Not able to connect to EC2 Metadata Service");
                this.ec2MetadataAvailable = false;
            }
        }
        return this.ec2MetadataAvailable;
    }
}

