/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.DDId;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public enum IdGenerationStrategy {
    RANDOM{

        @Override
        public DDId generate() {
            return DDId.from(ThreadLocalRandom.current().nextLong(1L, Long.MAX_VALUE));
        }
    }
    ,
    SEQUENTIAL{
        private final AtomicLong id = new AtomicLong(0L);

        @Override
        public DDId generate() {
            return DDId.from(this.id.incrementAndGet());
        }
    }
    ,
    THREAD_PREFIX{
        private final AtomicInteger id = new AtomicInteger(0);
        private final AtomicInteger prefix = new AtomicInteger(0);
        private final ThreadLocal<Integer> tls = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return prefix.getAndIncrement();
            }
        };

        @Override
        public DDId generate() {
            return DDId.from(this.tls.get().longValue() << 32 | (long)this.id.incrementAndGet());
        }
    };


    public abstract DDId generate();
}

