/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.EnumEntryList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/ktfmt/format/RedundantSemicolonDetector;", "", "<init>", "()V", "extraSemicolons", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getRedundantSemicolonElements", "", "takeElement", "", "element", "isLastConcreteChild", "", "isExtraSemicolon", "ktfmt"})
public final class RedundantSemicolonDetector {
    @NotNull
    private final List<PsiElement> extraSemicolons = new ArrayList();

    @NotNull
    public final List<PsiElement> getRedundantSemicolonElements() {
        return this.extraSemicolons;
    }

    public final void takeElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.isExtraSemicolon(element)) {
            ((Collection)this.extraSemicolons).add(element);
        }
    }

    private final boolean isLastConcreteChild(PsiElement element) {
        PsiElement nextSibling = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)element, (boolean)false, (int)1, null);
        return nextSibling == null || nextSibling instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)nextSibling).getElementType(), (Object)KtTokens.RBRACE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExtraSemicolon(PsiElement element) {
        PsiElement nextConcreteSibling;
        if (!Intrinsics.areEqual((Object)element.getText(), (Object)";")) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof KtStringTemplateExpression) return false;
        if (parent instanceof KtStringTemplateEntry) {
            return false;
        }
        if (parent instanceof KtEnumEntry) {
            PsiElement psiElement = ((KtEnumEntry)parent).getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassBody");
            KtClassBody classBody = (KtClassBody)psiElement;
            PsiElement[] psiElementArray = classBody.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            return Intrinsics.areEqual((Object)ArraysKt.last((Object[])psiElementArray), (Object)parent);
        }
        PsiElement prevConcreteSibling = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)element, (boolean)false, (int)1, null);
        if (parent instanceof KtClassBody) {
            if (prevConcreteSibling instanceof KtObjectDeclaration && ((KtObjectDeclaration)prevConcreteSibling).isCompanion() && ((KtObjectDeclaration)prevConcreteSibling).getNameIdentifier() == null && !this.isLastConcreteChild(element)) {
                return false;
            }
            EnumEntryList enumEntryList = EnumEntryList.Companion.extractChildList((KtClassBody)parent);
            if (enumEntryList == null) {
                return true;
            }
            EnumEntryList enumEntryList2 = enumEntryList;
            if (!Intrinsics.areEqual((Object)element, (Object)enumEntryList2.getTerminatingSemicolon())) return true;
            PsiElement[] psiElementArray = ((KtClassBody)parent).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            if (((Object[])psiElementArray).length != 0) return false;
            return true;
        }
        PsiElement prevLeaf = PsiUtilsKt.prevLeaf((PsiElement)element, (boolean)false);
        if ((prevConcreteSibling instanceof KtIfExpression || prevConcreteSibling instanceof KtWhileExpression) && prevLeaf instanceof KtContainerNodeForControlStructureBody) {
            String string = ((KtContainerNodeForControlStructureBody)prevLeaf).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
        }
        if ((nextConcreteSibling = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)element, (boolean)false, (int)1, null)) instanceof KtLambdaExpression) return false;
        if (!(nextConcreteSibling instanceof KtDotQualifiedExpression)) return true;
        if (!(((KtDotQualifiedExpression)nextConcreteSibling).getReceiverExpression() instanceof KtLambdaExpression)) return true;
        return false;
    }
}

