/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.iterator.CollectIterator;
import com.gs.collections.impl.utility.Iterate;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectIterable<T, V>
extends AbstractLazyIterable<V> {
    private final Iterable<T> adapted;
    private final Function<? super T, ? extends V> function;

    public CollectIterable(Iterable<T> newAdapted, Function<? super T, ? extends V> function) {
        this.adapted = newAdapted;
        this.function = function;
    }

    public void forEach(Procedure<? super V> procedure) {
        Iterate.forEach(this.adapted, Functions.bind(procedure, this.function));
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, Functions.bind(objectIntProcedure, this.function));
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, Functions.bind(procedure, this.function), parameter);
    }

    public Iterator<V> iterator() {
        return new CollectIterator<T, V>(this.adapted, this.function);
    }

    @Override
    public int size() {
        return Iterate.sizeOf(this.adapted);
    }

    @Override
    public boolean isEmpty() {
        return Iterate.isEmpty(this.adapted);
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public Object[] toArray() {
        Object[] array = Iterate.toArray(this.adapted);
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.function.valueOf(array[i]);
        }
        return array;
    }
}

