/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.iterator.FlatCollectIterator;
import com.gs.collections.impl.utility.Iterate;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class FlatCollectIterable<T, V>
extends AbstractLazyIterable<V> {
    private final Iterable<T> adapted;
    private final Function<? super T, ? extends Iterable<V>> function;

    public FlatCollectIterable(Iterable<T> newAdapted, Function<? super T, ? extends Iterable<V>> function) {
        this.adapted = newAdapted;
        this.function = function;
    }

    public void forEach(final Procedure<? super V> procedure) {
        Iterate.forEach(this.adapted, new Procedure<T>(){

            public void value(T each) {
                Iterate.forEach((Iterable)FlatCollectIterable.this.function.valueOf(each), procedure);
            }
        });
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        final AdaptObjectIntProcedureToProcedure innerProcedure = new AdaptObjectIntProcedureToProcedure(objectIntProcedure);
        Iterate.forEach(this.adapted, new Procedure<T>(){

            public void value(T each) {
                Iterable iterable = (Iterable)FlatCollectIterable.this.function.valueOf(each);
                Iterate.forEach(iterable, innerProcedure);
            }
        });
    }

    public <P> void forEachWith(final Procedure2<? super V, ? super P> procedure, final P parameter) {
        Iterate.forEach(this.adapted, new Procedure<T>(){

            public void value(T each) {
                Iterate.forEachWith((Iterable)FlatCollectIterable.this.function.valueOf(each), procedure, parameter);
            }
        });
    }

    public Iterator<V> iterator() {
        return new FlatCollectIterator(this.adapted, this.function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdaptObjectIntProcedureToProcedure<V>
    implements Procedure<V> {
        private static final long serialVersionUID = 1L;
        private final Counter index;
        private final ObjectIntProcedure<? super V> objectIntProcedure;

        private AdaptObjectIntProcedureToProcedure(ObjectIntProcedure<? super V> objectIntProcedure) {
            this.objectIntProcedure = objectIntProcedure;
            this.index = new Counter();
        }

        public void value(V each) {
            this.objectIntProcedure.value(each, this.index.getCount());
            this.index.increment();
        }
    }
}

