/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.bag;

import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.block.procedure.IfProcedure;
import com.gs.collections.impl.lazy.parallel.AbstractBatch;
import com.gs.collections.impl.lazy.parallel.bag.CollectUnsortedBagBatch;
import com.gs.collections.impl.lazy.parallel.bag.UnsortedBagBatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class SelectUnsortedBagBatch<T>
extends AbstractBatch<T>
implements UnsortedBagBatch<T> {
    private final UnsortedBagBatch<T> unsortedBagBatch;
    private final Predicate<? super T> predicate;

    public SelectUnsortedBagBatch(UnsortedBagBatch<T> unsortedBagBatch, Predicate<? super T> predicate) {
        this.unsortedBagBatch = unsortedBagBatch;
        this.predicate = predicate;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.unsortedBagBatch.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    @Override
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
        this.unsortedBagBatch.forEachWithOccurrences(new IfProcedureWithOccurrences(this.predicate, procedure));
    }

    @Override
    public UnsortedBagBatch<T> select(Predicate<? super T> predicate) {
        return new SelectUnsortedBagBatch<T>(this, predicate);
    }

    @Override
    public <V> UnsortedBagBatch<V> collect(Function<? super T, ? extends V> function) {
        return new CollectUnsortedBagBatch<T, V>(this, function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IfProcedureWithOccurrences<T>
    implements ObjectIntProcedure<T> {
        private final Predicate<? super T> predicate;
        private final ObjectIntProcedure<? super T> procedure;

        private IfProcedureWithOccurrences(Predicate<? super T> predicate, ObjectIntProcedure<? super T> procedure) {
            this.predicate = predicate;
            this.procedure = procedure;
        }

        public void value(T each, int parameter) {
            if (this.predicate.accept(each)) {
                this.procedure.value(each, parameter);
            }
        }
    }
}

