/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.set.sorted;

import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.sortedset.ImmutableSortedSetMultimap;
import com.gs.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import com.gs.collections.api.set.sorted.ImmutableSortedSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.factory.SortedSets;
import com.gs.collections.impl.multimap.AbstractImmutableMultimap;
import com.gs.collections.impl.multimap.AbstractMutableMultimap;
import com.gs.collections.impl.multimap.ImmutableMultimapSerializationProxy;
import com.gs.collections.impl.multimap.set.sorted.TreeSortedSetMultimap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableSortedSetMultimapImpl<K, V>
extends AbstractImmutableMultimap<K, V, ImmutableSortedSet<V>>
implements ImmutableSortedSetMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<? super V> comparator;

    ImmutableSortedSetMultimapImpl(MutableMap<K, ImmutableSortedSet<V>> map) {
        super(map);
        this.comparator = null;
    }

    public ImmutableSortedSetMultimapImpl(MutableMap<K, ImmutableSortedSet<V>> map, Comparator<? super V> comparator) {
        super(map);
        this.comparator = comparator;
    }

    ImmutableSortedSetMultimapImpl(ImmutableMap<K, ImmutableSortedSet<V>> map) {
        super(map);
        this.comparator = null;
    }

    public ImmutableSortedSetMultimapImpl(ImmutableMap<K, ImmutableSortedSet<V>> map, Comparator<? super V> comparator) {
        super(map);
        this.comparator = comparator;
    }

    @Override
    protected ImmutableSortedSet<V> createCollection() {
        return SortedSets.immutable.of(this.comparator());
    }

    public ImmutableSortedSetMultimap<K, V> newEmpty() {
        return new ImmutableSortedSetMultimapImpl<K, V>(Maps.immutable.with(), this.comparator());
    }

    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    public MutableSortedSetMultimap<K, V> toMutable() {
        return new TreeSortedSetMultimap(this);
    }

    @Override
    public ImmutableSortedSetMultimap<K, V> toImmutable() {
        return this;
    }

    private Object writeReplace() {
        return new ImmutableSortedSetMultimapSerializationProxy(this.map, this.comparator());
    }

    @Override
    public ImmutableSortedSetMultimap<K, V> newWith(K key, V value) {
        return (ImmutableSortedSetMultimap)super.newWith(key, value);
    }

    @Override
    public ImmutableSortedSetMultimap<K, V> newWithout(Object key, Object value) {
        return (ImmutableSortedSetMultimap)super.newWithout(key, value);
    }

    @Override
    public ImmutableSortedSetMultimap<K, V> newWithAll(K key, Iterable<? extends V> values) {
        return (ImmutableSortedSetMultimap)super.newWithAll(key, values);
    }

    @Override
    public ImmutableSortedSetMultimap<K, V> newWithoutAll(Object key) {
        return (ImmutableSortedSetMultimap)super.newWithoutAll(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImmutableSortedSetMultimapSerializationProxy<K, V>
    extends ImmutableMultimapSerializationProxy<K, V, ImmutableSortedSet<V>> {
        private static final long serialVersionUID = 1L;
        private Comparator<? super V> comparator;

        public ImmutableSortedSetMultimapSerializationProxy() {
        }

        private ImmutableSortedSetMultimapSerializationProxy(ImmutableMap<K, ImmutableSortedSet<V>> map, Comparator<? super V> comparator) {
            super(map);
            this.comparator = comparator;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.comparator);
            super.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.comparator = (Comparator)in.readObject();
            super.readExternal(in);
        }

        @Override
        protected AbstractMutableMultimap<K, V, MutableSortedSet<V>> createEmptyMutableMultimap() {
            return new TreeSortedSetMultimap(this.comparator);
        }
    }
}

