/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableShortSetFactory;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableShortEmptySet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableShortSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;

public class ImmutableShortSetFactoryImpl
implements ImmutableShortSetFactory {
    public ImmutableShortSet of() {
        return this.with();
    }

    public ImmutableShortSet with() {
        return ImmutableShortEmptySet.INSTANCE;
    }

    public ImmutableShortSet of(short one) {
        return this.with(one);
    }

    public ImmutableShortSet with(short one) {
        return new ImmutableShortSingletonSet(one);
    }

    public ImmutableShortSet of(short ... items) {
        return this.with(items);
    }

    public ImmutableShortSet with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ShortHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableShortSet ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public ImmutableShortSet withAll(ShortIterable items) {
        if (items instanceof ImmutableShortSet) {
            return (ImmutableShortSet)items;
        }
        return this.with(items.toArray());
    }
}

