/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.primitive.LongSets;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableLongSetSerializationProxy;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedLongSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongHashSet
implements MutableLongSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final long EMPTY = 0L;
    private static final long REMOVED = 1L;
    private long[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public LongHashSet() {
        this.allocateTable(16);
    }

    public LongHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public LongHashSet(LongHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    public static LongHashSet newSet(LongIterable source) {
        if (source instanceof LongHashSet) {
            return new LongHashSet((LongHashSet)source);
        }
        return LongHashSet.newSetWith(source.toArray());
    }

    public static LongHashSet newSetWith(long ... source) {
        LongHashSet result = new LongHashSet();
        result.addAll(source);
        return result;
    }

    private static boolean isBetweenZeroAndThirtyOne(long value) {
        return value >= 0L && value <= 31L;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongSet)) {
            return false;
        }
        LongSet other = (LongSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    public int hashCode() {
        long value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (int)(value ^ value >>> 32);
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!LongHashSet.isNonSentinel(this.table[i])) continue;
                result += (int)(this.table[i] ^ this.table[i] >>> 32);
            }
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            long value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean add(long element) {
        if (LongHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << (int)element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (this.table[index] == element) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (this.table[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    public boolean addAll(long ... source) {
        int oldSize = this.size();
        for (long item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    public boolean addAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof LongHashSet) {
            LongHashSet hashSet = (LongHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (long item : hashSet.table) {
                if (!LongHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                long item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean remove(long value) {
        if (LongHashSet.isBetweenZeroAndThirtyOne(value)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne &= ~(1 << (int)value);
            if (this.zeroToThirtyOne == initial) {
                return false;
            }
            --this.zeroToThirtyOneOccupied;
            return true;
        }
        int index = this.probe(value);
        if (this.table[index] == value) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof LongHashSet) {
            LongHashSet hashSet = (LongHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (long item : hashSet.table) {
                if (!LongHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                long item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(long ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (long item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    public boolean retainAll(LongIterable source) {
        int oldSize = this.size();
        Object sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
        LongHashSet retained = this.select(new LongPredicate((LongSet)sourceSet){
            final /* synthetic */ LongSet val$sourceSet;
            {
                this.val$sourceSet = longSet;
            }

            public boolean accept(long value) {
                return this.val$sourceSet.contains(value);
            }
        });
        if (retained.size() != oldSize) {
            this.zeroToThirtyOne = retained.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = retained.zeroToThirtyOneOccupied;
            this.occupiedWithData = retained.occupiedWithData;
            this.occupiedWithSentinels = retained.occupiedWithSentinels;
            this.table = retained.table;
            return true;
        }
        return false;
    }

    public boolean retainAll(long ... source) {
        return this.retainAll((LongIterable)LongHashSet.newSetWith(source));
    }

    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new long[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, 0L);
        }
    }

    public LongHashSet with(long element) {
        this.add(element);
        return this;
    }

    public LongHashSet without(long element) {
        this.remove(element);
        return this;
    }

    public LongHashSet withAll(LongIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    public LongHashSet withoutAll(LongIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public MutableLongSet asUnmodifiable() {
        return new UnmodifiableLongSet(this);
    }

    public MutableLongSet asSynchronized() {
        return new SynchronizedLongSet(this);
    }

    public ImmutableLongSet toImmutable() {
        if (this.size() == 0) {
            return LongSets.immutable.with();
        }
        if (this.size() == 1) {
            return LongSets.immutable.with(this.longIterator().next());
        }
        LongHashSet mutableSet = LongHashSet.newSetWith(this.toArray());
        return new ImmutableLongHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    public LongIterator longIterator() {
        return new InternalLongIterator();
    }

    public long[] toArray() {
        long value;
        long[] array = new long[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            array[j] = value = (long)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!LongHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    public boolean contains(long value) {
        if (LongHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> (int)value & 1) != 0;
        }
        return this.table[this.probe(value)] == value;
    }

    public boolean containsAll(long ... source) {
        for (long item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void forEach(LongProcedure procedure) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    public LongHashSet select(LongPredicate predicate) {
        long value;
        LongHashSet result = new LongHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            result.add(value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public MutableLongSet reject(LongPredicate predicate) {
        long value;
        LongHashSet result = new LongHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            result.add(value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        long value;
        UnifiedSet target = UnifiedSet.newSet(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    public int count(LongPredicate predicate) {
        long value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        long value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return false;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public long sum() {
        long value;
        long result = 0L;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += value;
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            result += value2;
        }
        return result;
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (long value : this.table) {
            if (!LongHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (long value : this.table) {
            if (!LongHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    public LongSet freeze() {
        if (this.size() == 0) {
            return LongSets.immutable.with();
        }
        if (this.size() == 1) {
            return LongSets.immutable.with(this.longIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableLongHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        long value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeLong(value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            out.writeLong(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readLong());
        }
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        long value;
        Object result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (long value2 : this.table) {
            if (!LongHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.table.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.table.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        long[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    private void allocateTable(int sizeToAllocate) {
        this.table = new long[sizeToAllocate];
    }

    int probe(long element) {
        int index = this.spread(element);
        long valueAtIndex = this.table[index];
        if (valueAtIndex == element || valueAtIndex == 0L) {
            return index;
        }
        int removedIndex = valueAtIndex == 1L ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex = nextIndex + probe & this.table.length - 1;
            probe += 17;
            if (this.table[nextIndex] == element) {
                return nextIndex;
            }
            if (this.table[nextIndex] == 1L) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.table[nextIndex] == 0L) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(long element) {
        long code = element;
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        long[] copy = new long[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, Math.min(this.table.length, this.table.length));
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        int capacity = this.table.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.table.length / 4;
    }

    private static boolean isNonSentinel(long value) {
        return value != 0L && value != 1L;
    }

    private class InternalLongIterator
    implements LongIterator {
        private int count;
        private int position;
        private long zeroToThirtyOne;

        private InternalLongIterator() {
        }

        public boolean hasNext() {
            return this.count < LongHashSet.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32L) {
                if (LongHashSet.this.contains(this.zeroToThirtyOne)) {
                    long result = this.zeroToThirtyOne++;
                    return result;
                }
                ++this.zeroToThirtyOne;
            }
            long[] table = LongHashSet.this.table;
            while (!LongHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            long result = table[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImmutableLongHashSet
    implements ImmutableLongSet,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableLongHashSet(long[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use LongSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableLongSet newSetWith(long ... elements) {
            return LongHashSet.newSetWith(elements).toImmutable();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LongSet)) {
                return false;
            }
            LongSet other = (LongSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            long value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (int)(value ^ value >>> 32);
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!LongHashSet.isNonSentinel(this.table[i])) continue;
                    result += (int)(this.table[i] ^ this.table[i] >>> 32);
                }
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public ImmutableLongSet newWith(long element) {
            return LongHashSet.newSet((LongIterable)this).with(element).toImmutable();
        }

        public ImmutableLongSet newWithout(long element) {
            return LongHashSet.newSet((LongIterable)this).without(element).toImmutable();
        }

        public ImmutableLongSet newWithAll(LongIterable elements) {
            return LongHashSet.newSet((LongIterable)this).withAll(elements).toImmutable();
        }

        public ImmutableLongSet newWithoutAll(LongIterable elements) {
            return LongHashSet.newSet((LongIterable)this).withoutAll(elements).toImmutable();
        }

        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean notEmpty() {
            return this.size() != 0;
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                long value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                    value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (long value2 : this.table) {
                    if (!LongHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public LongIterator longIterator() {
            return new InternalLongIterator();
        }

        public long[] toArray() {
            long value;
            long[] array = new long[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                array[j] = value = (long)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!LongHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        public boolean contains(long value) {
            if (LongHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> (int)value & 1) != 0;
            }
            return this.table[this.probe(value)] == value;
        }

        public boolean containsAll(long ... source) {
            for (long item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(LongIterable source) {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public void forEach(LongProcedure procedure) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        public ImmutableLongSet select(LongPredicate predicate) {
            long value;
            LongHashSet result = new LongHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                result.add(value);
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public ImmutableLongSet reject(LongPredicate predicate) {
            long value;
            LongHashSet result = new LongHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                result.add(value);
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public <V> ImmutableSet<V> collect(LongToObjectFunction<? extends V> function) {
            long value;
            UnifiedSet target = UnifiedSet.newSet(this.size());
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                target.add(function.valueOf(value));
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                target.add(function.valueOf(value2));
            }
            return target.toImmutable();
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        public int count(LongPredicate predicate) {
            long value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(LongPredicate predicate) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(LongPredicate predicate) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            long value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return false;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public MutableLongList toList() {
            return LongArrayList.newList((LongIterable)this);
        }

        public MutableLongSet toSet() {
            return LongHashSet.newSet((LongIterable)this);
        }

        public MutableLongBag toBag() {
            return LongHashBag.newBag((LongIterable)this);
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public long sum() {
            long value;
            long result = 0L;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += value;
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                result += value2;
            }
            return result;
        }

        public long max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (long value : this.table) {
                if (!LongHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        public long maxIfEmpty(long defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public long min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (long value : this.table) {
                if (!LongHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        public long minIfEmpty(long defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            long[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                long first = sortedArray[middleIndex];
                long second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public long[] toSortedArray() {
            long[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableLongList toSortedList() {
            return LongArrayList.newList((LongIterable)this).sortThis();
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            long value;
            Object result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (long value2 : this.table) {
                if (!LongHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        public LongSet freeze() {
            return this;
        }

        public ImmutableLongSet toImmutable() {
            return this;
        }

        private Object writeReplace() {
            return new ImmutableLongSetSerializationProxy((LongSet)this);
        }

        int probe(long element) {
            int index = this.spread(element);
            long valueAtIndex = this.table[index];
            if (valueAtIndex == element || valueAtIndex == 0L) {
                return index;
            }
            int removedIndex = valueAtIndex == 1L ? index : -1;
            int nextIndex = index;
            int probe = 17;
            while (true) {
                nextIndex = nextIndex + probe & this.table.length - 1;
                probe += 17;
                if (this.table[nextIndex] == element) {
                    return nextIndex;
                }
                if (this.table[nextIndex] == 1L) {
                    if (removedIndex != -1) continue;
                    removedIndex = nextIndex;
                    continue;
                }
                if (this.table[nextIndex] == 0L) break;
            }
            return removedIndex == -1 ? nextIndex : removedIndex;
        }

        int spread(long element) {
            long code = element;
            code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
            code = (code << 18) - code - 1L;
            code ^= code >>> 31;
            code *= 21L;
            code += (code << 2) + (code << 4);
            code ^= code >>> 11;
            code += code << 6;
            code ^= code >>> 22;
            return (int)code & this.table.length - 1;
        }

        private class InternalLongIterator
        implements LongIterator {
            private int count;
            private int position;
            private long zeroToThirtyOne;

            private InternalLongIterator() {
            }

            public boolean hasNext() {
                return this.count < ImmutableLongHashSet.this.size();
            }

            public long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32L) {
                    if (ImmutableLongHashSet.this.contains(this.zeroToThirtyOne)) {
                        long result = this.zeroToThirtyOne++;
                        return result;
                    }
                    ++this.zeroToThirtyOne;
                }
                long[] table = ImmutableLongHashSet.this.table;
                while (!LongHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                long result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }
}

