/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1beta1/query.proto

package com.google.firestore.v1beta1;

/**
 *
 *
 * <pre>
 * A Firestore query.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1beta1.StructuredQuery}
 */
public final class StructuredQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery)
    StructuredQueryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StructuredQuery.newBuilder() to construct.
  private StructuredQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StructuredQuery() {
    from_ = java.util.Collections.emptyList();
    orderBy_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StructuredQuery();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private StructuredQuery(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.firestore.v1beta1.StructuredQuery.Projection.Builder subBuilder = null;
              if (select_ != null) {
                subBuilder = select_.toBuilder();
              }
              select_ =
                  input.readMessage(
                      com.google.firestore.v1beta1.StructuredQuery.Projection.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(select_);
                select_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                from_ =
                    new java.util.ArrayList<
                        com.google.firestore.v1beta1.StructuredQuery.CollectionSelector>();
                mutable_bitField0_ |= 0x00000001;
              }
              from_.add(
                  input.readMessage(
                      com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.parser(),
                      extensionRegistry));
              break;
            }
          case 26:
            {
              com.google.firestore.v1beta1.StructuredQuery.Filter.Builder subBuilder = null;
              if (where_ != null) {
                subBuilder = where_.toBuilder();
              }
              where_ =
                  input.readMessage(
                      com.google.firestore.v1beta1.StructuredQuery.Filter.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(where_);
                where_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                orderBy_ =
                    new java.util.ArrayList<com.google.firestore.v1beta1.StructuredQuery.Order>();
                mutable_bitField0_ |= 0x00000002;
              }
              orderBy_.add(
                  input.readMessage(
                      com.google.firestore.v1beta1.StructuredQuery.Order.parser(),
                      extensionRegistry));
              break;
            }
          case 42:
            {
              com.google.protobuf.Int32Value.Builder subBuilder = null;
              if (limit_ != null) {
                subBuilder = limit_.toBuilder();
              }
              limit_ =
                  input.readMessage(com.google.protobuf.Int32Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(limit_);
                limit_ = subBuilder.buildPartial();
              }

              break;
            }
          case 48:
            {
              offset_ = input.readInt32();
              break;
            }
          case 58:
            {
              com.google.firestore.v1beta1.Cursor.Builder subBuilder = null;
              if (startAt_ != null) {
                subBuilder = startAt_.toBuilder();
              }
              startAt_ =
                  input.readMessage(
                      com.google.firestore.v1beta1.Cursor.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startAt_);
                startAt_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.firestore.v1beta1.Cursor.Builder subBuilder = null;
              if (endAt_ != null) {
                subBuilder = endAt_.toBuilder();
              }
              endAt_ =
                  input.readMessage(
                      com.google.firestore.v1beta1.Cursor.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endAt_);
                endAt_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        from_ = java.util.Collections.unmodifiableList(from_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        orderBy_ = java.util.Collections.unmodifiableList(orderBy_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1beta1.QueryProto
        .internal_static_google_firestore_v1beta1_StructuredQuery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1beta1.QueryProto
        .internal_static_google_firestore_v1beta1_StructuredQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1beta1.StructuredQuery.class,
            com.google.firestore.v1beta1.StructuredQuery.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A sort direction.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.v1beta1.StructuredQuery.Direction}
   */
  public enum Direction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>DIRECTION_UNSPECIFIED = 0;</code>
     */
    DIRECTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Ascending.
     * </pre>
     *
     * <code>ASCENDING = 1;</code>
     */
    ASCENDING(1),
    /**
     *
     *
     * <pre>
     * Descending.
     * </pre>
     *
     * <code>DESCENDING = 2;</code>
     */
    DESCENDING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>DIRECTION_UNSPECIFIED = 0;</code>
     */
    public static final int DIRECTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Ascending.
     * </pre>
     *
     * <code>ASCENDING = 1;</code>
     */
    public static final int ASCENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Descending.
     * </pre>
     *
     * <code>DESCENDING = 2;</code>
     */
    public static final int DESCENDING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Direction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Direction forNumber(int value) {
      switch (value) {
        case 0:
          return DIRECTION_UNSPECIFIED;
        case 1:
          return ASCENDING;
        case 2:
          return DESCENDING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Direction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Direction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Direction>() {
          public Direction findValueByNumber(int number) {
            return Direction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.v1beta1.StructuredQuery.getDescriptor().getEnumTypes().get(0);
    }

    private static final Direction[] VALUES = values();

    public static Direction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Direction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.v1beta1.StructuredQuery.Direction)
  }

  public interface CollectionSelectorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1beta1.StructuredQuery.CollectionSelector)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The collection ID.
     * When set, selects only collections with this ID.
     * </pre>
     *
     * <code>string collection_id = 2;</code>
     *
     * @return The collectionId.
     */
    java.lang.String getCollectionId();
    /**
     *
     *
     * <pre>
     * The collection ID.
     * When set, selects only collections with this ID.
     * </pre>
     *
     * <code>string collection_id = 2;</code>
     *
     * @return The bytes for collectionId.
     */
    com.google.protobuf.ByteString getCollectionIdBytes();

    /**
     *
     *
     * <pre>
     * When false, selects only collections that are immediate children of
     * the `parent` specified in the containing `RunQueryRequest`.
     * When true, selects all descendant collections.
     * </pre>
     *
     * <code>bool all_descendants = 3;</code>
     *
     * @return The allDescendants.
     */
    boolean getAllDescendants();
  }
  /**
   *
   *
   * <pre>
   * A selection of a collection, such as `messages as m1`.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.CollectionSelector}
   */
  public static final class CollectionSelector extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery.CollectionSelector)
      CollectionSelectorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CollectionSelector.newBuilder() to construct.
    private CollectionSelector(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CollectionSelector() {
      collectionId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CollectionSelector();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private CollectionSelector(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                collectionId_ = s;
                break;
              }
            case 24:
              {
                allDescendants_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_CollectionSelector_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_CollectionSelector_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.class,
              com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder.class);
    }

    public static final int COLLECTION_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object collectionId_;
    /**
     *
     *
     * <pre>
     * The collection ID.
     * When set, selects only collections with this ID.
     * </pre>
     *
     * <code>string collection_id = 2;</code>
     *
     * @return The collectionId.
     */
    public java.lang.String getCollectionId() {
      java.lang.Object ref = collectionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        collectionId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The collection ID.
     * When set, selects only collections with this ID.
     * </pre>
     *
     * <code>string collection_id = 2;</code>
     *
     * @return The bytes for collectionId.
     */
    public com.google.protobuf.ByteString getCollectionIdBytes() {
      java.lang.Object ref = collectionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        collectionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALL_DESCENDANTS_FIELD_NUMBER = 3;
    private boolean allDescendants_;
    /**
     *
     *
     * <pre>
     * When false, selects only collections that are immediate children of
     * the `parent` specified in the containing `RunQueryRequest`.
     * When true, selects all descendant collections.
     * </pre>
     *
     * <code>bool all_descendants = 3;</code>
     *
     * @return The allDescendants.
     */
    public boolean getAllDescendants() {
      return allDescendants_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getCollectionIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, collectionId_);
      }
      if (allDescendants_ != false) {
        output.writeBool(3, allDescendants_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getCollectionIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, collectionId_);
      }
      if (allDescendants_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, allDescendants_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery.CollectionSelector)) {
        return super.equals(obj);
      }
      com.google.firestore.v1beta1.StructuredQuery.CollectionSelector other =
          (com.google.firestore.v1beta1.StructuredQuery.CollectionSelector) obj;

      if (!getCollectionId().equals(other.getCollectionId())) return false;
      if (getAllDescendants() != other.getAllDescendants()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COLLECTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCollectionId().hashCode();
      hash = (37 * hash) + ALL_DESCENDANTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllDescendants());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1beta1.StructuredQuery.CollectionSelector prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A selection of a collection, such as `messages as m1`.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.CollectionSelector}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery.CollectionSelector)
        com.google.firestore.v1beta1.StructuredQuery.CollectionSelectorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_CollectionSelector_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_CollectionSelector_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.class,
                com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder.class);
      }

      // Construct using
      // com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        collectionId_ = "";

        allDescendants_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_CollectionSelector_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector
          getDefaultInstanceForType() {
        return com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector build() {
        com.google.firestore.v1beta1.StructuredQuery.CollectionSelector result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector buildPartial() {
        com.google.firestore.v1beta1.StructuredQuery.CollectionSelector result =
            new com.google.firestore.v1beta1.StructuredQuery.CollectionSelector(this);
        result.collectionId_ = collectionId_;
        result.allDescendants_ = allDescendants_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1beta1.StructuredQuery.CollectionSelector) {
          return mergeFrom((com.google.firestore.v1beta1.StructuredQuery.CollectionSelector) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.firestore.v1beta1.StructuredQuery.CollectionSelector other) {
        if (other
            == com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.getDefaultInstance())
          return this;
        if (!other.getCollectionId().isEmpty()) {
          collectionId_ = other.collectionId_;
          onChanged();
        }
        if (other.getAllDescendants() != false) {
          setAllDescendants(other.getAllDescendants());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1beta1.StructuredQuery.CollectionSelector parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.v1beta1.StructuredQuery.CollectionSelector)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object collectionId_ = "";
      /**
       *
       *
       * <pre>
       * The collection ID.
       * When set, selects only collections with this ID.
       * </pre>
       *
       * <code>string collection_id = 2;</code>
       *
       * @return The collectionId.
       */
      public java.lang.String getCollectionId() {
        java.lang.Object ref = collectionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          collectionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The collection ID.
       * When set, selects only collections with this ID.
       * </pre>
       *
       * <code>string collection_id = 2;</code>
       *
       * @return The bytes for collectionId.
       */
      public com.google.protobuf.ByteString getCollectionIdBytes() {
        java.lang.Object ref = collectionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          collectionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The collection ID.
       * When set, selects only collections with this ID.
       * </pre>
       *
       * <code>string collection_id = 2;</code>
       *
       * @param value The collectionId to set.
       * @return This builder for chaining.
       */
      public Builder setCollectionId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        collectionId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The collection ID.
       * When set, selects only collections with this ID.
       * </pre>
       *
       * <code>string collection_id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCollectionId() {

        collectionId_ = getDefaultInstance().getCollectionId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The collection ID.
       * When set, selects only collections with this ID.
       * </pre>
       *
       * <code>string collection_id = 2;</code>
       *
       * @param value The bytes for collectionId to set.
       * @return This builder for chaining.
       */
      public Builder setCollectionIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        collectionId_ = value;
        onChanged();
        return this;
      }

      private boolean allDescendants_;
      /**
       *
       *
       * <pre>
       * When false, selects only collections that are immediate children of
       * the `parent` specified in the containing `RunQueryRequest`.
       * When true, selects all descendant collections.
       * </pre>
       *
       * <code>bool all_descendants = 3;</code>
       *
       * @return The allDescendants.
       */
      public boolean getAllDescendants() {
        return allDescendants_;
      }
      /**
       *
       *
       * <pre>
       * When false, selects only collections that are immediate children of
       * the `parent` specified in the containing `RunQueryRequest`.
       * When true, selects all descendant collections.
       * </pre>
       *
       * <code>bool all_descendants = 3;</code>
       *
       * @param value The allDescendants to set.
       * @return This builder for chaining.
       */
      public Builder setAllDescendants(boolean value) {

        allDescendants_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When false, selects only collections that are immediate children of
       * the `parent` specified in the containing `RunQueryRequest`.
       * When true, selects all descendant collections.
       * </pre>
       *
       * <code>bool all_descendants = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllDescendants() {

        allDescendants_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery.CollectionSelector)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery.CollectionSelector)
    private static final com.google.firestore.v1beta1.StructuredQuery.CollectionSelector
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery.CollectionSelector();
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CollectionSelector
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CollectionSelector> PARSER =
        new com.google.protobuf.AbstractParser<CollectionSelector>() {
          @java.lang.Override
          public CollectionSelector parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new CollectionSelector(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<CollectionSelector> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CollectionSelector> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1beta1.StructuredQuery.Filter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A composite filter.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;</code>
     *
     * @return Whether the compositeFilter field is set.
     */
    boolean hasCompositeFilter();
    /**
     *
     *
     * <pre>
     * A composite filter.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;</code>
     *
     * @return The compositeFilter.
     */
    com.google.firestore.v1beta1.StructuredQuery.CompositeFilter getCompositeFilter();
    /**
     *
     *
     * <pre>
     * A composite filter.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.CompositeFilterOrBuilder
        getCompositeFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * A filter on a document field.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
     *
     * @return Whether the fieldFilter field is set.
     */
    boolean hasFieldFilter();
    /**
     *
     *
     * <pre>
     * A filter on a document field.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
     *
     * @return The fieldFilter.
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldFilter getFieldFilter();
    /**
     *
     *
     * <pre>
     * A filter on a document field.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldFilterOrBuilder getFieldFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * A filter that takes exactly one argument.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
     *
     * @return Whether the unaryFilter field is set.
     */
    boolean hasUnaryFilter();
    /**
     *
     *
     * <pre>
     * A filter that takes exactly one argument.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
     *
     * @return The unaryFilter.
     */
    com.google.firestore.v1beta1.StructuredQuery.UnaryFilter getUnaryFilter();
    /**
     *
     *
     * <pre>
     * A filter that takes exactly one argument.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.UnaryFilterOrBuilder getUnaryFilterOrBuilder();

    public com.google.firestore.v1beta1.StructuredQuery.Filter.FilterTypeCase getFilterTypeCase();
  }
  /**
   *
   *
   * <pre>
   * A filter.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.Filter}
   */
  public static final class Filter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery.Filter)
      FilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Filter.newBuilder() to construct.
    private Filter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Filter() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Filter();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Filter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Builder subBuilder =
                    null;
                if (filterTypeCase_ == 1) {
                  subBuilder =
                      ((com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_)
                          .toBuilder();
                }
                filterType_ =
                    input.readMessage(
                        com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_);
                  filterType_ = subBuilder.buildPartial();
                }
                filterTypeCase_ = 1;
                break;
              }
            case 18:
              {
                com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Builder subBuilder = null;
                if (filterTypeCase_ == 2) {
                  subBuilder =
                      ((com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_)
                          .toBuilder();
                }
                filterType_ =
                    input.readMessage(
                        com.google.firestore.v1beta1.StructuredQuery.FieldFilter.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_);
                  filterType_ = subBuilder.buildPartial();
                }
                filterTypeCase_ = 2;
                break;
              }
            case 26:
              {
                com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Builder subBuilder = null;
                if (filterTypeCase_ == 3) {
                  subBuilder =
                      ((com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_)
                          .toBuilder();
                }
                filterType_ =
                    input.readMessage(
                        com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_);
                  filterType_ = subBuilder.buildPartial();
                }
                filterTypeCase_ = 3;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_Filter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_Filter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.Filter.class,
              com.google.firestore.v1beta1.StructuredQuery.Filter.Builder.class);
    }

    private int filterTypeCase_ = 0;
    private java.lang.Object filterType_;

    public enum FilterTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      COMPOSITE_FILTER(1),
      FIELD_FILTER(2),
      UNARY_FILTER(3),
      FILTERTYPE_NOT_SET(0);
      private final int value;

      private FilterTypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FilterTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static FilterTypeCase forNumber(int value) {
        switch (value) {
          case 1:
            return COMPOSITE_FILTER;
          case 2:
            return FIELD_FILTER;
          case 3:
            return UNARY_FILTER;
          case 0:
            return FILTERTYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public FilterTypeCase getFilterTypeCase() {
      return FilterTypeCase.forNumber(filterTypeCase_);
    }

    public static final int COMPOSITE_FILTER_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * A composite filter.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;</code>
     *
     * @return Whether the compositeFilter field is set.
     */
    public boolean hasCompositeFilter() {
      return filterTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A composite filter.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;</code>
     *
     * @return The compositeFilter.
     */
    public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter getCompositeFilter() {
      if (filterTypeCase_ == 1) {
        return (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_;
      }
      return com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A composite filter.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.CompositeFilterOrBuilder
        getCompositeFilterOrBuilder() {
      if (filterTypeCase_ == 1) {
        return (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_;
      }
      return com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDefaultInstance();
    }

    public static final int FIELD_FILTER_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * A filter on a document field.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
     *
     * @return Whether the fieldFilter field is set.
     */
    public boolean hasFieldFilter() {
      return filterTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A filter on a document field.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
     *
     * @return The fieldFilter.
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldFilter getFieldFilter() {
      if (filterTypeCase_ == 2) {
        return (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_;
      }
      return com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A filter on a document field.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldFilterOrBuilder
        getFieldFilterOrBuilder() {
      if (filterTypeCase_ == 2) {
        return (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_;
      }
      return com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDefaultInstance();
    }

    public static final int UNARY_FILTER_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * A filter that takes exactly one argument.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
     *
     * @return Whether the unaryFilter field is set.
     */
    public boolean hasUnaryFilter() {
      return filterTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A filter that takes exactly one argument.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
     *
     * @return The unaryFilter.
     */
    public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter getUnaryFilter() {
      if (filterTypeCase_ == 3) {
        return (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_;
      }
      return com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A filter that takes exactly one argument.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.UnaryFilterOrBuilder
        getUnaryFilterOrBuilder() {
      if (filterTypeCase_ == 3) {
        return (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_;
      }
      return com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (filterTypeCase_ == 1) {
        output.writeMessage(
            1, (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_);
      }
      if (filterTypeCase_ == 2) {
        output.writeMessage(
            2, (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_);
      }
      if (filterTypeCase_ == 3) {
        output.writeMessage(
            3, (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (filterTypeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_);
      }
      if (filterTypeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_);
      }
      if (filterTypeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery.Filter)) {
        return super.equals(obj);
      }
      com.google.firestore.v1beta1.StructuredQuery.Filter other =
          (com.google.firestore.v1beta1.StructuredQuery.Filter) obj;

      if (!getFilterTypeCase().equals(other.getFilterTypeCase())) return false;
      switch (filterTypeCase_) {
        case 1:
          if (!getCompositeFilter().equals(other.getCompositeFilter())) return false;
          break;
        case 2:
          if (!getFieldFilter().equals(other.getFieldFilter())) return false;
          break;
        case 3:
          if (!getUnaryFilter().equals(other.getUnaryFilter())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (filterTypeCase_) {
        case 1:
          hash = (37 * hash) + COMPOSITE_FILTER_FIELD_NUMBER;
          hash = (53 * hash) + getCompositeFilter().hashCode();
          break;
        case 2:
          hash = (37 * hash) + FIELD_FILTER_FIELD_NUMBER;
          hash = (53 * hash) + getFieldFilter().hashCode();
          break;
        case 3:
          hash = (37 * hash) + UNARY_FILTER_FIELD_NUMBER;
          hash = (53 * hash) + getUnaryFilter().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1beta1.StructuredQuery.Filter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A filter.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.Filter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery.Filter)
        com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Filter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Filter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1beta1.StructuredQuery.Filter.class,
                com.google.firestore.v1beta1.StructuredQuery.Filter.Builder.class);
      }

      // Construct using com.google.firestore.v1beta1.StructuredQuery.Filter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        filterTypeCase_ = 0;
        filterType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Filter_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Filter getDefaultInstanceForType() {
        return com.google.firestore.v1beta1.StructuredQuery.Filter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Filter build() {
        com.google.firestore.v1beta1.StructuredQuery.Filter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Filter buildPartial() {
        com.google.firestore.v1beta1.StructuredQuery.Filter result =
            new com.google.firestore.v1beta1.StructuredQuery.Filter(this);
        if (filterTypeCase_ == 1) {
          if (compositeFilterBuilder_ == null) {
            result.filterType_ = filterType_;
          } else {
            result.filterType_ = compositeFilterBuilder_.build();
          }
        }
        if (filterTypeCase_ == 2) {
          if (fieldFilterBuilder_ == null) {
            result.filterType_ = filterType_;
          } else {
            result.filterType_ = fieldFilterBuilder_.build();
          }
        }
        if (filterTypeCase_ == 3) {
          if (unaryFilterBuilder_ == null) {
            result.filterType_ = filterType_;
          } else {
            result.filterType_ = unaryFilterBuilder_.build();
          }
        }
        result.filterTypeCase_ = filterTypeCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1beta1.StructuredQuery.Filter) {
          return mergeFrom((com.google.firestore.v1beta1.StructuredQuery.Filter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1beta1.StructuredQuery.Filter other) {
        if (other == com.google.firestore.v1beta1.StructuredQuery.Filter.getDefaultInstance())
          return this;
        switch (other.getFilterTypeCase()) {
          case COMPOSITE_FILTER:
            {
              mergeCompositeFilter(other.getCompositeFilter());
              break;
            }
          case FIELD_FILTER:
            {
              mergeFieldFilter(other.getFieldFilter());
              break;
            }
          case UNARY_FILTER:
            {
              mergeUnaryFilter(other.getUnaryFilter());
              break;
            }
          case FILTERTYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1beta1.StructuredQuery.Filter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.v1beta1.StructuredQuery.Filter) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int filterTypeCase_ = 0;
      private java.lang.Object filterType_;

      public FilterTypeCase getFilterTypeCase() {
        return FilterTypeCase.forNumber(filterTypeCase_);
      }

      public Builder clearFilterType() {
        filterTypeCase_ = 0;
        filterType_ = null;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.CompositeFilter,
              com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Builder,
              com.google.firestore.v1beta1.StructuredQuery.CompositeFilterOrBuilder>
          compositeFilterBuilder_;
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       *
       * @return Whether the compositeFilter field is set.
       */
      public boolean hasCompositeFilter() {
        return filterTypeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       *
       * @return The compositeFilter.
       */
      public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter getCompositeFilter() {
        if (compositeFilterBuilder_ == null) {
          if (filterTypeCase_ == 1) {
            return (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_;
          }
          return com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDefaultInstance();
        } else {
          if (filterTypeCase_ == 1) {
            return compositeFilterBuilder_.getMessage();
          }
          return com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       */
      public Builder setCompositeFilter(
          com.google.firestore.v1beta1.StructuredQuery.CompositeFilter value) {
        if (compositeFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          filterType_ = value;
          onChanged();
        } else {
          compositeFilterBuilder_.setMessage(value);
        }
        filterTypeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       */
      public Builder setCompositeFilter(
          com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Builder builderForValue) {
        if (compositeFilterBuilder_ == null) {
          filterType_ = builderForValue.build();
          onChanged();
        } else {
          compositeFilterBuilder_.setMessage(builderForValue.build());
        }
        filterTypeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       */
      public Builder mergeCompositeFilter(
          com.google.firestore.v1beta1.StructuredQuery.CompositeFilter value) {
        if (compositeFilterBuilder_ == null) {
          if (filterTypeCase_ == 1
              && filterType_
                  != com.google.firestore.v1beta1.StructuredQuery.CompositeFilter
                      .getDefaultInstance()) {
            filterType_ =
                com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.newBuilder(
                        (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            filterType_ = value;
          }
          onChanged();
        } else {
          if (filterTypeCase_ == 1) {
            compositeFilterBuilder_.mergeFrom(value);
          }
          compositeFilterBuilder_.setMessage(value);
        }
        filterTypeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       */
      public Builder clearCompositeFilter() {
        if (compositeFilterBuilder_ == null) {
          if (filterTypeCase_ == 1) {
            filterTypeCase_ = 0;
            filterType_ = null;
            onChanged();
          }
        } else {
          if (filterTypeCase_ == 1) {
            filterTypeCase_ = 0;
            filterType_ = null;
          }
          compositeFilterBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Builder
          getCompositeFilterBuilder() {
        return getCompositeFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.CompositeFilterOrBuilder
          getCompositeFilterOrBuilder() {
        if ((filterTypeCase_ == 1) && (compositeFilterBuilder_ != null)) {
          return compositeFilterBuilder_.getMessageOrBuilder();
        } else {
          if (filterTypeCase_ == 1) {
            return (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_;
          }
          return com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A composite filter.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter composite_filter = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.CompositeFilter,
              com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Builder,
              com.google.firestore.v1beta1.StructuredQuery.CompositeFilterOrBuilder>
          getCompositeFilterFieldBuilder() {
        if (compositeFilterBuilder_ == null) {
          if (!(filterTypeCase_ == 1)) {
            filterType_ =
                com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDefaultInstance();
          }
          compositeFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1beta1.StructuredQuery.CompositeFilter,
                  com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Builder,
                  com.google.firestore.v1beta1.StructuredQuery.CompositeFilterOrBuilder>(
                  (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) filterType_,
                  getParentForChildren(),
                  isClean());
          filterType_ = null;
        }
        filterTypeCase_ = 1;
        onChanged();
        ;
        return compositeFilterBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldFilter,
              com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldFilterOrBuilder>
          fieldFilterBuilder_;
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       *
       * @return Whether the fieldFilter field is set.
       */
      public boolean hasFieldFilter() {
        return filterTypeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       *
       * @return The fieldFilter.
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldFilter getFieldFilter() {
        if (fieldFilterBuilder_ == null) {
          if (filterTypeCase_ == 2) {
            return (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_;
          }
          return com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDefaultInstance();
        } else {
          if (filterTypeCase_ == 2) {
            return fieldFilterBuilder_.getMessage();
          }
          return com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       */
      public Builder setFieldFilter(
          com.google.firestore.v1beta1.StructuredQuery.FieldFilter value) {
        if (fieldFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          filterType_ = value;
          onChanged();
        } else {
          fieldFilterBuilder_.setMessage(value);
        }
        filterTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       */
      public Builder setFieldFilter(
          com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Builder builderForValue) {
        if (fieldFilterBuilder_ == null) {
          filterType_ = builderForValue.build();
          onChanged();
        } else {
          fieldFilterBuilder_.setMessage(builderForValue.build());
        }
        filterTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       */
      public Builder mergeFieldFilter(
          com.google.firestore.v1beta1.StructuredQuery.FieldFilter value) {
        if (fieldFilterBuilder_ == null) {
          if (filterTypeCase_ == 2
              && filterType_
                  != com.google.firestore.v1beta1.StructuredQuery.FieldFilter
                      .getDefaultInstance()) {
            filterType_ =
                com.google.firestore.v1beta1.StructuredQuery.FieldFilter.newBuilder(
                        (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            filterType_ = value;
          }
          onChanged();
        } else {
          if (filterTypeCase_ == 2) {
            fieldFilterBuilder_.mergeFrom(value);
          }
          fieldFilterBuilder_.setMessage(value);
        }
        filterTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       */
      public Builder clearFieldFilter() {
        if (fieldFilterBuilder_ == null) {
          if (filterTypeCase_ == 2) {
            filterTypeCase_ = 0;
            filterType_ = null;
            onChanged();
          }
        } else {
          if (filterTypeCase_ == 2) {
            filterTypeCase_ = 0;
            filterType_ = null;
          }
          fieldFilterBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Builder
          getFieldFilterBuilder() {
        return getFieldFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldFilterOrBuilder
          getFieldFilterOrBuilder() {
        if ((filterTypeCase_ == 2) && (fieldFilterBuilder_ != null)) {
          return fieldFilterBuilder_.getMessageOrBuilder();
        } else {
          if (filterTypeCase_ == 2) {
            return (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_;
          }
          return com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A filter on a document field.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter field_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldFilter,
              com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldFilterOrBuilder>
          getFieldFilterFieldBuilder() {
        if (fieldFilterBuilder_ == null) {
          if (!(filterTypeCase_ == 2)) {
            filterType_ =
                com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDefaultInstance();
          }
          fieldFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1beta1.StructuredQuery.FieldFilter,
                  com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Builder,
                  com.google.firestore.v1beta1.StructuredQuery.FieldFilterOrBuilder>(
                  (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) filterType_,
                  getParentForChildren(),
                  isClean());
          filterType_ = null;
        }
        filterTypeCase_ = 2;
        onChanged();
        ;
        return fieldFilterBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.UnaryFilter,
              com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Builder,
              com.google.firestore.v1beta1.StructuredQuery.UnaryFilterOrBuilder>
          unaryFilterBuilder_;
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       *
       * @return Whether the unaryFilter field is set.
       */
      public boolean hasUnaryFilter() {
        return filterTypeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       *
       * @return The unaryFilter.
       */
      public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter getUnaryFilter() {
        if (unaryFilterBuilder_ == null) {
          if (filterTypeCase_ == 3) {
            return (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_;
          }
          return com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDefaultInstance();
        } else {
          if (filterTypeCase_ == 3) {
            return unaryFilterBuilder_.getMessage();
          }
          return com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       */
      public Builder setUnaryFilter(
          com.google.firestore.v1beta1.StructuredQuery.UnaryFilter value) {
        if (unaryFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          filterType_ = value;
          onChanged();
        } else {
          unaryFilterBuilder_.setMessage(value);
        }
        filterTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       */
      public Builder setUnaryFilter(
          com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Builder builderForValue) {
        if (unaryFilterBuilder_ == null) {
          filterType_ = builderForValue.build();
          onChanged();
        } else {
          unaryFilterBuilder_.setMessage(builderForValue.build());
        }
        filterTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       */
      public Builder mergeUnaryFilter(
          com.google.firestore.v1beta1.StructuredQuery.UnaryFilter value) {
        if (unaryFilterBuilder_ == null) {
          if (filterTypeCase_ == 3
              && filterType_
                  != com.google.firestore.v1beta1.StructuredQuery.UnaryFilter
                      .getDefaultInstance()) {
            filterType_ =
                com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.newBuilder(
                        (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            filterType_ = value;
          }
          onChanged();
        } else {
          if (filterTypeCase_ == 3) {
            unaryFilterBuilder_.mergeFrom(value);
          }
          unaryFilterBuilder_.setMessage(value);
        }
        filterTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       */
      public Builder clearUnaryFilter() {
        if (unaryFilterBuilder_ == null) {
          if (filterTypeCase_ == 3) {
            filterTypeCase_ = 0;
            filterType_ = null;
            onChanged();
          }
        } else {
          if (filterTypeCase_ == 3) {
            filterTypeCase_ = 0;
            filterType_ = null;
          }
          unaryFilterBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Builder
          getUnaryFilterBuilder() {
        return getUnaryFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.UnaryFilterOrBuilder
          getUnaryFilterOrBuilder() {
        if ((filterTypeCase_ == 3) && (unaryFilterBuilder_ != null)) {
          return unaryFilterBuilder_.getMessageOrBuilder();
        } else {
          if (filterTypeCase_ == 3) {
            return (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_;
          }
          return com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A filter that takes exactly one argument.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter unary_filter = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.UnaryFilter,
              com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Builder,
              com.google.firestore.v1beta1.StructuredQuery.UnaryFilterOrBuilder>
          getUnaryFilterFieldBuilder() {
        if (unaryFilterBuilder_ == null) {
          if (!(filterTypeCase_ == 3)) {
            filterType_ =
                com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDefaultInstance();
          }
          unaryFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1beta1.StructuredQuery.UnaryFilter,
                  com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Builder,
                  com.google.firestore.v1beta1.StructuredQuery.UnaryFilterOrBuilder>(
                  (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) filterType_,
                  getParentForChildren(),
                  isClean());
          filterType_ = null;
        }
        filterTypeCase_ = 3;
        onChanged();
        ;
        return unaryFilterBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery.Filter)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery.Filter)
    private static final com.google.firestore.v1beta1.StructuredQuery.Filter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery.Filter();
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Filter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Filter> PARSER =
        new com.google.protobuf.AbstractParser<Filter>() {
          @java.lang.Override
          public Filter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Filter(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Filter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Filter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery.Filter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CompositeFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1beta1.StructuredQuery.CompositeFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The operator for combining multiple filters.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
     *
     * @return The enum numeric value on the wire for op.
     */
    int getOpValue();
    /**
     *
     *
     * <pre>
     * The operator for combining multiple filters.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
     *
     * @return The op.
     */
    com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator getOp();

    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    java.util.List<com.google.firestore.v1beta1.StructuredQuery.Filter> getFiltersList();
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.Filter getFilters(int index);
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    int getFiltersCount();
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    java.util.List<? extends com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>
        getFiltersOrBuilderList();
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder getFiltersOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A filter that merges multiple other filters using the given operator.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.CompositeFilter}
   */
  public static final class CompositeFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery.CompositeFilter)
      CompositeFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CompositeFilter.newBuilder() to construct.
    private CompositeFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CompositeFilter() {
      op_ = 0;
      filters_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CompositeFilter();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private CompositeFilter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();

                op_ = rawValue;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  filters_ =
                      new java.util.ArrayList<
                          com.google.firestore.v1beta1.StructuredQuery.Filter>();
                  mutable_bitField0_ |= 0x00000001;
                }
                filters_.add(
                    input.readMessage(
                        com.google.firestore.v1beta1.StructuredQuery.Filter.parser(),
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          filters_ = java.util.Collections.unmodifiableList(filters_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_CompositeFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_CompositeFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.class,
              com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * A composite filter operator.
     * </pre>
     *
     * Protobuf enum {@code google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator}
     */
    public enum Operator implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified. This value must not be used.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      OPERATOR_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The results are required to satisfy each of the combined filters.
       * </pre>
       *
       * <code>AND = 1;</code>
       */
      AND(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified. This value must not be used.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      public static final int OPERATOR_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The results are required to satisfy each of the combined filters.
       * </pre>
       *
       * <code>AND = 1;</code>
       */
      public static final int AND_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Operator valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Operator forNumber(int value) {
        switch (value) {
          case 0:
            return OPERATOR_UNSPECIFIED;
          case 1:
            return AND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Operator> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Operator> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Operator>() {
            public Operator findValueByNumber(int number) {
              return Operator.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Operator[] VALUES = values();

      public static Operator valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Operator(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator)
    }

    public static final int OP_FIELD_NUMBER = 1;
    private int op_;
    /**
     *
     *
     * <pre>
     * The operator for combining multiple filters.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
     *
     * @return The enum numeric value on the wire for op.
     */
    public int getOpValue() {
      return op_;
    }
    /**
     *
     *
     * <pre>
     * The operator for combining multiple filters.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
     *
     * @return The op.
     */
    public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator getOp() {
      @SuppressWarnings("deprecation")
      com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator result =
          com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator.valueOf(op_);
      return result == null
          ? com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator.UNRECOGNIZED
          : result;
    }

    public static final int FILTERS_FIELD_NUMBER = 2;
    private java.util.List<com.google.firestore.v1beta1.StructuredQuery.Filter> filters_;
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    public java.util.List<com.google.firestore.v1beta1.StructuredQuery.Filter> getFiltersList() {
      return filters_;
    }
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    public java.util.List<? extends com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>
        getFiltersOrBuilderList() {
      return filters_;
    }
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    public int getFiltersCount() {
      return filters_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.Filter getFilters(int index) {
      return filters_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of filters to combine.
     * Must contain at least one filter.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder getFiltersOrBuilder(
        int index) {
      return filters_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (op_
          != com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator
              .OPERATOR_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, op_);
      }
      for (int i = 0; i < filters_.size(); i++) {
        output.writeMessage(2, filters_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (op_
          != com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator
              .OPERATOR_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, op_);
      }
      for (int i = 0; i < filters_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, filters_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery.CompositeFilter)) {
        return super.equals(obj);
      }
      com.google.firestore.v1beta1.StructuredQuery.CompositeFilter other =
          (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) obj;

      if (op_ != other.op_) return false;
      if (!getFiltersList().equals(other.getFiltersList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OP_FIELD_NUMBER;
      hash = (53 * hash) + op_;
      if (getFiltersCount() > 0) {
        hash = (37 * hash) + FILTERS_FIELD_NUMBER;
        hash = (53 * hash) + getFiltersList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1beta1.StructuredQuery.CompositeFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A filter that merges multiple other filters using the given operator.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.CompositeFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery.CompositeFilter)
        com.google.firestore.v1beta1.StructuredQuery.CompositeFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_CompositeFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_CompositeFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.class,
                com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Builder.class);
      }

      // Construct using com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFiltersFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        op_ = 0;

        if (filtersBuilder_ == null) {
          filters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          filtersBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_CompositeFilter_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter
          getDefaultInstanceForType() {
        return com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter build() {
        com.google.firestore.v1beta1.StructuredQuery.CompositeFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter buildPartial() {
        com.google.firestore.v1beta1.StructuredQuery.CompositeFilter result =
            new com.google.firestore.v1beta1.StructuredQuery.CompositeFilter(this);
        int from_bitField0_ = bitField0_;
        result.op_ = op_;
        if (filtersBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            filters_ = java.util.Collections.unmodifiableList(filters_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.filters_ = filters_;
        } else {
          result.filters_ = filtersBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) {
          return mergeFrom((com.google.firestore.v1beta1.StructuredQuery.CompositeFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1beta1.StructuredQuery.CompositeFilter other) {
        if (other
            == com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.getDefaultInstance())
          return this;
        if (other.op_ != 0) {
          setOpValue(other.getOpValue());
        }
        if (filtersBuilder_ == null) {
          if (!other.filters_.isEmpty()) {
            if (filters_.isEmpty()) {
              filters_ = other.filters_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFiltersIsMutable();
              filters_.addAll(other.filters_);
            }
            onChanged();
          }
        } else {
          if (!other.filters_.isEmpty()) {
            if (filtersBuilder_.isEmpty()) {
              filtersBuilder_.dispose();
              filtersBuilder_ = null;
              filters_ = other.filters_;
              bitField0_ = (bitField0_ & ~0x00000001);
              filtersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFiltersFieldBuilder()
                      : null;
            } else {
              filtersBuilder_.addAllMessages(other.filters_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1beta1.StructuredQuery.CompositeFilter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.v1beta1.StructuredQuery.CompositeFilter)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int op_ = 0;
      /**
       *
       *
       * <pre>
       * The operator for combining multiple filters.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
       *
       * @return The enum numeric value on the wire for op.
       */
      public int getOpValue() {
        return op_;
      }
      /**
       *
       *
       * <pre>
       * The operator for combining multiple filters.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
       *
       * @param value The enum numeric value on the wire for op to set.
       * @return This builder for chaining.
       */
      public Builder setOpValue(int value) {
        op_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operator for combining multiple filters.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
       *
       * @return The op.
       */
      public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator getOp() {
        @SuppressWarnings("deprecation")
        com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator result =
            com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator.valueOf(op_);
        return result == null
            ? com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The operator for combining multiple filters.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
       *
       * @param value The op to set.
       * @return This builder for chaining.
       */
      public Builder setOp(
          com.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator value) {
        if (value == null) {
          throw new NullPointerException();
        }

        op_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operator for combining multiple filters.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator op = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOp() {

        op_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.firestore.v1beta1.StructuredQuery.Filter> filters_ =
          java.util.Collections.emptyList();

      private void ensureFiltersIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          filters_ =
              new java.util.ArrayList<com.google.firestore.v1beta1.StructuredQuery.Filter>(
                  filters_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.Filter,
              com.google.firestore.v1beta1.StructuredQuery.Filter.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>
          filtersBuilder_;

      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public java.util.List<com.google.firestore.v1beta1.StructuredQuery.Filter> getFiltersList() {
        if (filtersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(filters_);
        } else {
          return filtersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public int getFiltersCount() {
        if (filtersBuilder_ == null) {
          return filters_.size();
        } else {
          return filtersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.Filter getFilters(int index) {
        if (filtersBuilder_ == null) {
          return filters_.get(index);
        } else {
          return filtersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder setFilters(
          int index, com.google.firestore.v1beta1.StructuredQuery.Filter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.set(index, value);
          onChanged();
        } else {
          filtersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder setFilters(
          int index, com.google.firestore.v1beta1.StructuredQuery.Filter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.set(index, builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder addFilters(com.google.firestore.v1beta1.StructuredQuery.Filter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.add(value);
          onChanged();
        } else {
          filtersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder addFilters(
          int index, com.google.firestore.v1beta1.StructuredQuery.Filter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.add(index, value);
          onChanged();
        } else {
          filtersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder addFilters(
          com.google.firestore.v1beta1.StructuredQuery.Filter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.add(builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder addFilters(
          int index, com.google.firestore.v1beta1.StructuredQuery.Filter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.add(index, builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder addAllFilters(
          java.lang.Iterable<? extends com.google.firestore.v1beta1.StructuredQuery.Filter>
              values) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filters_);
          onChanged();
        } else {
          filtersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder clearFilters() {
        if (filtersBuilder_ == null) {
          filters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          filtersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public Builder removeFilters(int index) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.remove(index);
          onChanged();
        } else {
          filtersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.Filter.Builder getFiltersBuilder(
          int index) {
        return getFiltersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder getFiltersOrBuilder(
          int index) {
        if (filtersBuilder_ == null) {
          return filters_.get(index);
        } else {
          return filtersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public java.util.List<? extends com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>
          getFiltersOrBuilderList() {
        if (filtersBuilder_ != null) {
          return filtersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(filters_);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.Filter.Builder addFiltersBuilder() {
        return getFiltersFieldBuilder()
            .addBuilder(com.google.firestore.v1beta1.StructuredQuery.Filter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.Filter.Builder addFiltersBuilder(
          int index) {
        return getFiltersFieldBuilder()
            .addBuilder(
                index, com.google.firestore.v1beta1.StructuredQuery.Filter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of filters to combine.
       * Must contain at least one filter.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.Filter filters = 2;</code>
       */
      public java.util.List<com.google.firestore.v1beta1.StructuredQuery.Filter.Builder>
          getFiltersBuilderList() {
        return getFiltersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.Filter,
              com.google.firestore.v1beta1.StructuredQuery.Filter.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>
          getFiltersFieldBuilder() {
        if (filtersBuilder_ == null) {
          filtersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.firestore.v1beta1.StructuredQuery.Filter,
                  com.google.firestore.v1beta1.StructuredQuery.Filter.Builder,
                  com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>(
                  filters_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          filters_ = null;
        }
        return filtersBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery.CompositeFilter)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery.CompositeFilter)
    private static final com.google.firestore.v1beta1.StructuredQuery.CompositeFilter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery.CompositeFilter();
    }

    public static com.google.firestore.v1beta1.StructuredQuery.CompositeFilter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CompositeFilter> PARSER =
        new com.google.protobuf.AbstractParser<CompositeFilter>() {
          @java.lang.Override
          public CompositeFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new CompositeFilter(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<CompositeFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CompositeFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery.CompositeFilter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FieldFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1beta1.StructuredQuery.FieldFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The field to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     *
     * @return Whether the field field is set.
     */
    boolean hasField();
    /**
     *
     *
     * <pre>
     * The field to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     *
     * @return The field.
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldReference getField();
    /**
     *
     *
     * <pre>
     * The field to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder getFieldOrBuilder();

    /**
     *
     *
     * <pre>
     * The operator to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
     *
     * @return The enum numeric value on the wire for op.
     */
    int getOpValue();
    /**
     *
     *
     * <pre>
     * The operator to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
     *
     * @return The op.
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator getOp();

    /**
     *
     *
     * <pre>
     * The value to compare to.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Value value = 3;</code>
     *
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     *
     *
     * <pre>
     * The value to compare to.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Value value = 3;</code>
     *
     * @return The value.
     */
    com.google.firestore.v1beta1.Value getValue();
    /**
     *
     *
     * <pre>
     * The value to compare to.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Value value = 3;</code>
     */
    com.google.firestore.v1beta1.ValueOrBuilder getValueOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A filter on a specific field.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.FieldFilter}
   */
  public static final class FieldFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery.FieldFilter)
      FieldFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FieldFilter.newBuilder() to construct.
    private FieldFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FieldFilter() {
      op_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FieldFilter();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private FieldFilter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder subBuilder =
                    null;
                if (field_ != null) {
                  subBuilder = field_.toBuilder();
                }
                field_ =
                    input.readMessage(
                        com.google.firestore.v1beta1.StructuredQuery.FieldReference.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(field_);
                  field_ = subBuilder.buildPartial();
                }

                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                op_ = rawValue;
                break;
              }
            case 26:
              {
                com.google.firestore.v1beta1.Value.Builder subBuilder = null;
                if (value_ != null) {
                  subBuilder = value_.toBuilder();
                }
                value_ =
                    input.readMessage(
                        com.google.firestore.v1beta1.Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(value_);
                  value_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_FieldFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_FieldFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.FieldFilter.class,
              com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * A field filter operator.
     * </pre>
     *
     * Protobuf enum {@code google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator}
     */
    public enum Operator implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified. This value must not be used.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      OPERATOR_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Less than. Requires that the field come first in `order_by`.
       * </pre>
       *
       * <code>LESS_THAN = 1;</code>
       */
      LESS_THAN(1),
      /**
       *
       *
       * <pre>
       * Less than or equal. Requires that the field come first in `order_by`.
       * </pre>
       *
       * <code>LESS_THAN_OR_EQUAL = 2;</code>
       */
      LESS_THAN_OR_EQUAL(2),
      /**
       *
       *
       * <pre>
       * Greater than. Requires that the field come first in `order_by`.
       * </pre>
       *
       * <code>GREATER_THAN = 3;</code>
       */
      GREATER_THAN(3),
      /**
       *
       *
       * <pre>
       * Greater than or equal. Requires that the field come first in
       * `order_by`.
       * </pre>
       *
       * <code>GREATER_THAN_OR_EQUAL = 4;</code>
       */
      GREATER_THAN_OR_EQUAL(4),
      /**
       *
       *
       * <pre>
       * Equal.
       * </pre>
       *
       * <code>EQUAL = 5;</code>
       */
      EQUAL(5),
      /**
       *
       *
       * <pre>
       * Contains. Requires that the field is an array.
       * </pre>
       *
       * <code>ARRAY_CONTAINS = 7;</code>
       */
      ARRAY_CONTAINS(7),
      /**
       *
       *
       * <pre>
       * In. Requires that `value` is a non-empty ArrayValue with at most 10
       * values.
       * </pre>
       *
       * <code>IN = 8;</code>
       */
      IN(8),
      /**
       *
       *
       * <pre>
       * Contains any. Requires that the field is an array and
       * `value` is a non-empty ArrayValue with at most 10 values.
       * </pre>
       *
       * <code>ARRAY_CONTAINS_ANY = 9;</code>
       */
      ARRAY_CONTAINS_ANY(9),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified. This value must not be used.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      public static final int OPERATOR_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Less than. Requires that the field come first in `order_by`.
       * </pre>
       *
       * <code>LESS_THAN = 1;</code>
       */
      public static final int LESS_THAN_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Less than or equal. Requires that the field come first in `order_by`.
       * </pre>
       *
       * <code>LESS_THAN_OR_EQUAL = 2;</code>
       */
      public static final int LESS_THAN_OR_EQUAL_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Greater than. Requires that the field come first in `order_by`.
       * </pre>
       *
       * <code>GREATER_THAN = 3;</code>
       */
      public static final int GREATER_THAN_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Greater than or equal. Requires that the field come first in
       * `order_by`.
       * </pre>
       *
       * <code>GREATER_THAN_OR_EQUAL = 4;</code>
       */
      public static final int GREATER_THAN_OR_EQUAL_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Equal.
       * </pre>
       *
       * <code>EQUAL = 5;</code>
       */
      public static final int EQUAL_VALUE = 5;
      /**
       *
       *
       * <pre>
       * Contains. Requires that the field is an array.
       * </pre>
       *
       * <code>ARRAY_CONTAINS = 7;</code>
       */
      public static final int ARRAY_CONTAINS_VALUE = 7;
      /**
       *
       *
       * <pre>
       * In. Requires that `value` is a non-empty ArrayValue with at most 10
       * values.
       * </pre>
       *
       * <code>IN = 8;</code>
       */
      public static final int IN_VALUE = 8;
      /**
       *
       *
       * <pre>
       * Contains any. Requires that the field is an array and
       * `value` is a non-empty ArrayValue with at most 10 values.
       * </pre>
       *
       * <code>ARRAY_CONTAINS_ANY = 9;</code>
       */
      public static final int ARRAY_CONTAINS_ANY_VALUE = 9;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Operator valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Operator forNumber(int value) {
        switch (value) {
          case 0:
            return OPERATOR_UNSPECIFIED;
          case 1:
            return LESS_THAN;
          case 2:
            return LESS_THAN_OR_EQUAL;
          case 3:
            return GREATER_THAN;
          case 4:
            return GREATER_THAN_OR_EQUAL;
          case 5:
            return EQUAL;
          case 7:
            return ARRAY_CONTAINS;
          case 8:
            return IN;
          case 9:
            return ARRAY_CONTAINS_ANY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Operator> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Operator> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Operator>() {
            public Operator findValueByNumber(int number) {
              return Operator.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Operator[] VALUES = values();

      public static Operator valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Operator(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator)
    }

    public static final int FIELD_FIELD_NUMBER = 1;
    private com.google.firestore.v1beta1.StructuredQuery.FieldReference field_;
    /**
     *
     *
     * <pre>
     * The field to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     *
     * @return Whether the field field is set.
     */
    public boolean hasField() {
      return field_ != null;
    }
    /**
     *
     *
     * <pre>
     * The field to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     *
     * @return The field.
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldReference getField() {
      return field_ == null
          ? com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance()
          : field_;
    }
    /**
     *
     *
     * <pre>
     * The field to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder
        getFieldOrBuilder() {
      return getField();
    }

    public static final int OP_FIELD_NUMBER = 2;
    private int op_;
    /**
     *
     *
     * <pre>
     * The operator to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
     *
     * @return The enum numeric value on the wire for op.
     */
    public int getOpValue() {
      return op_;
    }
    /**
     *
     *
     * <pre>
     * The operator to filter by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
     *
     * @return The op.
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator getOp() {
      @SuppressWarnings("deprecation")
      com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator result =
          com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator.valueOf(op_);
      return result == null
          ? com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator.UNRECOGNIZED
          : result;
    }

    public static final int VALUE_FIELD_NUMBER = 3;
    private com.google.firestore.v1beta1.Value value_;
    /**
     *
     *
     * <pre>
     * The value to compare to.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Value value = 3;</code>
     *
     * @return Whether the value field is set.
     */
    public boolean hasValue() {
      return value_ != null;
    }
    /**
     *
     *
     * <pre>
     * The value to compare to.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Value value = 3;</code>
     *
     * @return The value.
     */
    public com.google.firestore.v1beta1.Value getValue() {
      return value_ == null ? com.google.firestore.v1beta1.Value.getDefaultInstance() : value_;
    }
    /**
     *
     *
     * <pre>
     * The value to compare to.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Value value = 3;</code>
     */
    public com.google.firestore.v1beta1.ValueOrBuilder getValueOrBuilder() {
      return getValue();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (field_ != null) {
        output.writeMessage(1, getField());
      }
      if (op_
          != com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator.OPERATOR_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, op_);
      }
      if (value_ != null) {
        output.writeMessage(3, getValue());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (field_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getField());
      }
      if (op_
          != com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator.OPERATOR_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, op_);
      }
      if (value_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getValue());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery.FieldFilter)) {
        return super.equals(obj);
      }
      com.google.firestore.v1beta1.StructuredQuery.FieldFilter other =
          (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) obj;

      if (hasField() != other.hasField()) return false;
      if (hasField()) {
        if (!getField().equals(other.getField())) return false;
      }
      if (op_ != other.op_) return false;
      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (!getValue().equals(other.getValue())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasField()) {
        hash = (37 * hash) + FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getField().hashCode();
      }
      hash = (37 * hash) + OP_FIELD_NUMBER;
      hash = (53 * hash) + op_;
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1beta1.StructuredQuery.FieldFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A filter on a specific field.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.FieldFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery.FieldFilter)
        com.google.firestore.v1beta1.StructuredQuery.FieldFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_FieldFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_FieldFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1beta1.StructuredQuery.FieldFilter.class,
                com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Builder.class);
      }

      // Construct using com.google.firestore.v1beta1.StructuredQuery.FieldFilter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (fieldBuilder_ == null) {
          field_ = null;
        } else {
          field_ = null;
          fieldBuilder_ = null;
        }
        op_ = 0;

        if (valueBuilder_ == null) {
          value_ = null;
        } else {
          value_ = null;
          valueBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_FieldFilter_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.FieldFilter getDefaultInstanceForType() {
        return com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.FieldFilter build() {
        com.google.firestore.v1beta1.StructuredQuery.FieldFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.FieldFilter buildPartial() {
        com.google.firestore.v1beta1.StructuredQuery.FieldFilter result =
            new com.google.firestore.v1beta1.StructuredQuery.FieldFilter(this);
        if (fieldBuilder_ == null) {
          result.field_ = field_;
        } else {
          result.field_ = fieldBuilder_.build();
        }
        result.op_ = op_;
        if (valueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1beta1.StructuredQuery.FieldFilter) {
          return mergeFrom((com.google.firestore.v1beta1.StructuredQuery.FieldFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1beta1.StructuredQuery.FieldFilter other) {
        if (other == com.google.firestore.v1beta1.StructuredQuery.FieldFilter.getDefaultInstance())
          return this;
        if (other.hasField()) {
          mergeField(other.getField());
        }
        if (other.op_ != 0) {
          setOpValue(other.getOpValue());
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1beta1.StructuredQuery.FieldFilter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.v1beta1.StructuredQuery.FieldFilter) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.firestore.v1beta1.StructuredQuery.FieldReference field_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldReference,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          fieldBuilder_;
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       *
       * @return Whether the field field is set.
       */
      public boolean hasField() {
        return fieldBuilder_ != null || field_ != null;
      }
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       *
       * @return The field.
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference getField() {
        if (fieldBuilder_ == null) {
          return field_ == null
              ? com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance()
              : field_;
        } else {
          return fieldBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public Builder setField(com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          field_ = value;
          onChanged();
        } else {
          fieldBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public Builder setField(
          com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder builderForValue) {
        if (fieldBuilder_ == null) {
          field_ = builderForValue.build();
          onChanged();
        } else {
          fieldBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public Builder mergeField(com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldBuilder_ == null) {
          if (field_ != null) {
            field_ =
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.newBuilder(field_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            field_ = value;
          }
          onChanged();
        } else {
          fieldBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public Builder clearField() {
        if (fieldBuilder_ == null) {
          field_ = null;
          onChanged();
        } else {
          field_ = null;
          fieldBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder getFieldBuilder() {

        onChanged();
        return getFieldFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder
          getFieldOrBuilder() {
        if (fieldBuilder_ != null) {
          return fieldBuilder_.getMessageOrBuilder();
        } else {
          return field_ == null
              ? com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance()
              : field_;
        }
      }
      /**
       *
       *
       * <pre>
       * The field to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldReference,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          getFieldFieldBuilder() {
        if (fieldBuilder_ == null) {
          fieldBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1beta1.StructuredQuery.FieldReference,
                  com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
                  com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>(
                  getField(), getParentForChildren(), isClean());
          field_ = null;
        }
        return fieldBuilder_;
      }

      private int op_ = 0;
      /**
       *
       *
       * <pre>
       * The operator to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
       *
       * @return The enum numeric value on the wire for op.
       */
      public int getOpValue() {
        return op_;
      }
      /**
       *
       *
       * <pre>
       * The operator to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
       *
       * @param value The enum numeric value on the wire for op to set.
       * @return This builder for chaining.
       */
      public Builder setOpValue(int value) {
        op_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operator to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
       *
       * @return The op.
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator getOp() {
        @SuppressWarnings("deprecation")
        com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator result =
            com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator.valueOf(op_);
        return result == null
            ? com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The operator to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
       *
       * @param value The op to set.
       * @return This builder for chaining.
       */
      public Builder setOp(
          com.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator value) {
        if (value == null) {
          throw new NullPointerException();
        }

        op_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operator to filter by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator op = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOp() {

        op_ = 0;
        onChanged();
        return this;
      }

      private com.google.firestore.v1beta1.Value value_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.Value,
              com.google.firestore.v1beta1.Value.Builder,
              com.google.firestore.v1beta1.ValueOrBuilder>
          valueBuilder_;
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       *
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return valueBuilder_ != null || value_ != null;
      }
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       *
       * @return The value.
       */
      public com.google.firestore.v1beta1.Value getValue() {
        if (valueBuilder_ == null) {
          return value_ == null ? com.google.firestore.v1beta1.Value.getDefaultInstance() : value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       */
      public Builder setValue(com.google.firestore.v1beta1.Value value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          valueBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       */
      public Builder setValue(com.google.firestore.v1beta1.Value.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       */
      public Builder mergeValue(com.google.firestore.v1beta1.Value value) {
        if (valueBuilder_ == null) {
          if (value_ != null) {
            value_ =
                com.google.firestore.v1beta1.Value.newBuilder(value_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          valueBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = null;
          onChanged();
        } else {
          value_ = null;
          valueBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       */
      public com.google.firestore.v1beta1.Value.Builder getValueBuilder() {

        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       */
      public com.google.firestore.v1beta1.ValueOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_ == null ? com.google.firestore.v1beta1.Value.getDefaultInstance() : value_;
        }
      }
      /**
       *
       *
       * <pre>
       * The value to compare to.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.Value value = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.Value,
              com.google.firestore.v1beta1.Value.Builder,
              com.google.firestore.v1beta1.ValueOrBuilder>
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1beta1.Value,
                  com.google.firestore.v1beta1.Value.Builder,
                  com.google.firestore.v1beta1.ValueOrBuilder>(
                  getValue(), getParentForChildren(), isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery.FieldFilter)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery.FieldFilter)
    private static final com.google.firestore.v1beta1.StructuredQuery.FieldFilter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery.FieldFilter();
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldFilter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FieldFilter> PARSER =
        new com.google.protobuf.AbstractParser<FieldFilter>() {
          @java.lang.Override
          public FieldFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new FieldFilter(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<FieldFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FieldFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery.FieldFilter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UnaryFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1beta1.StructuredQuery.UnaryFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The unary operator to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
     *
     * @return The enum numeric value on the wire for op.
     */
    int getOpValue();
    /**
     *
     *
     * <pre>
     * The unary operator to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
     *
     * @return The op.
     */
    com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator getOp();

    /**
     *
     *
     * <pre>
     * The field to which to apply the operator.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
     *
     * @return Whether the field field is set.
     */
    boolean hasField();
    /**
     *
     *
     * <pre>
     * The field to which to apply the operator.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
     *
     * @return The field.
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldReference getField();
    /**
     *
     *
     * <pre>
     * The field to which to apply the operator.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder getFieldOrBuilder();

    public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.OperandTypeCase
        getOperandTypeCase();
  }
  /**
   *
   *
   * <pre>
   * A filter with a single operand.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.UnaryFilter}
   */
  public static final class UnaryFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery.UnaryFilter)
      UnaryFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UnaryFilter.newBuilder() to construct.
    private UnaryFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UnaryFilter() {
      op_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UnaryFilter();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private UnaryFilter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();

                op_ = rawValue;
                break;
              }
            case 18:
              {
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder subBuilder =
                    null;
                if (operandTypeCase_ == 2) {
                  subBuilder =
                      ((com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_)
                          .toBuilder();
                }
                operandType_ =
                    input.readMessage(
                        com.google.firestore.v1beta1.StructuredQuery.FieldReference.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_);
                  operandType_ = subBuilder.buildPartial();
                }
                operandTypeCase_ = 2;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_UnaryFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_UnaryFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.class,
              com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * A unary operator.
     * </pre>
     *
     * Protobuf enum {@code google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator}
     */
    public enum Operator implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified. This value must not be used.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      OPERATOR_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Test if a field is equal to NaN.
       * </pre>
       *
       * <code>IS_NAN = 2;</code>
       */
      IS_NAN(2),
      /**
       *
       *
       * <pre>
       * Test if an expression evaluates to Null.
       * </pre>
       *
       * <code>IS_NULL = 3;</code>
       */
      IS_NULL(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified. This value must not be used.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      public static final int OPERATOR_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Test if a field is equal to NaN.
       * </pre>
       *
       * <code>IS_NAN = 2;</code>
       */
      public static final int IS_NAN_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Test if an expression evaluates to Null.
       * </pre>
       *
       * <code>IS_NULL = 3;</code>
       */
      public static final int IS_NULL_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Operator valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Operator forNumber(int value) {
        switch (value) {
          case 0:
            return OPERATOR_UNSPECIFIED;
          case 2:
            return IS_NAN;
          case 3:
            return IS_NULL;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Operator> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Operator> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Operator>() {
            public Operator findValueByNumber(int number) {
              return Operator.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Operator[] VALUES = values();

      public static Operator valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Operator(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator)
    }

    private int operandTypeCase_ = 0;
    private java.lang.Object operandType_;

    public enum OperandTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      FIELD(2),
      OPERANDTYPE_NOT_SET(0);
      private final int value;

      private OperandTypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OperandTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static OperandTypeCase forNumber(int value) {
        switch (value) {
          case 2:
            return FIELD;
          case 0:
            return OPERANDTYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OperandTypeCase getOperandTypeCase() {
      return OperandTypeCase.forNumber(operandTypeCase_);
    }

    public static final int OP_FIELD_NUMBER = 1;
    private int op_;
    /**
     *
     *
     * <pre>
     * The unary operator to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
     *
     * @return The enum numeric value on the wire for op.
     */
    public int getOpValue() {
      return op_;
    }
    /**
     *
     *
     * <pre>
     * The unary operator to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
     *
     * @return The op.
     */
    public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator getOp() {
      @SuppressWarnings("deprecation")
      com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator result =
          com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator.valueOf(op_);
      return result == null
          ? com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator.UNRECOGNIZED
          : result;
    }

    public static final int FIELD_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The field to which to apply the operator.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
     *
     * @return Whether the field field is set.
     */
    public boolean hasField() {
      return operandTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The field to which to apply the operator.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
     *
     * @return The field.
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldReference getField() {
      if (operandTypeCase_ == 2) {
        return (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_;
      }
      return com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The field to which to apply the operator.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder
        getFieldOrBuilder() {
      if (operandTypeCase_ == 2) {
        return (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_;
      }
      return com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (op_
          != com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator.OPERATOR_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, op_);
      }
      if (operandTypeCase_ == 2) {
        output.writeMessage(
            2, (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (op_
          != com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator.OPERATOR_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, op_);
      }
      if (operandTypeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery.UnaryFilter)) {
        return super.equals(obj);
      }
      com.google.firestore.v1beta1.StructuredQuery.UnaryFilter other =
          (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) obj;

      if (op_ != other.op_) return false;
      if (!getOperandTypeCase().equals(other.getOperandTypeCase())) return false;
      switch (operandTypeCase_) {
        case 2:
          if (!getField().equals(other.getField())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OP_FIELD_NUMBER;
      hash = (53 * hash) + op_;
      switch (operandTypeCase_) {
        case 2:
          hash = (37 * hash) + FIELD_FIELD_NUMBER;
          hash = (53 * hash) + getField().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1beta1.StructuredQuery.UnaryFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A filter with a single operand.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.UnaryFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery.UnaryFilter)
        com.google.firestore.v1beta1.StructuredQuery.UnaryFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_UnaryFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_UnaryFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.class,
                com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Builder.class);
      }

      // Construct using com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        op_ = 0;

        operandTypeCase_ = 0;
        operandType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_UnaryFilter_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter getDefaultInstanceForType() {
        return com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter build() {
        com.google.firestore.v1beta1.StructuredQuery.UnaryFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter buildPartial() {
        com.google.firestore.v1beta1.StructuredQuery.UnaryFilter result =
            new com.google.firestore.v1beta1.StructuredQuery.UnaryFilter(this);
        result.op_ = op_;
        if (operandTypeCase_ == 2) {
          if (fieldBuilder_ == null) {
            result.operandType_ = operandType_;
          } else {
            result.operandType_ = fieldBuilder_.build();
          }
        }
        result.operandTypeCase_ = operandTypeCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) {
          return mergeFrom((com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1beta1.StructuredQuery.UnaryFilter other) {
        if (other == com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.getDefaultInstance())
          return this;
        if (other.op_ != 0) {
          setOpValue(other.getOpValue());
        }
        switch (other.getOperandTypeCase()) {
          case FIELD:
            {
              mergeField(other.getField());
              break;
            }
          case OPERANDTYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1beta1.StructuredQuery.UnaryFilter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.v1beta1.StructuredQuery.UnaryFilter) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int operandTypeCase_ = 0;
      private java.lang.Object operandType_;

      public OperandTypeCase getOperandTypeCase() {
        return OperandTypeCase.forNumber(operandTypeCase_);
      }

      public Builder clearOperandType() {
        operandTypeCase_ = 0;
        operandType_ = null;
        onChanged();
        return this;
      }

      private int op_ = 0;
      /**
       *
       *
       * <pre>
       * The unary operator to apply.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
       *
       * @return The enum numeric value on the wire for op.
       */
      public int getOpValue() {
        return op_;
      }
      /**
       *
       *
       * <pre>
       * The unary operator to apply.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
       *
       * @param value The enum numeric value on the wire for op to set.
       * @return This builder for chaining.
       */
      public Builder setOpValue(int value) {
        op_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unary operator to apply.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
       *
       * @return The op.
       */
      public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator getOp() {
        @SuppressWarnings("deprecation")
        com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator result =
            com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator.valueOf(op_);
        return result == null
            ? com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The unary operator to apply.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
       *
       * @param value The op to set.
       * @return This builder for chaining.
       */
      public Builder setOp(
          com.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator value) {
        if (value == null) {
          throw new NullPointerException();
        }

        op_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unary operator to apply.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator op = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOp() {

        op_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldReference,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          fieldBuilder_;
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       *
       * @return Whether the field field is set.
       */
      public boolean hasField() {
        return operandTypeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       *
       * @return The field.
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference getField() {
        if (fieldBuilder_ == null) {
          if (operandTypeCase_ == 2) {
            return (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_;
          }
          return com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance();
        } else {
          if (operandTypeCase_ == 2) {
            return fieldBuilder_.getMessage();
          }
          return com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       */
      public Builder setField(com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          operandType_ = value;
          onChanged();
        } else {
          fieldBuilder_.setMessage(value);
        }
        operandTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       */
      public Builder setField(
          com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder builderForValue) {
        if (fieldBuilder_ == null) {
          operandType_ = builderForValue.build();
          onChanged();
        } else {
          fieldBuilder_.setMessage(builderForValue.build());
        }
        operandTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       */
      public Builder mergeField(com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldBuilder_ == null) {
          if (operandTypeCase_ == 2
              && operandType_
                  != com.google.firestore.v1beta1.StructuredQuery.FieldReference
                      .getDefaultInstance()) {
            operandType_ =
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.newBuilder(
                        (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            operandType_ = value;
          }
          onChanged();
        } else {
          if (operandTypeCase_ == 2) {
            fieldBuilder_.mergeFrom(value);
          }
          fieldBuilder_.setMessage(value);
        }
        operandTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       */
      public Builder clearField() {
        if (fieldBuilder_ == null) {
          if (operandTypeCase_ == 2) {
            operandTypeCase_ = 0;
            operandType_ = null;
            onChanged();
          }
        } else {
          if (operandTypeCase_ == 2) {
            operandTypeCase_ = 0;
            operandType_ = null;
          }
          fieldBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder getFieldBuilder() {
        return getFieldFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder
          getFieldOrBuilder() {
        if ((operandTypeCase_ == 2) && (fieldBuilder_ != null)) {
          return fieldBuilder_.getMessageOrBuilder();
        } else {
          if (operandTypeCase_ == 2) {
            return (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_;
          }
          return com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The field to which to apply the operator.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldReference,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          getFieldFieldBuilder() {
        if (fieldBuilder_ == null) {
          if (!(operandTypeCase_ == 2)) {
            operandType_ =
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance();
          }
          fieldBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1beta1.StructuredQuery.FieldReference,
                  com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
                  com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>(
                  (com.google.firestore.v1beta1.StructuredQuery.FieldReference) operandType_,
                  getParentForChildren(),
                  isClean());
          operandType_ = null;
        }
        operandTypeCase_ = 2;
        onChanged();
        ;
        return fieldBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery.UnaryFilter)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery.UnaryFilter)
    private static final com.google.firestore.v1beta1.StructuredQuery.UnaryFilter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery.UnaryFilter();
    }

    public static com.google.firestore.v1beta1.StructuredQuery.UnaryFilter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UnaryFilter> PARSER =
        new com.google.protobuf.AbstractParser<UnaryFilter>() {
          @java.lang.Override
          public UnaryFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new UnaryFilter(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<UnaryFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UnaryFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery.UnaryFilter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OrderOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1beta1.StructuredQuery.Order)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The field to order by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     *
     * @return Whether the field field is set.
     */
    boolean hasField();
    /**
     *
     *
     * <pre>
     * The field to order by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     *
     * @return The field.
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldReference getField();
    /**
     *
     *
     * <pre>
     * The field to order by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder getFieldOrBuilder();

    /**
     *
     *
     * <pre>
     * The direction to order by. Defaults to `ASCENDING`.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
     *
     * @return The enum numeric value on the wire for direction.
     */
    int getDirectionValue();
    /**
     *
     *
     * <pre>
     * The direction to order by. Defaults to `ASCENDING`.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
     *
     * @return The direction.
     */
    com.google.firestore.v1beta1.StructuredQuery.Direction getDirection();
  }
  /**
   *
   *
   * <pre>
   * An order on a field.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.Order}
   */
  public static final class Order extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery.Order)
      OrderOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Order.newBuilder() to construct.
    private Order(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Order() {
      direction_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Order();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Order(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder subBuilder =
                    null;
                if (field_ != null) {
                  subBuilder = field_.toBuilder();
                }
                field_ =
                    input.readMessage(
                        com.google.firestore.v1beta1.StructuredQuery.FieldReference.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(field_);
                  field_ = subBuilder.buildPartial();
                }

                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                direction_ = rawValue;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_Order_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_Order_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.Order.class,
              com.google.firestore.v1beta1.StructuredQuery.Order.Builder.class);
    }

    public static final int FIELD_FIELD_NUMBER = 1;
    private com.google.firestore.v1beta1.StructuredQuery.FieldReference field_;
    /**
     *
     *
     * <pre>
     * The field to order by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     *
     * @return Whether the field field is set.
     */
    public boolean hasField() {
      return field_ != null;
    }
    /**
     *
     *
     * <pre>
     * The field to order by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     *
     * @return The field.
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldReference getField() {
      return field_ == null
          ? com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance()
          : field_;
    }
    /**
     *
     *
     * <pre>
     * The field to order by.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder
        getFieldOrBuilder() {
      return getField();
    }

    public static final int DIRECTION_FIELD_NUMBER = 2;
    private int direction_;
    /**
     *
     *
     * <pre>
     * The direction to order by. Defaults to `ASCENDING`.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
     *
     * @return The enum numeric value on the wire for direction.
     */
    public int getDirectionValue() {
      return direction_;
    }
    /**
     *
     *
     * <pre>
     * The direction to order by. Defaults to `ASCENDING`.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
     *
     * @return The direction.
     */
    public com.google.firestore.v1beta1.StructuredQuery.Direction getDirection() {
      @SuppressWarnings("deprecation")
      com.google.firestore.v1beta1.StructuredQuery.Direction result =
          com.google.firestore.v1beta1.StructuredQuery.Direction.valueOf(direction_);
      return result == null
          ? com.google.firestore.v1beta1.StructuredQuery.Direction.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (field_ != null) {
        output.writeMessage(1, getField());
      }
      if (direction_
          != com.google.firestore.v1beta1.StructuredQuery.Direction.DIRECTION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, direction_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (field_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getField());
      }
      if (direction_
          != com.google.firestore.v1beta1.StructuredQuery.Direction.DIRECTION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, direction_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery.Order)) {
        return super.equals(obj);
      }
      com.google.firestore.v1beta1.StructuredQuery.Order other =
          (com.google.firestore.v1beta1.StructuredQuery.Order) obj;

      if (hasField() != other.hasField()) return false;
      if (hasField()) {
        if (!getField().equals(other.getField())) return false;
      }
      if (direction_ != other.direction_) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasField()) {
        hash = (37 * hash) + FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getField().hashCode();
      }
      hash = (37 * hash) + DIRECTION_FIELD_NUMBER;
      hash = (53 * hash) + direction_;
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.firestore.v1beta1.StructuredQuery.Order prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An order on a field.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.Order}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery.Order)
        com.google.firestore.v1beta1.StructuredQuery.OrderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Order_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Order_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1beta1.StructuredQuery.Order.class,
                com.google.firestore.v1beta1.StructuredQuery.Order.Builder.class);
      }

      // Construct using com.google.firestore.v1beta1.StructuredQuery.Order.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (fieldBuilder_ == null) {
          field_ = null;
        } else {
          field_ = null;
          fieldBuilder_ = null;
        }
        direction_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Order_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Order getDefaultInstanceForType() {
        return com.google.firestore.v1beta1.StructuredQuery.Order.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Order build() {
        com.google.firestore.v1beta1.StructuredQuery.Order result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Order buildPartial() {
        com.google.firestore.v1beta1.StructuredQuery.Order result =
            new com.google.firestore.v1beta1.StructuredQuery.Order(this);
        if (fieldBuilder_ == null) {
          result.field_ = field_;
        } else {
          result.field_ = fieldBuilder_.build();
        }
        result.direction_ = direction_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1beta1.StructuredQuery.Order) {
          return mergeFrom((com.google.firestore.v1beta1.StructuredQuery.Order) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1beta1.StructuredQuery.Order other) {
        if (other == com.google.firestore.v1beta1.StructuredQuery.Order.getDefaultInstance())
          return this;
        if (other.hasField()) {
          mergeField(other.getField());
        }
        if (other.direction_ != 0) {
          setDirectionValue(other.getDirectionValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1beta1.StructuredQuery.Order parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.v1beta1.StructuredQuery.Order) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.firestore.v1beta1.StructuredQuery.FieldReference field_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldReference,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          fieldBuilder_;
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       *
       * @return Whether the field field is set.
       */
      public boolean hasField() {
        return fieldBuilder_ != null || field_ != null;
      }
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       *
       * @return The field.
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference getField() {
        if (fieldBuilder_ == null) {
          return field_ == null
              ? com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance()
              : field_;
        } else {
          return fieldBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public Builder setField(com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          field_ = value;
          onChanged();
        } else {
          fieldBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public Builder setField(
          com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder builderForValue) {
        if (fieldBuilder_ == null) {
          field_ = builderForValue.build();
          onChanged();
        } else {
          fieldBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public Builder mergeField(com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldBuilder_ == null) {
          if (field_ != null) {
            field_ =
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.newBuilder(field_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            field_ = value;
          }
          onChanged();
        } else {
          fieldBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public Builder clearField() {
        if (fieldBuilder_ == null) {
          field_ = null;
          onChanged();
        } else {
          field_ = null;
          fieldBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder getFieldBuilder() {

        onChanged();
        return getFieldFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder
          getFieldOrBuilder() {
        if (fieldBuilder_ != null) {
          return fieldBuilder_.getMessageOrBuilder();
        } else {
          return field_ == null
              ? com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance()
              : field_;
        }
      }
      /**
       *
       *
       * <pre>
       * The field to order by.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.FieldReference field = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldReference,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          getFieldFieldBuilder() {
        if (fieldBuilder_ == null) {
          fieldBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1beta1.StructuredQuery.FieldReference,
                  com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
                  com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>(
                  getField(), getParentForChildren(), isClean());
          field_ = null;
        }
        return fieldBuilder_;
      }

      private int direction_ = 0;
      /**
       *
       *
       * <pre>
       * The direction to order by. Defaults to `ASCENDING`.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
       *
       * @return The enum numeric value on the wire for direction.
       */
      public int getDirectionValue() {
        return direction_;
      }
      /**
       *
       *
       * <pre>
       * The direction to order by. Defaults to `ASCENDING`.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
       *
       * @param value The enum numeric value on the wire for direction to set.
       * @return This builder for chaining.
       */
      public Builder setDirectionValue(int value) {
        direction_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The direction to order by. Defaults to `ASCENDING`.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
       *
       * @return The direction.
       */
      public com.google.firestore.v1beta1.StructuredQuery.Direction getDirection() {
        @SuppressWarnings("deprecation")
        com.google.firestore.v1beta1.StructuredQuery.Direction result =
            com.google.firestore.v1beta1.StructuredQuery.Direction.valueOf(direction_);
        return result == null
            ? com.google.firestore.v1beta1.StructuredQuery.Direction.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The direction to order by. Defaults to `ASCENDING`.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
       *
       * @param value The direction to set.
       * @return This builder for chaining.
       */
      public Builder setDirection(com.google.firestore.v1beta1.StructuredQuery.Direction value) {
        if (value == null) {
          throw new NullPointerException();
        }

        direction_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The direction to order by. Defaults to `ASCENDING`.
       * </pre>
       *
       * <code>.google.firestore.v1beta1.StructuredQuery.Direction direction = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDirection() {

        direction_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery.Order)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery.Order)
    private static final com.google.firestore.v1beta1.StructuredQuery.Order DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery.Order();
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Order getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Order> PARSER =
        new com.google.protobuf.AbstractParser<Order>() {
          @java.lang.Override
          public Order parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Order(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Order> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Order> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery.Order getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FieldReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1beta1.StructuredQuery.FieldReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>string field_path = 2;</code>
     *
     * @return The fieldPath.
     */
    java.lang.String getFieldPath();
    /**
     * <code>string field_path = 2;</code>
     *
     * @return The bytes for fieldPath.
     */
    com.google.protobuf.ByteString getFieldPathBytes();
  }
  /**
   *
   *
   * <pre>
   * A reference to a field, such as `max(messages.time) as max_time`.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.FieldReference}
   */
  public static final class FieldReference extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery.FieldReference)
      FieldReferenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FieldReference.newBuilder() to construct.
    private FieldReference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FieldReference() {
      fieldPath_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FieldReference();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private FieldReference(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                fieldPath_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_FieldReference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_FieldReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.class,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder.class);
    }

    public static final int FIELD_PATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object fieldPath_;
    /**
     * <code>string field_path = 2;</code>
     *
     * @return The fieldPath.
     */
    public java.lang.String getFieldPath() {
      java.lang.Object ref = fieldPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldPath_ = s;
        return s;
      }
    }
    /**
     * <code>string field_path = 2;</code>
     *
     * @return The bytes for fieldPath.
     */
    public com.google.protobuf.ByteString getFieldPathBytes() {
      java.lang.Object ref = fieldPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getFieldPathBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fieldPath_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getFieldPathBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fieldPath_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery.FieldReference)) {
        return super.equals(obj);
      }
      com.google.firestore.v1beta1.StructuredQuery.FieldReference other =
          (com.google.firestore.v1beta1.StructuredQuery.FieldReference) obj;

      if (!getFieldPath().equals(other.getFieldPath())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FIELD_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getFieldPath().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1beta1.StructuredQuery.FieldReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A reference to a field, such as `max(messages.time) as max_time`.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.FieldReference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery.FieldReference)
        com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_FieldReference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_FieldReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.class,
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder.class);
      }

      // Construct using com.google.firestore.v1beta1.StructuredQuery.FieldReference.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        fieldPath_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_FieldReference_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference
          getDefaultInstanceForType() {
        return com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference build() {
        com.google.firestore.v1beta1.StructuredQuery.FieldReference result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference buildPartial() {
        com.google.firestore.v1beta1.StructuredQuery.FieldReference result =
            new com.google.firestore.v1beta1.StructuredQuery.FieldReference(this);
        result.fieldPath_ = fieldPath_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1beta1.StructuredQuery.FieldReference) {
          return mergeFrom((com.google.firestore.v1beta1.StructuredQuery.FieldReference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1beta1.StructuredQuery.FieldReference other) {
        if (other
            == com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance())
          return this;
        if (!other.getFieldPath().isEmpty()) {
          fieldPath_ = other.fieldPath_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1beta1.StructuredQuery.FieldReference parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.v1beta1.StructuredQuery.FieldReference)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object fieldPath_ = "";
      /**
       * <code>string field_path = 2;</code>
       *
       * @return The fieldPath.
       */
      public java.lang.String getFieldPath() {
        java.lang.Object ref = fieldPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string field_path = 2;</code>
       *
       * @return The bytes for fieldPath.
       */
      public com.google.protobuf.ByteString getFieldPathBytes() {
        java.lang.Object ref = fieldPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string field_path = 2;</code>
       *
       * @param value The fieldPath to set.
       * @return This builder for chaining.
       */
      public Builder setFieldPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        fieldPath_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string field_path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFieldPath() {

        fieldPath_ = getDefaultInstance().getFieldPath();
        onChanged();
        return this;
      }
      /**
       * <code>string field_path = 2;</code>
       *
       * @param value The bytes for fieldPath to set.
       * @return This builder for chaining.
       */
      public Builder setFieldPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        fieldPath_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery.FieldReference)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery.FieldReference)
    private static final com.google.firestore.v1beta1.StructuredQuery.FieldReference
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery.FieldReference();
    }

    public static com.google.firestore.v1beta1.StructuredQuery.FieldReference getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FieldReference> PARSER =
        new com.google.protobuf.AbstractParser<FieldReference>() {
          @java.lang.Override
          public FieldReference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new FieldReference(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<FieldReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FieldReference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery.FieldReference getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ProjectionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1beta1.StructuredQuery.Projection)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    java.util.List<com.google.firestore.v1beta1.StructuredQuery.FieldReference> getFieldsList();
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldReference getFields(int index);
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    int getFieldsCount();
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    java.util.List<? extends com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
        getFieldsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder getFieldsOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * The projection of document's fields to return.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.Projection}
   */
  public static final class Projection extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.StructuredQuery.Projection)
      ProjectionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Projection.newBuilder() to construct.
    private Projection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Projection() {
      fields_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Projection();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Projection(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  fields_ =
                      new java.util.ArrayList<
                          com.google.firestore.v1beta1.StructuredQuery.FieldReference>();
                  mutable_bitField0_ |= 0x00000001;
                }
                fields_.add(
                    input.readMessage(
                        com.google.firestore.v1beta1.StructuredQuery.FieldReference.parser(),
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_Projection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_Projection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.Projection.class,
              com.google.firestore.v1beta1.StructuredQuery.Projection.Builder.class);
    }

    public static final int FIELDS_FIELD_NUMBER = 2;
    private java.util.List<com.google.firestore.v1beta1.StructuredQuery.FieldReference> fields_;
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    public java.util.List<com.google.firestore.v1beta1.StructuredQuery.FieldReference>
        getFieldsList() {
      return fields_;
    }
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    public java.util.List<
            ? extends com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
        getFieldsOrBuilderList() {
      return fields_;
    }
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    public int getFieldsCount() {
      return fields_.size();
    }
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldReference getFields(int index) {
      return fields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The fields to return.
     * If empty, all fields are returned. To only return the name
     * of the document, use `['__name__']`.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder getFieldsOrBuilder(
        int index) {
      return fields_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < fields_.size(); i++) {
        output.writeMessage(2, fields_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fields_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, fields_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery.Projection)) {
        return super.equals(obj);
      }
      com.google.firestore.v1beta1.StructuredQuery.Projection other =
          (com.google.firestore.v1beta1.StructuredQuery.Projection) obj;

      if (!getFieldsList().equals(other.getFieldsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFieldsCount() > 0) {
        hash = (37 * hash) + FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getFieldsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1beta1.StructuredQuery.Projection prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The projection of document's fields to return.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1beta1.StructuredQuery.Projection}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery.Projection)
        com.google.firestore.v1beta1.StructuredQuery.ProjectionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Projection_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Projection_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1beta1.StructuredQuery.Projection.class,
                com.google.firestore.v1beta1.StructuredQuery.Projection.Builder.class);
      }

      // Construct using com.google.firestore.v1beta1.StructuredQuery.Projection.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFieldsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (fieldsBuilder_ == null) {
          fields_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          fieldsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1beta1.QueryProto
            .internal_static_google_firestore_v1beta1_StructuredQuery_Projection_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Projection getDefaultInstanceForType() {
        return com.google.firestore.v1beta1.StructuredQuery.Projection.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Projection build() {
        com.google.firestore.v1beta1.StructuredQuery.Projection result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1beta1.StructuredQuery.Projection buildPartial() {
        com.google.firestore.v1beta1.StructuredQuery.Projection result =
            new com.google.firestore.v1beta1.StructuredQuery.Projection(this);
        int from_bitField0_ = bitField0_;
        if (fieldsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            fields_ = java.util.Collections.unmodifiableList(fields_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fields_ = fields_;
        } else {
          result.fields_ = fieldsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1beta1.StructuredQuery.Projection) {
          return mergeFrom((com.google.firestore.v1beta1.StructuredQuery.Projection) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1beta1.StructuredQuery.Projection other) {
        if (other == com.google.firestore.v1beta1.StructuredQuery.Projection.getDefaultInstance())
          return this;
        if (fieldsBuilder_ == null) {
          if (!other.fields_.isEmpty()) {
            if (fields_.isEmpty()) {
              fields_ = other.fields_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFieldsIsMutable();
              fields_.addAll(other.fields_);
            }
            onChanged();
          }
        } else {
          if (!other.fields_.isEmpty()) {
            if (fieldsBuilder_.isEmpty()) {
              fieldsBuilder_.dispose();
              fieldsBuilder_ = null;
              fields_ = other.fields_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fieldsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFieldsFieldBuilder()
                      : null;
            } else {
              fieldsBuilder_.addAllMessages(other.fields_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1beta1.StructuredQuery.Projection parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.v1beta1.StructuredQuery.Projection) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.firestore.v1beta1.StructuredQuery.FieldReference> fields_ =
          java.util.Collections.emptyList();

      private void ensureFieldsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          fields_ =
              new java.util.ArrayList<com.google.firestore.v1beta1.StructuredQuery.FieldReference>(
                  fields_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldReference,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          fieldsBuilder_;

      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public java.util.List<com.google.firestore.v1beta1.StructuredQuery.FieldReference>
          getFieldsList() {
        if (fieldsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fields_);
        } else {
          return fieldsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public int getFieldsCount() {
        if (fieldsBuilder_ == null) {
          return fields_.size();
        } else {
          return fieldsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference getFields(int index) {
        if (fieldsBuilder_ == null) {
          return fields_.get(index);
        } else {
          return fieldsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder setFields(
          int index, com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.set(index, value);
          onChanged();
        } else {
          fieldsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder setFields(
          int index,
          com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.set(index, builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder addFields(com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.add(value);
          onChanged();
        } else {
          fieldsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder addFields(
          int index, com.google.firestore.v1beta1.StructuredQuery.FieldReference value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.add(index, value);
          onChanged();
        } else {
          fieldsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder addFields(
          com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.add(builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder addFields(
          int index,
          com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.add(index, builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder addAllFields(
          java.lang.Iterable<? extends com.google.firestore.v1beta1.StructuredQuery.FieldReference>
              values) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
          onChanged();
        } else {
          fieldsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder clearFields() {
        if (fieldsBuilder_ == null) {
          fields_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fieldsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public Builder removeFields(int index) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.remove(index);
          onChanged();
        } else {
          fieldsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder getFieldsBuilder(
          int index) {
        return getFieldsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder
          getFieldsOrBuilder(int index) {
        if (fieldsBuilder_ == null) {
          return fields_.get(index);
        } else {
          return fieldsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public java.util.List<
              ? extends com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          getFieldsOrBuilderList() {
        if (fieldsBuilder_ != null) {
          return fieldsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fields_);
        }
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder
          addFieldsBuilder() {
        return getFieldsFieldBuilder()
            .addBuilder(
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder addFieldsBuilder(
          int index) {
        return getFieldsFieldBuilder()
            .addBuilder(
                index,
                com.google.firestore.v1beta1.StructuredQuery.FieldReference.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The fields to return.
       * If empty, all fields are returned. To only return the name
       * of the document, use `['__name__']`.
       * </pre>
       *
       * <code>repeated .google.firestore.v1beta1.StructuredQuery.FieldReference fields = 2;</code>
       */
      public java.util.List<com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder>
          getFieldsBuilderList() {
        return getFieldsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.firestore.v1beta1.StructuredQuery.FieldReference,
              com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
              com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>
          getFieldsFieldBuilder() {
        if (fieldsBuilder_ == null) {
          fieldsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.firestore.v1beta1.StructuredQuery.FieldReference,
                  com.google.firestore.v1beta1.StructuredQuery.FieldReference.Builder,
                  com.google.firestore.v1beta1.StructuredQuery.FieldReferenceOrBuilder>(
                  fields_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          fields_ = null;
        }
        return fieldsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery.Projection)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery.Projection)
    private static final com.google.firestore.v1beta1.StructuredQuery.Projection DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery.Projection();
    }

    public static com.google.firestore.v1beta1.StructuredQuery.Projection getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Projection> PARSER =
        new com.google.protobuf.AbstractParser<Projection>() {
          @java.lang.Override
          public Projection parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Projection(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Projection> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Projection> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery.Projection getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SELECT_FIELD_NUMBER = 1;
  private com.google.firestore.v1beta1.StructuredQuery.Projection select_;
  /**
   *
   *
   * <pre>
   * The projection to return.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
   *
   * @return Whether the select field is set.
   */
  public boolean hasSelect() {
    return select_ != null;
  }
  /**
   *
   *
   * <pre>
   * The projection to return.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
   *
   * @return The select.
   */
  public com.google.firestore.v1beta1.StructuredQuery.Projection getSelect() {
    return select_ == null
        ? com.google.firestore.v1beta1.StructuredQuery.Projection.getDefaultInstance()
        : select_;
  }
  /**
   *
   *
   * <pre>
   * The projection to return.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
   */
  public com.google.firestore.v1beta1.StructuredQuery.ProjectionOrBuilder getSelectOrBuilder() {
    return getSelect();
  }

  public static final int FROM_FIELD_NUMBER = 2;
  private java.util.List<com.google.firestore.v1beta1.StructuredQuery.CollectionSelector> from_;
  /**
   *
   *
   * <pre>
   * The collections to query.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
   */
  public java.util.List<com.google.firestore.v1beta1.StructuredQuery.CollectionSelector>
      getFromList() {
    return from_;
  }
  /**
   *
   *
   * <pre>
   * The collections to query.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
   */
  public java.util.List<
          ? extends com.google.firestore.v1beta1.StructuredQuery.CollectionSelectorOrBuilder>
      getFromOrBuilderList() {
    return from_;
  }
  /**
   *
   *
   * <pre>
   * The collections to query.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
   */
  public int getFromCount() {
    return from_.size();
  }
  /**
   *
   *
   * <pre>
   * The collections to query.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
   */
  public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector getFrom(int index) {
    return from_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The collections to query.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
   */
  public com.google.firestore.v1beta1.StructuredQuery.CollectionSelectorOrBuilder getFromOrBuilder(
      int index) {
    return from_.get(index);
  }

  public static final int WHERE_FIELD_NUMBER = 3;
  private com.google.firestore.v1beta1.StructuredQuery.Filter where_;
  /**
   *
   *
   * <pre>
   * The filter to apply.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
   *
   * @return Whether the where field is set.
   */
  public boolean hasWhere() {
    return where_ != null;
  }
  /**
   *
   *
   * <pre>
   * The filter to apply.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
   *
   * @return The where.
   */
  public com.google.firestore.v1beta1.StructuredQuery.Filter getWhere() {
    return where_ == null
        ? com.google.firestore.v1beta1.StructuredQuery.Filter.getDefaultInstance()
        : where_;
  }
  /**
   *
   *
   * <pre>
   * The filter to apply.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
   */
  public com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder getWhereOrBuilder() {
    return getWhere();
  }

  public static final int ORDER_BY_FIELD_NUMBER = 4;
  private java.util.List<com.google.firestore.v1beta1.StructuredQuery.Order> orderBy_;
  /**
   *
   *
   * <pre>
   * The order to apply to the query results.
   * Firestore guarantees a stable ordering through the following rules:
   *  * Any field required to appear in `order_by`, that is not already
   *    specified in `order_by`, is appended to the order in field name order
   *    by default.
   *  * If an order on `__name__` is not specified, it is appended by default.
   * Fields are appended with the same sort direction as the last order
   * specified, or 'ASCENDING' if no order was specified. For example:
   *  * `SELECT * FROM Foo ORDER BY A` becomes
   *    `SELECT * FROM Foo ORDER BY A, __name__`
   *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
   *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
   *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
   *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
   */
  public java.util.List<com.google.firestore.v1beta1.StructuredQuery.Order> getOrderByList() {
    return orderBy_;
  }
  /**
   *
   *
   * <pre>
   * The order to apply to the query results.
   * Firestore guarantees a stable ordering through the following rules:
   *  * Any field required to appear in `order_by`, that is not already
   *    specified in `order_by`, is appended to the order in field name order
   *    by default.
   *  * If an order on `__name__` is not specified, it is appended by default.
   * Fields are appended with the same sort direction as the last order
   * specified, or 'ASCENDING' if no order was specified. For example:
   *  * `SELECT * FROM Foo ORDER BY A` becomes
   *    `SELECT * FROM Foo ORDER BY A, __name__`
   *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
   *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
   *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
   *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
   */
  public java.util.List<? extends com.google.firestore.v1beta1.StructuredQuery.OrderOrBuilder>
      getOrderByOrBuilderList() {
    return orderBy_;
  }
  /**
   *
   *
   * <pre>
   * The order to apply to the query results.
   * Firestore guarantees a stable ordering through the following rules:
   *  * Any field required to appear in `order_by`, that is not already
   *    specified in `order_by`, is appended to the order in field name order
   *    by default.
   *  * If an order on `__name__` is not specified, it is appended by default.
   * Fields are appended with the same sort direction as the last order
   * specified, or 'ASCENDING' if no order was specified. For example:
   *  * `SELECT * FROM Foo ORDER BY A` becomes
   *    `SELECT * FROM Foo ORDER BY A, __name__`
   *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
   *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
   *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
   *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
   */
  public int getOrderByCount() {
    return orderBy_.size();
  }
  /**
   *
   *
   * <pre>
   * The order to apply to the query results.
   * Firestore guarantees a stable ordering through the following rules:
   *  * Any field required to appear in `order_by`, that is not already
   *    specified in `order_by`, is appended to the order in field name order
   *    by default.
   *  * If an order on `__name__` is not specified, it is appended by default.
   * Fields are appended with the same sort direction as the last order
   * specified, or 'ASCENDING' if no order was specified. For example:
   *  * `SELECT * FROM Foo ORDER BY A` becomes
   *    `SELECT * FROM Foo ORDER BY A, __name__`
   *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
   *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
   *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
   *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
   */
  public com.google.firestore.v1beta1.StructuredQuery.Order getOrderBy(int index) {
    return orderBy_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The order to apply to the query results.
   * Firestore guarantees a stable ordering through the following rules:
   *  * Any field required to appear in `order_by`, that is not already
   *    specified in `order_by`, is appended to the order in field name order
   *    by default.
   *  * If an order on `__name__` is not specified, it is appended by default.
   * Fields are appended with the same sort direction as the last order
   * specified, or 'ASCENDING' if no order was specified. For example:
   *  * `SELECT * FROM Foo ORDER BY A` becomes
   *    `SELECT * FROM Foo ORDER BY A, __name__`
   *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
   *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
   *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
   *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
   */
  public com.google.firestore.v1beta1.StructuredQuery.OrderOrBuilder getOrderByOrBuilder(
      int index) {
    return orderBy_.get(index);
  }

  public static final int START_AT_FIELD_NUMBER = 7;
  private com.google.firestore.v1beta1.Cursor startAt_;
  /**
   *
   *
   * <pre>
   * A starting point for the query results.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
   *
   * @return Whether the startAt field is set.
   */
  public boolean hasStartAt() {
    return startAt_ != null;
  }
  /**
   *
   *
   * <pre>
   * A starting point for the query results.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
   *
   * @return The startAt.
   */
  public com.google.firestore.v1beta1.Cursor getStartAt() {
    return startAt_ == null ? com.google.firestore.v1beta1.Cursor.getDefaultInstance() : startAt_;
  }
  /**
   *
   *
   * <pre>
   * A starting point for the query results.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
   */
  public com.google.firestore.v1beta1.CursorOrBuilder getStartAtOrBuilder() {
    return getStartAt();
  }

  public static final int END_AT_FIELD_NUMBER = 8;
  private com.google.firestore.v1beta1.Cursor endAt_;
  /**
   *
   *
   * <pre>
   * A end point for the query results.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
   *
   * @return Whether the endAt field is set.
   */
  public boolean hasEndAt() {
    return endAt_ != null;
  }
  /**
   *
   *
   * <pre>
   * A end point for the query results.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
   *
   * @return The endAt.
   */
  public com.google.firestore.v1beta1.Cursor getEndAt() {
    return endAt_ == null ? com.google.firestore.v1beta1.Cursor.getDefaultInstance() : endAt_;
  }
  /**
   *
   *
   * <pre>
   * A end point for the query results.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
   */
  public com.google.firestore.v1beta1.CursorOrBuilder getEndAtOrBuilder() {
    return getEndAt();
  }

  public static final int OFFSET_FIELD_NUMBER = 6;
  private int offset_;
  /**
   *
   *
   * <pre>
   * The number of results to skip.
   * Applies before limit, but after all other constraints. Must be &gt;= 0 if
   * specified.
   * </pre>
   *
   * <code>int32 offset = 6;</code>
   *
   * @return The offset.
   */
  public int getOffset() {
    return offset_;
  }

  public static final int LIMIT_FIELD_NUMBER = 5;
  private com.google.protobuf.Int32Value limit_;
  /**
   *
   *
   * <pre>
   * The maximum number of results to return.
   * Applies after all other constraints.
   * Must be &gt;= 0 if specified.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 5;</code>
   *
   * @return Whether the limit field is set.
   */
  public boolean hasLimit() {
    return limit_ != null;
  }
  /**
   *
   *
   * <pre>
   * The maximum number of results to return.
   * Applies after all other constraints.
   * Must be &gt;= 0 if specified.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 5;</code>
   *
   * @return The limit.
   */
  public com.google.protobuf.Int32Value getLimit() {
    return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
  }
  /**
   *
   *
   * <pre>
   * The maximum number of results to return.
   * Applies after all other constraints.
   * Must be &gt;= 0 if specified.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 5;</code>
   */
  public com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder() {
    return getLimit();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (select_ != null) {
      output.writeMessage(1, getSelect());
    }
    for (int i = 0; i < from_.size(); i++) {
      output.writeMessage(2, from_.get(i));
    }
    if (where_ != null) {
      output.writeMessage(3, getWhere());
    }
    for (int i = 0; i < orderBy_.size(); i++) {
      output.writeMessage(4, orderBy_.get(i));
    }
    if (limit_ != null) {
      output.writeMessage(5, getLimit());
    }
    if (offset_ != 0) {
      output.writeInt32(6, offset_);
    }
    if (startAt_ != null) {
      output.writeMessage(7, getStartAt());
    }
    if (endAt_ != null) {
      output.writeMessage(8, getEndAt());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (select_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSelect());
    }
    for (int i = 0; i < from_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, from_.get(i));
    }
    if (where_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getWhere());
    }
    for (int i = 0; i < orderBy_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, orderBy_.get(i));
    }
    if (limit_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getLimit());
    }
    if (offset_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, offset_);
    }
    if (startAt_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartAt());
    }
    if (endAt_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndAt());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1beta1.StructuredQuery)) {
      return super.equals(obj);
    }
    com.google.firestore.v1beta1.StructuredQuery other =
        (com.google.firestore.v1beta1.StructuredQuery) obj;

    if (hasSelect() != other.hasSelect()) return false;
    if (hasSelect()) {
      if (!getSelect().equals(other.getSelect())) return false;
    }
    if (!getFromList().equals(other.getFromList())) return false;
    if (hasWhere() != other.hasWhere()) return false;
    if (hasWhere()) {
      if (!getWhere().equals(other.getWhere())) return false;
    }
    if (!getOrderByList().equals(other.getOrderByList())) return false;
    if (hasStartAt() != other.hasStartAt()) return false;
    if (hasStartAt()) {
      if (!getStartAt().equals(other.getStartAt())) return false;
    }
    if (hasEndAt() != other.hasEndAt()) return false;
    if (hasEndAt()) {
      if (!getEndAt().equals(other.getEndAt())) return false;
    }
    if (getOffset() != other.getOffset()) return false;
    if (hasLimit() != other.hasLimit()) return false;
    if (hasLimit()) {
      if (!getLimit().equals(other.getLimit())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSelect()) {
      hash = (37 * hash) + SELECT_FIELD_NUMBER;
      hash = (53 * hash) + getSelect().hashCode();
    }
    if (getFromCount() > 0) {
      hash = (37 * hash) + FROM_FIELD_NUMBER;
      hash = (53 * hash) + getFromList().hashCode();
    }
    if (hasWhere()) {
      hash = (37 * hash) + WHERE_FIELD_NUMBER;
      hash = (53 * hash) + getWhere().hashCode();
    }
    if (getOrderByCount() > 0) {
      hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
      hash = (53 * hash) + getOrderByList().hashCode();
    }
    if (hasStartAt()) {
      hash = (37 * hash) + START_AT_FIELD_NUMBER;
      hash = (53 * hash) + getStartAt().hashCode();
    }
    if (hasEndAt()) {
      hash = (37 * hash) + END_AT_FIELD_NUMBER;
      hash = (53 * hash) + getEndAt().hashCode();
    }
    hash = (37 * hash) + OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + getOffset();
    if (hasLimit()) {
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getLimit().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.StructuredQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1beta1.StructuredQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Firestore query.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.StructuredQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.StructuredQuery)
      com.google.firestore.v1beta1.StructuredQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.StructuredQuery.class,
              com.google.firestore.v1beta1.StructuredQuery.Builder.class);
    }

    // Construct using com.google.firestore.v1beta1.StructuredQuery.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFromFieldBuilder();
        getOrderByFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (selectBuilder_ == null) {
        select_ = null;
      } else {
        select_ = null;
        selectBuilder_ = null;
      }
      if (fromBuilder_ == null) {
        from_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        fromBuilder_.clear();
      }
      if (whereBuilder_ == null) {
        where_ = null;
      } else {
        where_ = null;
        whereBuilder_ = null;
      }
      if (orderByBuilder_ == null) {
        orderBy_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        orderByBuilder_.clear();
      }
      if (startAtBuilder_ == null) {
        startAt_ = null;
      } else {
        startAt_ = null;
        startAtBuilder_ = null;
      }
      if (endAtBuilder_ == null) {
        endAt_ = null;
      } else {
        endAt_ = null;
        endAtBuilder_ = null;
      }
      offset_ = 0;

      if (limitBuilder_ == null) {
        limit_ = null;
      } else {
        limit_ = null;
        limitBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1beta1.QueryProto
          .internal_static_google_firestore_v1beta1_StructuredQuery_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery getDefaultInstanceForType() {
      return com.google.firestore.v1beta1.StructuredQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery build() {
      com.google.firestore.v1beta1.StructuredQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.StructuredQuery buildPartial() {
      com.google.firestore.v1beta1.StructuredQuery result =
          new com.google.firestore.v1beta1.StructuredQuery(this);
      int from_bitField0_ = bitField0_;
      if (selectBuilder_ == null) {
        result.select_ = select_;
      } else {
        result.select_ = selectBuilder_.build();
      }
      if (fromBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          from_ = java.util.Collections.unmodifiableList(from_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.from_ = from_;
      } else {
        result.from_ = fromBuilder_.build();
      }
      if (whereBuilder_ == null) {
        result.where_ = where_;
      } else {
        result.where_ = whereBuilder_.build();
      }
      if (orderByBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          orderBy_ = java.util.Collections.unmodifiableList(orderBy_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.orderBy_ = orderBy_;
      } else {
        result.orderBy_ = orderByBuilder_.build();
      }
      if (startAtBuilder_ == null) {
        result.startAt_ = startAt_;
      } else {
        result.startAt_ = startAtBuilder_.build();
      }
      if (endAtBuilder_ == null) {
        result.endAt_ = endAt_;
      } else {
        result.endAt_ = endAtBuilder_.build();
      }
      result.offset_ = offset_;
      if (limitBuilder_ == null) {
        result.limit_ = limit_;
      } else {
        result.limit_ = limitBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1beta1.StructuredQuery) {
        return mergeFrom((com.google.firestore.v1beta1.StructuredQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1beta1.StructuredQuery other) {
      if (other == com.google.firestore.v1beta1.StructuredQuery.getDefaultInstance()) return this;
      if (other.hasSelect()) {
        mergeSelect(other.getSelect());
      }
      if (fromBuilder_ == null) {
        if (!other.from_.isEmpty()) {
          if (from_.isEmpty()) {
            from_ = other.from_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFromIsMutable();
            from_.addAll(other.from_);
          }
          onChanged();
        }
      } else {
        if (!other.from_.isEmpty()) {
          if (fromBuilder_.isEmpty()) {
            fromBuilder_.dispose();
            fromBuilder_ = null;
            from_ = other.from_;
            bitField0_ = (bitField0_ & ~0x00000001);
            fromBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFromFieldBuilder()
                    : null;
          } else {
            fromBuilder_.addAllMessages(other.from_);
          }
        }
      }
      if (other.hasWhere()) {
        mergeWhere(other.getWhere());
      }
      if (orderByBuilder_ == null) {
        if (!other.orderBy_.isEmpty()) {
          if (orderBy_.isEmpty()) {
            orderBy_ = other.orderBy_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureOrderByIsMutable();
            orderBy_.addAll(other.orderBy_);
          }
          onChanged();
        }
      } else {
        if (!other.orderBy_.isEmpty()) {
          if (orderByBuilder_.isEmpty()) {
            orderByBuilder_.dispose();
            orderByBuilder_ = null;
            orderBy_ = other.orderBy_;
            bitField0_ = (bitField0_ & ~0x00000002);
            orderByBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOrderByFieldBuilder()
                    : null;
          } else {
            orderByBuilder_.addAllMessages(other.orderBy_);
          }
        }
      }
      if (other.hasStartAt()) {
        mergeStartAt(other.getStartAt());
      }
      if (other.hasEndAt()) {
        mergeEndAt(other.getEndAt());
      }
      if (other.getOffset() != 0) {
        setOffset(other.getOffset());
      }
      if (other.hasLimit()) {
        mergeLimit(other.getLimit());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.v1beta1.StructuredQuery parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.v1beta1.StructuredQuery) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.firestore.v1beta1.StructuredQuery.Projection select_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.StructuredQuery.Projection,
            com.google.firestore.v1beta1.StructuredQuery.Projection.Builder,
            com.google.firestore.v1beta1.StructuredQuery.ProjectionOrBuilder>
        selectBuilder_;
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     *
     * @return Whether the select field is set.
     */
    public boolean hasSelect() {
      return selectBuilder_ != null || select_ != null;
    }
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     *
     * @return The select.
     */
    public com.google.firestore.v1beta1.StructuredQuery.Projection getSelect() {
      if (selectBuilder_ == null) {
        return select_ == null
            ? com.google.firestore.v1beta1.StructuredQuery.Projection.getDefaultInstance()
            : select_;
      } else {
        return selectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     */
    public Builder setSelect(com.google.firestore.v1beta1.StructuredQuery.Projection value) {
      if (selectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        select_ = value;
        onChanged();
      } else {
        selectBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     */
    public Builder setSelect(
        com.google.firestore.v1beta1.StructuredQuery.Projection.Builder builderForValue) {
      if (selectBuilder_ == null) {
        select_ = builderForValue.build();
        onChanged();
      } else {
        selectBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     */
    public Builder mergeSelect(com.google.firestore.v1beta1.StructuredQuery.Projection value) {
      if (selectBuilder_ == null) {
        if (select_ != null) {
          select_ =
              com.google.firestore.v1beta1.StructuredQuery.Projection.newBuilder(select_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          select_ = value;
        }
        onChanged();
      } else {
        selectBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     */
    public Builder clearSelect() {
      if (selectBuilder_ == null) {
        select_ = null;
        onChanged();
      } else {
        select_ = null;
        selectBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.Projection.Builder getSelectBuilder() {

      onChanged();
      return getSelectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.ProjectionOrBuilder getSelectOrBuilder() {
      if (selectBuilder_ != null) {
        return selectBuilder_.getMessageOrBuilder();
      } else {
        return select_ == null
            ? com.google.firestore.v1beta1.StructuredQuery.Projection.getDefaultInstance()
            : select_;
      }
    }
    /**
     *
     *
     * <pre>
     * The projection to return.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Projection select = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.StructuredQuery.Projection,
            com.google.firestore.v1beta1.StructuredQuery.Projection.Builder,
            com.google.firestore.v1beta1.StructuredQuery.ProjectionOrBuilder>
        getSelectFieldBuilder() {
      if (selectBuilder_ == null) {
        selectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1beta1.StructuredQuery.Projection,
                com.google.firestore.v1beta1.StructuredQuery.Projection.Builder,
                com.google.firestore.v1beta1.StructuredQuery.ProjectionOrBuilder>(
                getSelect(), getParentForChildren(), isClean());
        select_ = null;
      }
      return selectBuilder_;
    }

    private java.util.List<com.google.firestore.v1beta1.StructuredQuery.CollectionSelector> from_ =
        java.util.Collections.emptyList();

    private void ensureFromIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        from_ =
            new java.util.ArrayList<
                com.google.firestore.v1beta1.StructuredQuery.CollectionSelector>(from_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1beta1.StructuredQuery.CollectionSelector,
            com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder,
            com.google.firestore.v1beta1.StructuredQuery.CollectionSelectorOrBuilder>
        fromBuilder_;

    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public java.util.List<com.google.firestore.v1beta1.StructuredQuery.CollectionSelector>
        getFromList() {
      if (fromBuilder_ == null) {
        return java.util.Collections.unmodifiableList(from_);
      } else {
        return fromBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public int getFromCount() {
      if (fromBuilder_ == null) {
        return from_.size();
      } else {
        return fromBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector getFrom(int index) {
      if (fromBuilder_ == null) {
        return from_.get(index);
      } else {
        return fromBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder setFrom(
        int index, com.google.firestore.v1beta1.StructuredQuery.CollectionSelector value) {
      if (fromBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromIsMutable();
        from_.set(index, value);
        onChanged();
      } else {
        fromBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder setFrom(
        int index,
        com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder builderForValue) {
      if (fromBuilder_ == null) {
        ensureFromIsMutable();
        from_.set(index, builderForValue.build());
        onChanged();
      } else {
        fromBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder addFrom(com.google.firestore.v1beta1.StructuredQuery.CollectionSelector value) {
      if (fromBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromIsMutable();
        from_.add(value);
        onChanged();
      } else {
        fromBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder addFrom(
        int index, com.google.firestore.v1beta1.StructuredQuery.CollectionSelector value) {
      if (fromBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromIsMutable();
        from_.add(index, value);
        onChanged();
      } else {
        fromBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder addFrom(
        com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder builderForValue) {
      if (fromBuilder_ == null) {
        ensureFromIsMutable();
        from_.add(builderForValue.build());
        onChanged();
      } else {
        fromBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder addFrom(
        int index,
        com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder builderForValue) {
      if (fromBuilder_ == null) {
        ensureFromIsMutable();
        from_.add(index, builderForValue.build());
        onChanged();
      } else {
        fromBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder addAllFrom(
        java.lang.Iterable<
                ? extends com.google.firestore.v1beta1.StructuredQuery.CollectionSelector>
            values) {
      if (fromBuilder_ == null) {
        ensureFromIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, from_);
        onChanged();
      } else {
        fromBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder clearFrom() {
      if (fromBuilder_ == null) {
        from_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        fromBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public Builder removeFrom(int index) {
      if (fromBuilder_ == null) {
        ensureFromIsMutable();
        from_.remove(index);
        onChanged();
      } else {
        fromBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder getFromBuilder(
        int index) {
      return getFromFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.CollectionSelectorOrBuilder
        getFromOrBuilder(int index) {
      if (fromBuilder_ == null) {
        return from_.get(index);
      } else {
        return fromBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public java.util.List<
            ? extends com.google.firestore.v1beta1.StructuredQuery.CollectionSelectorOrBuilder>
        getFromOrBuilderList() {
      if (fromBuilder_ != null) {
        return fromBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(from_);
      }
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder
        addFromBuilder() {
      return getFromFieldBuilder()
          .addBuilder(
              com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder addFromBuilder(
        int index) {
      return getFromFieldBuilder()
          .addBuilder(
              index,
              com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collections to query.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.CollectionSelector from = 2;</code>
     */
    public java.util.List<com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder>
        getFromBuilderList() {
      return getFromFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1beta1.StructuredQuery.CollectionSelector,
            com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder,
            com.google.firestore.v1beta1.StructuredQuery.CollectionSelectorOrBuilder>
        getFromFieldBuilder() {
      if (fromBuilder_ == null) {
        fromBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.firestore.v1beta1.StructuredQuery.CollectionSelector,
                com.google.firestore.v1beta1.StructuredQuery.CollectionSelector.Builder,
                com.google.firestore.v1beta1.StructuredQuery.CollectionSelectorOrBuilder>(
                from_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        from_ = null;
      }
      return fromBuilder_;
    }

    private com.google.firestore.v1beta1.StructuredQuery.Filter where_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.StructuredQuery.Filter,
            com.google.firestore.v1beta1.StructuredQuery.Filter.Builder,
            com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>
        whereBuilder_;
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     *
     * @return Whether the where field is set.
     */
    public boolean hasWhere() {
      return whereBuilder_ != null || where_ != null;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     *
     * @return The where.
     */
    public com.google.firestore.v1beta1.StructuredQuery.Filter getWhere() {
      if (whereBuilder_ == null) {
        return where_ == null
            ? com.google.firestore.v1beta1.StructuredQuery.Filter.getDefaultInstance()
            : where_;
      } else {
        return whereBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     */
    public Builder setWhere(com.google.firestore.v1beta1.StructuredQuery.Filter value) {
      if (whereBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        where_ = value;
        onChanged();
      } else {
        whereBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     */
    public Builder setWhere(
        com.google.firestore.v1beta1.StructuredQuery.Filter.Builder builderForValue) {
      if (whereBuilder_ == null) {
        where_ = builderForValue.build();
        onChanged();
      } else {
        whereBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     */
    public Builder mergeWhere(com.google.firestore.v1beta1.StructuredQuery.Filter value) {
      if (whereBuilder_ == null) {
        if (where_ != null) {
          where_ =
              com.google.firestore.v1beta1.StructuredQuery.Filter.newBuilder(where_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          where_ = value;
        }
        onChanged();
      } else {
        whereBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     */
    public Builder clearWhere() {
      if (whereBuilder_ == null) {
        where_ = null;
        onChanged();
      } else {
        where_ = null;
        whereBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.Filter.Builder getWhereBuilder() {

      onChanged();
      return getWhereFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder getWhereOrBuilder() {
      if (whereBuilder_ != null) {
        return whereBuilder_.getMessageOrBuilder();
      } else {
        return where_ == null
            ? com.google.firestore.v1beta1.StructuredQuery.Filter.getDefaultInstance()
            : where_;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.StructuredQuery.Filter where = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.StructuredQuery.Filter,
            com.google.firestore.v1beta1.StructuredQuery.Filter.Builder,
            com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>
        getWhereFieldBuilder() {
      if (whereBuilder_ == null) {
        whereBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1beta1.StructuredQuery.Filter,
                com.google.firestore.v1beta1.StructuredQuery.Filter.Builder,
                com.google.firestore.v1beta1.StructuredQuery.FilterOrBuilder>(
                getWhere(), getParentForChildren(), isClean());
        where_ = null;
      }
      return whereBuilder_;
    }

    private java.util.List<com.google.firestore.v1beta1.StructuredQuery.Order> orderBy_ =
        java.util.Collections.emptyList();

    private void ensureOrderByIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        orderBy_ =
            new java.util.ArrayList<com.google.firestore.v1beta1.StructuredQuery.Order>(orderBy_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1beta1.StructuredQuery.Order,
            com.google.firestore.v1beta1.StructuredQuery.Order.Builder,
            com.google.firestore.v1beta1.StructuredQuery.OrderOrBuilder>
        orderByBuilder_;

    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public java.util.List<com.google.firestore.v1beta1.StructuredQuery.Order> getOrderByList() {
      if (orderByBuilder_ == null) {
        return java.util.Collections.unmodifiableList(orderBy_);
      } else {
        return orderByBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public int getOrderByCount() {
      if (orderByBuilder_ == null) {
        return orderBy_.size();
      } else {
        return orderByBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.Order getOrderBy(int index) {
      if (orderByBuilder_ == null) {
        return orderBy_.get(index);
      } else {
        return orderByBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder setOrderBy(int index, com.google.firestore.v1beta1.StructuredQuery.Order value) {
      if (orderByBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderByIsMutable();
        orderBy_.set(index, value);
        onChanged();
      } else {
        orderByBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder setOrderBy(
        int index, com.google.firestore.v1beta1.StructuredQuery.Order.Builder builderForValue) {
      if (orderByBuilder_ == null) {
        ensureOrderByIsMutable();
        orderBy_.set(index, builderForValue.build());
        onChanged();
      } else {
        orderByBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder addOrderBy(com.google.firestore.v1beta1.StructuredQuery.Order value) {
      if (orderByBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderByIsMutable();
        orderBy_.add(value);
        onChanged();
      } else {
        orderByBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder addOrderBy(int index, com.google.firestore.v1beta1.StructuredQuery.Order value) {
      if (orderByBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderByIsMutable();
        orderBy_.add(index, value);
        onChanged();
      } else {
        orderByBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder addOrderBy(
        com.google.firestore.v1beta1.StructuredQuery.Order.Builder builderForValue) {
      if (orderByBuilder_ == null) {
        ensureOrderByIsMutable();
        orderBy_.add(builderForValue.build());
        onChanged();
      } else {
        orderByBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder addOrderBy(
        int index, com.google.firestore.v1beta1.StructuredQuery.Order.Builder builderForValue) {
      if (orderByBuilder_ == null) {
        ensureOrderByIsMutable();
        orderBy_.add(index, builderForValue.build());
        onChanged();
      } else {
        orderByBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder addAllOrderBy(
        java.lang.Iterable<? extends com.google.firestore.v1beta1.StructuredQuery.Order> values) {
      if (orderByBuilder_ == null) {
        ensureOrderByIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, orderBy_);
        onChanged();
      } else {
        orderByBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder clearOrderBy() {
      if (orderByBuilder_ == null) {
        orderBy_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        orderByBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public Builder removeOrderBy(int index) {
      if (orderByBuilder_ == null) {
        ensureOrderByIsMutable();
        orderBy_.remove(index);
        onChanged();
      } else {
        orderByBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.Order.Builder getOrderByBuilder(int index) {
      return getOrderByFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.OrderOrBuilder getOrderByOrBuilder(
        int index) {
      if (orderByBuilder_ == null) {
        return orderBy_.get(index);
      } else {
        return orderByBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public java.util.List<? extends com.google.firestore.v1beta1.StructuredQuery.OrderOrBuilder>
        getOrderByOrBuilderList() {
      if (orderByBuilder_ != null) {
        return orderByBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(orderBy_);
      }
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.Order.Builder addOrderByBuilder() {
      return getOrderByFieldBuilder()
          .addBuilder(com.google.firestore.v1beta1.StructuredQuery.Order.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public com.google.firestore.v1beta1.StructuredQuery.Order.Builder addOrderByBuilder(int index) {
      return getOrderByFieldBuilder()
          .addBuilder(
              index, com.google.firestore.v1beta1.StructuredQuery.Order.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The order to apply to the query results.
     * Firestore guarantees a stable ordering through the following rules:
     *  * Any field required to appear in `order_by`, that is not already
     *    specified in `order_by`, is appended to the order in field name order
     *    by default.
     *  * If an order on `__name__` is not specified, it is appended by default.
     * Fields are appended with the same sort direction as the last order
     * specified, or 'ASCENDING' if no order was specified. For example:
     *  * `SELECT * FROM Foo ORDER BY A` becomes
     *    `SELECT * FROM Foo ORDER BY A, __name__`
     *  * `SELECT * FROM Foo ORDER BY A DESC` becomes
     *    `SELECT * FROM Foo ORDER BY A DESC, __name__ DESC`
     *  * `SELECT * FROM Foo WHERE A &gt; 1` becomes
     *    `SELECT * FROM Foo WHERE A &gt; 1 ORDER BY A, __name__`
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.StructuredQuery.Order order_by = 4;</code>
     */
    public java.util.List<com.google.firestore.v1beta1.StructuredQuery.Order.Builder>
        getOrderByBuilderList() {
      return getOrderByFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1beta1.StructuredQuery.Order,
            com.google.firestore.v1beta1.StructuredQuery.Order.Builder,
            com.google.firestore.v1beta1.StructuredQuery.OrderOrBuilder>
        getOrderByFieldBuilder() {
      if (orderByBuilder_ == null) {
        orderByBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.firestore.v1beta1.StructuredQuery.Order,
                com.google.firestore.v1beta1.StructuredQuery.Order.Builder,
                com.google.firestore.v1beta1.StructuredQuery.OrderOrBuilder>(
                orderBy_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        orderBy_ = null;
      }
      return orderByBuilder_;
    }

    private com.google.firestore.v1beta1.Cursor startAt_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.Cursor,
            com.google.firestore.v1beta1.Cursor.Builder,
            com.google.firestore.v1beta1.CursorOrBuilder>
        startAtBuilder_;
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     *
     * @return Whether the startAt field is set.
     */
    public boolean hasStartAt() {
      return startAtBuilder_ != null || startAt_ != null;
    }
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     *
     * @return The startAt.
     */
    public com.google.firestore.v1beta1.Cursor getStartAt() {
      if (startAtBuilder_ == null) {
        return startAt_ == null
            ? com.google.firestore.v1beta1.Cursor.getDefaultInstance()
            : startAt_;
      } else {
        return startAtBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     */
    public Builder setStartAt(com.google.firestore.v1beta1.Cursor value) {
      if (startAtBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startAt_ = value;
        onChanged();
      } else {
        startAtBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     */
    public Builder setStartAt(com.google.firestore.v1beta1.Cursor.Builder builderForValue) {
      if (startAtBuilder_ == null) {
        startAt_ = builderForValue.build();
        onChanged();
      } else {
        startAtBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     */
    public Builder mergeStartAt(com.google.firestore.v1beta1.Cursor value) {
      if (startAtBuilder_ == null) {
        if (startAt_ != null) {
          startAt_ =
              com.google.firestore.v1beta1.Cursor.newBuilder(startAt_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          startAt_ = value;
        }
        onChanged();
      } else {
        startAtBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     */
    public Builder clearStartAt() {
      if (startAtBuilder_ == null) {
        startAt_ = null;
        onChanged();
      } else {
        startAt_ = null;
        startAtBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     */
    public com.google.firestore.v1beta1.Cursor.Builder getStartAtBuilder() {

      onChanged();
      return getStartAtFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     */
    public com.google.firestore.v1beta1.CursorOrBuilder getStartAtOrBuilder() {
      if (startAtBuilder_ != null) {
        return startAtBuilder_.getMessageOrBuilder();
      } else {
        return startAt_ == null
            ? com.google.firestore.v1beta1.Cursor.getDefaultInstance()
            : startAt_;
      }
    }
    /**
     *
     *
     * <pre>
     * A starting point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor start_at = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.Cursor,
            com.google.firestore.v1beta1.Cursor.Builder,
            com.google.firestore.v1beta1.CursorOrBuilder>
        getStartAtFieldBuilder() {
      if (startAtBuilder_ == null) {
        startAtBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1beta1.Cursor,
                com.google.firestore.v1beta1.Cursor.Builder,
                com.google.firestore.v1beta1.CursorOrBuilder>(
                getStartAt(), getParentForChildren(), isClean());
        startAt_ = null;
      }
      return startAtBuilder_;
    }

    private com.google.firestore.v1beta1.Cursor endAt_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.Cursor,
            com.google.firestore.v1beta1.Cursor.Builder,
            com.google.firestore.v1beta1.CursorOrBuilder>
        endAtBuilder_;
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     *
     * @return Whether the endAt field is set.
     */
    public boolean hasEndAt() {
      return endAtBuilder_ != null || endAt_ != null;
    }
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     *
     * @return The endAt.
     */
    public com.google.firestore.v1beta1.Cursor getEndAt() {
      if (endAtBuilder_ == null) {
        return endAt_ == null ? com.google.firestore.v1beta1.Cursor.getDefaultInstance() : endAt_;
      } else {
        return endAtBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     */
    public Builder setEndAt(com.google.firestore.v1beta1.Cursor value) {
      if (endAtBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endAt_ = value;
        onChanged();
      } else {
        endAtBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     */
    public Builder setEndAt(com.google.firestore.v1beta1.Cursor.Builder builderForValue) {
      if (endAtBuilder_ == null) {
        endAt_ = builderForValue.build();
        onChanged();
      } else {
        endAtBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     */
    public Builder mergeEndAt(com.google.firestore.v1beta1.Cursor value) {
      if (endAtBuilder_ == null) {
        if (endAt_ != null) {
          endAt_ =
              com.google.firestore.v1beta1.Cursor.newBuilder(endAt_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          endAt_ = value;
        }
        onChanged();
      } else {
        endAtBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     */
    public Builder clearEndAt() {
      if (endAtBuilder_ == null) {
        endAt_ = null;
        onChanged();
      } else {
        endAt_ = null;
        endAtBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     */
    public com.google.firestore.v1beta1.Cursor.Builder getEndAtBuilder() {

      onChanged();
      return getEndAtFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     */
    public com.google.firestore.v1beta1.CursorOrBuilder getEndAtOrBuilder() {
      if (endAtBuilder_ != null) {
        return endAtBuilder_.getMessageOrBuilder();
      } else {
        return endAt_ == null ? com.google.firestore.v1beta1.Cursor.getDefaultInstance() : endAt_;
      }
    }
    /**
     *
     *
     * <pre>
     * A end point for the query results.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Cursor end_at = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.Cursor,
            com.google.firestore.v1beta1.Cursor.Builder,
            com.google.firestore.v1beta1.CursorOrBuilder>
        getEndAtFieldBuilder() {
      if (endAtBuilder_ == null) {
        endAtBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1beta1.Cursor,
                com.google.firestore.v1beta1.Cursor.Builder,
                com.google.firestore.v1beta1.CursorOrBuilder>(
                getEndAt(), getParentForChildren(), isClean());
        endAt_ = null;
      }
      return endAtBuilder_;
    }

    private int offset_;
    /**
     *
     *
     * <pre>
     * The number of results to skip.
     * Applies before limit, but after all other constraints. Must be &gt;= 0 if
     * specified.
     * </pre>
     *
     * <code>int32 offset = 6;</code>
     *
     * @return The offset.
     */
    public int getOffset() {
      return offset_;
    }
    /**
     *
     *
     * <pre>
     * The number of results to skip.
     * Applies before limit, but after all other constraints. Must be &gt;= 0 if
     * specified.
     * </pre>
     *
     * <code>int32 offset = 6;</code>
     *
     * @param value The offset to set.
     * @return This builder for chaining.
     */
    public Builder setOffset(int value) {

      offset_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of results to skip.
     * Applies before limit, but after all other constraints. Must be &gt;= 0 if
     * specified.
     * </pre>
     *
     * <code>int32 offset = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOffset() {

      offset_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int32Value limit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        limitBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     *
     * @return Whether the limit field is set.
     */
    public boolean hasLimit() {
      return limitBuilder_ != null || limit_ != null;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     *
     * @return The limit.
     */
    public com.google.protobuf.Int32Value getLimit() {
      if (limitBuilder_ == null) {
        return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
      } else {
        return limitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     */
    public Builder setLimit(com.google.protobuf.Int32Value value) {
      if (limitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        limit_ = value;
        onChanged();
      } else {
        limitBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     */
    public Builder setLimit(com.google.protobuf.Int32Value.Builder builderForValue) {
      if (limitBuilder_ == null) {
        limit_ = builderForValue.build();
        onChanged();
      } else {
        limitBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     */
    public Builder mergeLimit(com.google.protobuf.Int32Value value) {
      if (limitBuilder_ == null) {
        if (limit_ != null) {
          limit_ =
              com.google.protobuf.Int32Value.newBuilder(limit_).mergeFrom(value).buildPartial();
        } else {
          limit_ = value;
        }
        onChanged();
      } else {
        limitBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     */
    public Builder clearLimit() {
      if (limitBuilder_ == null) {
        limit_ = null;
        onChanged();
      } else {
        limit_ = null;
        limitBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     */
    public com.google.protobuf.Int32Value.Builder getLimitBuilder() {

      onChanged();
      return getLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     */
    public com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder() {
      if (limitBuilder_ != null) {
        return limitBuilder_.getMessageOrBuilder();
      } else {
        return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * Applies after all other constraints.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        getLimitFieldBuilder() {
      if (limitBuilder_ == null) {
        limitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int32Value,
                com.google.protobuf.Int32Value.Builder,
                com.google.protobuf.Int32ValueOrBuilder>(
                getLimit(), getParentForChildren(), isClean());
        limit_ = null;
      }
      return limitBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.StructuredQuery)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.StructuredQuery)
  private static final com.google.firestore.v1beta1.StructuredQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1beta1.StructuredQuery();
  }

  public static com.google.firestore.v1beta1.StructuredQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StructuredQuery> PARSER =
      new com.google.protobuf.AbstractParser<StructuredQuery>() {
        @java.lang.Override
        public StructuredQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StructuredQuery(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<StructuredQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StructuredQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1beta1.StructuredQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
