/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1beta1/write.proto

package com.google.firestore.v1beta1;

/**
 *
 *
 * <pre>
 * A write on a document.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1beta1.Write}
 */
public final class Write extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.Write)
    WriteOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Write.newBuilder() to construct.
  private Write(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Write() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Write();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Write(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.firestore.v1beta1.Document.Builder subBuilder = null;
              if (operationCase_ == 1) {
                subBuilder = ((com.google.firestore.v1beta1.Document) operation_).toBuilder();
              }
              operation_ =
                  input.readMessage(
                      com.google.firestore.v1beta1.Document.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.firestore.v1beta1.Document) operation_);
                operation_ = subBuilder.buildPartial();
              }
              operationCase_ = 1;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              operationCase_ = 2;
              operation_ = s;
              break;
            }
          case 26:
            {
              com.google.firestore.v1beta1.DocumentMask.Builder subBuilder = null;
              if (updateMask_ != null) {
                subBuilder = updateMask_.toBuilder();
              }
              updateMask_ =
                  input.readMessage(
                      com.google.firestore.v1beta1.DocumentMask.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateMask_);
                updateMask_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.firestore.v1beta1.Precondition.Builder subBuilder = null;
              if (currentDocument_ != null) {
                subBuilder = currentDocument_.toBuilder();
              }
              currentDocument_ =
                  input.readMessage(
                      com.google.firestore.v1beta1.Precondition.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(currentDocument_);
                currentDocument_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.firestore.v1beta1.DocumentTransform.Builder subBuilder = null;
              if (operationCase_ == 6) {
                subBuilder =
                    ((com.google.firestore.v1beta1.DocumentTransform) operation_).toBuilder();
              }
              operation_ =
                  input.readMessage(
                      com.google.firestore.v1beta1.DocumentTransform.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.firestore.v1beta1.DocumentTransform) operation_);
                operation_ = subBuilder.buildPartial();
              }
              operationCase_ = 6;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1beta1.WriteProto
        .internal_static_google_firestore_v1beta1_Write_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1beta1.WriteProto
        .internal_static_google_firestore_v1beta1_Write_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1beta1.Write.class,
            com.google.firestore.v1beta1.Write.Builder.class);
  }

  private int operationCase_ = 0;
  private java.lang.Object operation_;

  public enum OperationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    UPDATE(1),
    DELETE(2),
    TRANSFORM(6),
    OPERATION_NOT_SET(0);
    private final int value;

    private OperationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationCase valueOf(int value) {
      return forNumber(value);
    }

    public static OperationCase forNumber(int value) {
      switch (value) {
        case 1:
          return UPDATE;
        case 2:
          return DELETE;
        case 6:
          return TRANSFORM;
        case 0:
          return OPERATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OperationCase getOperationCase() {
    return OperationCase.forNumber(operationCase_);
  }

  public static final int UPDATE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A document to write.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Document update = 1;</code>
   *
   * @return Whether the update field is set.
   */
  public boolean hasUpdate() {
    return operationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A document to write.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Document update = 1;</code>
   *
   * @return The update.
   */
  public com.google.firestore.v1beta1.Document getUpdate() {
    if (operationCase_ == 1) {
      return (com.google.firestore.v1beta1.Document) operation_;
    }
    return com.google.firestore.v1beta1.Document.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A document to write.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Document update = 1;</code>
   */
  public com.google.firestore.v1beta1.DocumentOrBuilder getUpdateOrBuilder() {
    if (operationCase_ == 1) {
      return (com.google.firestore.v1beta1.Document) operation_;
    }
    return com.google.firestore.v1beta1.Document.getDefaultInstance();
  }

  public static final int DELETE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A document name to delete. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string delete = 2;</code>
   *
   * @return The delete.
   */
  public java.lang.String getDelete() {
    java.lang.Object ref = "";
    if (operationCase_ == 2) {
      ref = operation_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (operationCase_ == 2) {
        operation_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A document name to delete. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string delete = 2;</code>
   *
   * @return The bytes for delete.
   */
  public com.google.protobuf.ByteString getDeleteBytes() {
    java.lang.Object ref = "";
    if (operationCase_ == 2) {
      ref = operation_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (operationCase_ == 2) {
        operation_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSFORM_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Applies a transformation to a document.
   * At most one `transform` per document is allowed in a given request.
   * An `update` cannot follow a `transform` on the same document in a given
   * request.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
   *
   * @return Whether the transform field is set.
   */
  public boolean hasTransform() {
    return operationCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Applies a transformation to a document.
   * At most one `transform` per document is allowed in a given request.
   * An `update` cannot follow a `transform` on the same document in a given
   * request.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
   *
   * @return The transform.
   */
  public com.google.firestore.v1beta1.DocumentTransform getTransform() {
    if (operationCase_ == 6) {
      return (com.google.firestore.v1beta1.DocumentTransform) operation_;
    }
    return com.google.firestore.v1beta1.DocumentTransform.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Applies a transformation to a document.
   * At most one `transform` per document is allowed in a given request.
   * An `update` cannot follow a `transform` on the same document in a given
   * request.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
   */
  public com.google.firestore.v1beta1.DocumentTransformOrBuilder getTransformOrBuilder() {
    if (operationCase_ == 6) {
      return (com.google.firestore.v1beta1.DocumentTransform) operation_;
    }
    return com.google.firestore.v1beta1.DocumentTransform.getDefaultInstance();
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 3;
  private com.google.firestore.v1beta1.DocumentMask updateMask_;
  /**
   *
   *
   * <pre>
   * The fields to update in this write.
   * This field can be set only when the operation is `update`.
   * If the mask is not set for an `update` and the document exists, any
   * existing data will be overwritten.
   * If the mask is set and the document on the server has fields not covered by
   * the mask, they are left unchanged.
   * Fields referenced in the mask, but not present in the input document, are
   * deleted from the document on the server.
   * The field paths in this mask must not contain a reserved field name.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
   *
   * @return Whether the updateMask field is set.
   */
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * The fields to update in this write.
   * This field can be set only when the operation is `update`.
   * If the mask is not set for an `update` and the document exists, any
   * existing data will be overwritten.
   * If the mask is set and the document on the server has fields not covered by
   * the mask, they are left unchanged.
   * Fields referenced in the mask, but not present in the input document, are
   * deleted from the document on the server.
   * The field paths in this mask must not contain a reserved field name.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
   *
   * @return The updateMask.
   */
  public com.google.firestore.v1beta1.DocumentMask getUpdateMask() {
    return updateMask_ == null
        ? com.google.firestore.v1beta1.DocumentMask.getDefaultInstance()
        : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * The fields to update in this write.
   * This field can be set only when the operation is `update`.
   * If the mask is not set for an `update` and the document exists, any
   * existing data will be overwritten.
   * If the mask is set and the document on the server has fields not covered by
   * the mask, they are left unchanged.
   * Fields referenced in the mask, but not present in the input document, are
   * deleted from the document on the server.
   * The field paths in this mask must not contain a reserved field name.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
   */
  public com.google.firestore.v1beta1.DocumentMaskOrBuilder getUpdateMaskOrBuilder() {
    return getUpdateMask();
  }

  public static final int CURRENT_DOCUMENT_FIELD_NUMBER = 4;
  private com.google.firestore.v1beta1.Precondition currentDocument_;
  /**
   *
   *
   * <pre>
   * An optional precondition on the document.
   * The write will fail if this is set and not met by the target document.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
   *
   * @return Whether the currentDocument field is set.
   */
  public boolean hasCurrentDocument() {
    return currentDocument_ != null;
  }
  /**
   *
   *
   * <pre>
   * An optional precondition on the document.
   * The write will fail if this is set and not met by the target document.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
   *
   * @return The currentDocument.
   */
  public com.google.firestore.v1beta1.Precondition getCurrentDocument() {
    return currentDocument_ == null
        ? com.google.firestore.v1beta1.Precondition.getDefaultInstance()
        : currentDocument_;
  }
  /**
   *
   *
   * <pre>
   * An optional precondition on the document.
   * The write will fail if this is set and not met by the target document.
   * </pre>
   *
   * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
   */
  public com.google.firestore.v1beta1.PreconditionOrBuilder getCurrentDocumentOrBuilder() {
    return getCurrentDocument();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (operationCase_ == 1) {
      output.writeMessage(1, (com.google.firestore.v1beta1.Document) operation_);
    }
    if (operationCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, operation_);
    }
    if (updateMask_ != null) {
      output.writeMessage(3, getUpdateMask());
    }
    if (currentDocument_ != null) {
      output.writeMessage(4, getCurrentDocument());
    }
    if (operationCase_ == 6) {
      output.writeMessage(6, (com.google.firestore.v1beta1.DocumentTransform) operation_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (operationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.firestore.v1beta1.Document) operation_);
    }
    if (operationCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, operation_);
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateMask());
    }
    if (currentDocument_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCurrentDocument());
    }
    if (operationCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.firestore.v1beta1.DocumentTransform) operation_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1beta1.Write)) {
      return super.equals(obj);
    }
    com.google.firestore.v1beta1.Write other = (com.google.firestore.v1beta1.Write) obj;

    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (hasCurrentDocument() != other.hasCurrentDocument()) return false;
    if (hasCurrentDocument()) {
      if (!getCurrentDocument().equals(other.getCurrentDocument())) return false;
    }
    if (!getOperationCase().equals(other.getOperationCase())) return false;
    switch (operationCase_) {
      case 1:
        if (!getUpdate().equals(other.getUpdate())) return false;
        break;
      case 2:
        if (!getDelete().equals(other.getDelete())) return false;
        break;
      case 6:
        if (!getTransform().equals(other.getTransform())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    if (hasCurrentDocument()) {
      hash = (37 * hash) + CURRENT_DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentDocument().hashCode();
    }
    switch (operationCase_) {
      case 1:
        hash = (37 * hash) + UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getUpdate().hashCode();
        break;
      case 2:
        hash = (37 * hash) + DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDelete().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TRANSFORM_FIELD_NUMBER;
        hash = (53 * hash) + getTransform().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1beta1.Write parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.Write parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.Write parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.Write parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1beta1.Write prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A write on a document.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.Write}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.Write)
      com.google.firestore.v1beta1.WriteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.WriteProto
          .internal_static_google_firestore_v1beta1_Write_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.WriteProto
          .internal_static_google_firestore_v1beta1_Write_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.Write.class,
              com.google.firestore.v1beta1.Write.Builder.class);
    }

    // Construct using com.google.firestore.v1beta1.Write.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (updateMaskBuilder_ == null) {
        updateMask_ = null;
      } else {
        updateMask_ = null;
        updateMaskBuilder_ = null;
      }
      if (currentDocumentBuilder_ == null) {
        currentDocument_ = null;
      } else {
        currentDocument_ = null;
        currentDocumentBuilder_ = null;
      }
      operationCase_ = 0;
      operation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1beta1.WriteProto
          .internal_static_google_firestore_v1beta1_Write_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.Write getDefaultInstanceForType() {
      return com.google.firestore.v1beta1.Write.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.Write build() {
      com.google.firestore.v1beta1.Write result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.Write buildPartial() {
      com.google.firestore.v1beta1.Write result = new com.google.firestore.v1beta1.Write(this);
      if (operationCase_ == 1) {
        if (updateBuilder_ == null) {
          result.operation_ = operation_;
        } else {
          result.operation_ = updateBuilder_.build();
        }
      }
      if (operationCase_ == 2) {
        result.operation_ = operation_;
      }
      if (operationCase_ == 6) {
        if (transformBuilder_ == null) {
          result.operation_ = operation_;
        } else {
          result.operation_ = transformBuilder_.build();
        }
      }
      if (updateMaskBuilder_ == null) {
        result.updateMask_ = updateMask_;
      } else {
        result.updateMask_ = updateMaskBuilder_.build();
      }
      if (currentDocumentBuilder_ == null) {
        result.currentDocument_ = currentDocument_;
      } else {
        result.currentDocument_ = currentDocumentBuilder_.build();
      }
      result.operationCase_ = operationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1beta1.Write) {
        return mergeFrom((com.google.firestore.v1beta1.Write) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1beta1.Write other) {
      if (other == com.google.firestore.v1beta1.Write.getDefaultInstance()) return this;
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (other.hasCurrentDocument()) {
        mergeCurrentDocument(other.getCurrentDocument());
      }
      switch (other.getOperationCase()) {
        case UPDATE:
          {
            mergeUpdate(other.getUpdate());
            break;
          }
        case DELETE:
          {
            operationCase_ = 2;
            operation_ = other.operation_;
            onChanged();
            break;
          }
        case TRANSFORM:
          {
            mergeTransform(other.getTransform());
            break;
          }
        case OPERATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.v1beta1.Write parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.v1beta1.Write) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int operationCase_ = 0;
    private java.lang.Object operation_;

    public OperationCase getOperationCase() {
      return OperationCase.forNumber(operationCase_);
    }

    public Builder clearOperation() {
      operationCase_ = 0;
      operation_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.Document,
            com.google.firestore.v1beta1.Document.Builder,
            com.google.firestore.v1beta1.DocumentOrBuilder>
        updateBuilder_;
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     *
     * @return Whether the update field is set.
     */
    public boolean hasUpdate() {
      return operationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     *
     * @return The update.
     */
    public com.google.firestore.v1beta1.Document getUpdate() {
      if (updateBuilder_ == null) {
        if (operationCase_ == 1) {
          return (com.google.firestore.v1beta1.Document) operation_;
        }
        return com.google.firestore.v1beta1.Document.getDefaultInstance();
      } else {
        if (operationCase_ == 1) {
          return updateBuilder_.getMessage();
        }
        return com.google.firestore.v1beta1.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     */
    public Builder setUpdate(com.google.firestore.v1beta1.Document value) {
      if (updateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        updateBuilder_.setMessage(value);
      }
      operationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     */
    public Builder setUpdate(com.google.firestore.v1beta1.Document.Builder builderForValue) {
      if (updateBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        updateBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     */
    public Builder mergeUpdate(com.google.firestore.v1beta1.Document value) {
      if (updateBuilder_ == null) {
        if (operationCase_ == 1
            && operation_ != com.google.firestore.v1beta1.Document.getDefaultInstance()) {
          operation_ =
              com.google.firestore.v1beta1.Document.newBuilder(
                      (com.google.firestore.v1beta1.Document) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 1) {
          updateBuilder_.mergeFrom(value);
        }
        updateBuilder_.setMessage(value);
      }
      operationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     */
    public Builder clearUpdate() {
      if (updateBuilder_ == null) {
        if (operationCase_ == 1) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 1) {
          operationCase_ = 0;
          operation_ = null;
        }
        updateBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     */
    public com.google.firestore.v1beta1.Document.Builder getUpdateBuilder() {
      return getUpdateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     */
    public com.google.firestore.v1beta1.DocumentOrBuilder getUpdateOrBuilder() {
      if ((operationCase_ == 1) && (updateBuilder_ != null)) {
        return updateBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 1) {
          return (com.google.firestore.v1beta1.Document) operation_;
        }
        return com.google.firestore.v1beta1.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A document to write.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Document update = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.Document,
            com.google.firestore.v1beta1.Document.Builder,
            com.google.firestore.v1beta1.DocumentOrBuilder>
        getUpdateFieldBuilder() {
      if (updateBuilder_ == null) {
        if (!(operationCase_ == 1)) {
          operation_ = com.google.firestore.v1beta1.Document.getDefaultInstance();
        }
        updateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1beta1.Document,
                com.google.firestore.v1beta1.Document.Builder,
                com.google.firestore.v1beta1.DocumentOrBuilder>(
                (com.google.firestore.v1beta1.Document) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 1;
      onChanged();
      ;
      return updateBuilder_;
    }

    /**
     *
     *
     * <pre>
     * A document name to delete. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string delete = 2;</code>
     *
     * @return The delete.
     */
    public java.lang.String getDelete() {
      java.lang.Object ref = "";
      if (operationCase_ == 2) {
        ref = operation_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (operationCase_ == 2) {
          operation_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A document name to delete. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string delete = 2;</code>
     *
     * @return The bytes for delete.
     */
    public com.google.protobuf.ByteString getDeleteBytes() {
      java.lang.Object ref = "";
      if (operationCase_ == 2) {
        ref = operation_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (operationCase_ == 2) {
          operation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A document name to delete. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string delete = 2;</code>
     *
     * @param value The delete to set.
     * @return This builder for chaining.
     */
    public Builder setDelete(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationCase_ = 2;
      operation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document name to delete. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string delete = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDelete() {
      if (operationCase_ == 2) {
        operationCase_ = 0;
        operation_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document name to delete. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string delete = 2;</code>
     *
     * @param value The bytes for delete to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationCase_ = 2;
      operation_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.DocumentTransform,
            com.google.firestore.v1beta1.DocumentTransform.Builder,
            com.google.firestore.v1beta1.DocumentTransformOrBuilder>
        transformBuilder_;
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     *
     * @return Whether the transform field is set.
     */
    public boolean hasTransform() {
      return operationCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     *
     * @return The transform.
     */
    public com.google.firestore.v1beta1.DocumentTransform getTransform() {
      if (transformBuilder_ == null) {
        if (operationCase_ == 6) {
          return (com.google.firestore.v1beta1.DocumentTransform) operation_;
        }
        return com.google.firestore.v1beta1.DocumentTransform.getDefaultInstance();
      } else {
        if (operationCase_ == 6) {
          return transformBuilder_.getMessage();
        }
        return com.google.firestore.v1beta1.DocumentTransform.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     */
    public Builder setTransform(com.google.firestore.v1beta1.DocumentTransform value) {
      if (transformBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        transformBuilder_.setMessage(value);
      }
      operationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     */
    public Builder setTransform(
        com.google.firestore.v1beta1.DocumentTransform.Builder builderForValue) {
      if (transformBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        transformBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     */
    public Builder mergeTransform(com.google.firestore.v1beta1.DocumentTransform value) {
      if (transformBuilder_ == null) {
        if (operationCase_ == 6
            && operation_ != com.google.firestore.v1beta1.DocumentTransform.getDefaultInstance()) {
          operation_ =
              com.google.firestore.v1beta1.DocumentTransform.newBuilder(
                      (com.google.firestore.v1beta1.DocumentTransform) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 6) {
          transformBuilder_.mergeFrom(value);
        }
        transformBuilder_.setMessage(value);
      }
      operationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     */
    public Builder clearTransform() {
      if (transformBuilder_ == null) {
        if (operationCase_ == 6) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 6) {
          operationCase_ = 0;
          operation_ = null;
        }
        transformBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     */
    public com.google.firestore.v1beta1.DocumentTransform.Builder getTransformBuilder() {
      return getTransformFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     */
    public com.google.firestore.v1beta1.DocumentTransformOrBuilder getTransformOrBuilder() {
      if ((operationCase_ == 6) && (transformBuilder_ != null)) {
        return transformBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 6) {
          return (com.google.firestore.v1beta1.DocumentTransform) operation_;
        }
        return com.google.firestore.v1beta1.DocumentTransform.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies a transformation to a document.
     * At most one `transform` per document is allowed in a given request.
     * An `update` cannot follow a `transform` on the same document in a given
     * request.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentTransform transform = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.DocumentTransform,
            com.google.firestore.v1beta1.DocumentTransform.Builder,
            com.google.firestore.v1beta1.DocumentTransformOrBuilder>
        getTransformFieldBuilder() {
      if (transformBuilder_ == null) {
        if (!(operationCase_ == 6)) {
          operation_ = com.google.firestore.v1beta1.DocumentTransform.getDefaultInstance();
        }
        transformBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1beta1.DocumentTransform,
                com.google.firestore.v1beta1.DocumentTransform.Builder,
                com.google.firestore.v1beta1.DocumentTransformOrBuilder>(
                (com.google.firestore.v1beta1.DocumentTransform) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 6;
      onChanged();
      ;
      return transformBuilder_;
    }

    private com.google.firestore.v1beta1.DocumentMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.DocumentMask,
            com.google.firestore.v1beta1.DocumentMask.Builder,
            com.google.firestore.v1beta1.DocumentMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return updateMaskBuilder_ != null || updateMask_ != null;
    }
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     *
     * @return The updateMask.
     */
    public com.google.firestore.v1beta1.DocumentMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.firestore.v1beta1.DocumentMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     */
    public Builder setUpdateMask(com.google.firestore.v1beta1.DocumentMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
        onChanged();
      } else {
        updateMaskBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     */
    public Builder setUpdateMask(
        com.google.firestore.v1beta1.DocumentMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
        onChanged();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     */
    public Builder mergeUpdateMask(com.google.firestore.v1beta1.DocumentMask value) {
      if (updateMaskBuilder_ == null) {
        if (updateMask_ != null) {
          updateMask_ =
              com.google.firestore.v1beta1.DocumentMask.newBuilder(updateMask_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          updateMask_ = value;
        }
        onChanged();
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     */
    public Builder clearUpdateMask() {
      if (updateMaskBuilder_ == null) {
        updateMask_ = null;
        onChanged();
      } else {
        updateMask_ = null;
        updateMaskBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     */
    public com.google.firestore.v1beta1.DocumentMask.Builder getUpdateMaskBuilder() {

      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     */
    public com.google.firestore.v1beta1.DocumentMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.firestore.v1beta1.DocumentMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fields to update in this write.
     * This field can be set only when the operation is `update`.
     * If the mask is not set for an `update` and the document exists, any
     * existing data will be overwritten.
     * If the mask is set and the document on the server has fields not covered by
     * the mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * The field paths in this mask must not contain a reserved field name.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.DocumentMask update_mask = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.DocumentMask,
            com.google.firestore.v1beta1.DocumentMask.Builder,
            com.google.firestore.v1beta1.DocumentMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1beta1.DocumentMask,
                com.google.firestore.v1beta1.DocumentMask.Builder,
                com.google.firestore.v1beta1.DocumentMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private com.google.firestore.v1beta1.Precondition currentDocument_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.Precondition,
            com.google.firestore.v1beta1.Precondition.Builder,
            com.google.firestore.v1beta1.PreconditionOrBuilder>
        currentDocumentBuilder_;
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     *
     * @return Whether the currentDocument field is set.
     */
    public boolean hasCurrentDocument() {
      return currentDocumentBuilder_ != null || currentDocument_ != null;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     *
     * @return The currentDocument.
     */
    public com.google.firestore.v1beta1.Precondition getCurrentDocument() {
      if (currentDocumentBuilder_ == null) {
        return currentDocument_ == null
            ? com.google.firestore.v1beta1.Precondition.getDefaultInstance()
            : currentDocument_;
      } else {
        return currentDocumentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     */
    public Builder setCurrentDocument(com.google.firestore.v1beta1.Precondition value) {
      if (currentDocumentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentDocument_ = value;
        onChanged();
      } else {
        currentDocumentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     */
    public Builder setCurrentDocument(
        com.google.firestore.v1beta1.Precondition.Builder builderForValue) {
      if (currentDocumentBuilder_ == null) {
        currentDocument_ = builderForValue.build();
        onChanged();
      } else {
        currentDocumentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     */
    public Builder mergeCurrentDocument(com.google.firestore.v1beta1.Precondition value) {
      if (currentDocumentBuilder_ == null) {
        if (currentDocument_ != null) {
          currentDocument_ =
              com.google.firestore.v1beta1.Precondition.newBuilder(currentDocument_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          currentDocument_ = value;
        }
        onChanged();
      } else {
        currentDocumentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     */
    public Builder clearCurrentDocument() {
      if (currentDocumentBuilder_ == null) {
        currentDocument_ = null;
        onChanged();
      } else {
        currentDocument_ = null;
        currentDocumentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     */
    public com.google.firestore.v1beta1.Precondition.Builder getCurrentDocumentBuilder() {

      onChanged();
      return getCurrentDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     */
    public com.google.firestore.v1beta1.PreconditionOrBuilder getCurrentDocumentOrBuilder() {
      if (currentDocumentBuilder_ != null) {
        return currentDocumentBuilder_.getMessageOrBuilder();
      } else {
        return currentDocument_ == null
            ? com.google.firestore.v1beta1.Precondition.getDefaultInstance()
            : currentDocument_;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The write will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1beta1.Precondition current_document = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1beta1.Precondition,
            com.google.firestore.v1beta1.Precondition.Builder,
            com.google.firestore.v1beta1.PreconditionOrBuilder>
        getCurrentDocumentFieldBuilder() {
      if (currentDocumentBuilder_ == null) {
        currentDocumentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1beta1.Precondition,
                com.google.firestore.v1beta1.Precondition.Builder,
                com.google.firestore.v1beta1.PreconditionOrBuilder>(
                getCurrentDocument(), getParentForChildren(), isClean());
        currentDocument_ = null;
      }
      return currentDocumentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.Write)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.Write)
  private static final com.google.firestore.v1beta1.Write DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1beta1.Write();
  }

  public static com.google.firestore.v1beta1.Write getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Write> PARSER =
      new com.google.protobuf.AbstractParser<Write>() {
        @java.lang.Override
        public Write parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Write(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Write> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Write> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1beta1.Write getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
