/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1beta1/firestore.proto

package com.google.firestore.v1beta1;

/**
 *
 *
 * <pre>
 * The response for [Firestore.Write][google.firestore.v1beta1.Firestore.Write].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1beta1.WriteResponse}
 */
public final class WriteResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1beta1.WriteResponse)
    WriteResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WriteResponse.newBuilder() to construct.
  private WriteResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WriteResponse() {
    streamId_ = "";
    streamToken_ = com.google.protobuf.ByteString.EMPTY;
    writeResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WriteResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WriteResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              streamId_ = s;
              break;
            }
          case 18:
            {
              streamToken_ = input.readBytes();
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                writeResults_ = new java.util.ArrayList<com.google.firestore.v1beta1.WriteResult>();
                mutable_bitField0_ |= 0x00000001;
              }
              writeResults_.add(
                  input.readMessage(
                      com.google.firestore.v1beta1.WriteResult.parser(), extensionRegistry));
              break;
            }
          case 34:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (commitTime_ != null) {
                subBuilder = commitTime_.toBuilder();
              }
              commitTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(commitTime_);
                commitTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        writeResults_ = java.util.Collections.unmodifiableList(writeResults_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1beta1.FirestoreProto
        .internal_static_google_firestore_v1beta1_WriteResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1beta1.FirestoreProto
        .internal_static_google_firestore_v1beta1_WriteResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1beta1.WriteResponse.class,
            com.google.firestore.v1beta1.WriteResponse.Builder.class);
  }

  public static final int STREAM_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object streamId_;
  /**
   *
   *
   * <pre>
   * The ID of the stream.
   * Only set on the first message, when a new stream was created.
   * </pre>
   *
   * <code>string stream_id = 1;</code>
   *
   * @return The streamId.
   */
  public java.lang.String getStreamId() {
    java.lang.Object ref = streamId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      streamId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the stream.
   * Only set on the first message, when a new stream was created.
   * </pre>
   *
   * <code>string stream_id = 1;</code>
   *
   * @return The bytes for streamId.
   */
  public com.google.protobuf.ByteString getStreamIdBytes() {
    java.lang.Object ref = streamId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      streamId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STREAM_TOKEN_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString streamToken_;
  /**
   *
   *
   * <pre>
   * A token that represents the position of this response in the stream.
   * This can be used by a client to resume the stream at this point.
   * This field is always set.
   * </pre>
   *
   * <code>bytes stream_token = 2;</code>
   *
   * @return The streamToken.
   */
  public com.google.protobuf.ByteString getStreamToken() {
    return streamToken_;
  }

  public static final int WRITE_RESULTS_FIELD_NUMBER = 3;
  private java.util.List<com.google.firestore.v1beta1.WriteResult> writeResults_;
  /**
   *
   *
   * <pre>
   * The result of applying the writes.
   * This i-th write result corresponds to the i-th write in the
   * request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
   */
  public java.util.List<com.google.firestore.v1beta1.WriteResult> getWriteResultsList() {
    return writeResults_;
  }
  /**
   *
   *
   * <pre>
   * The result of applying the writes.
   * This i-th write result corresponds to the i-th write in the
   * request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
   */
  public java.util.List<? extends com.google.firestore.v1beta1.WriteResultOrBuilder>
      getWriteResultsOrBuilderList() {
    return writeResults_;
  }
  /**
   *
   *
   * <pre>
   * The result of applying the writes.
   * This i-th write result corresponds to the i-th write in the
   * request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
   */
  public int getWriteResultsCount() {
    return writeResults_.size();
  }
  /**
   *
   *
   * <pre>
   * The result of applying the writes.
   * This i-th write result corresponds to the i-th write in the
   * request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
   */
  public com.google.firestore.v1beta1.WriteResult getWriteResults(int index) {
    return writeResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The result of applying the writes.
   * This i-th write result corresponds to the i-th write in the
   * request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
   */
  public com.google.firestore.v1beta1.WriteResultOrBuilder getWriteResultsOrBuilder(int index) {
    return writeResults_.get(index);
  }

  public static final int COMMIT_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp commitTime_;
  /**
   *
   *
   * <pre>
   * The time at which the commit occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 4;</code>
   *
   * @return Whether the commitTime field is set.
   */
  public boolean hasCommitTime() {
    return commitTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the commit occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 4;</code>
   *
   * @return The commitTime.
   */
  public com.google.protobuf.Timestamp getCommitTime() {
    return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the commit occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 4;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
    return getCommitTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getStreamIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, streamId_);
    }
    if (!streamToken_.isEmpty()) {
      output.writeBytes(2, streamToken_);
    }
    for (int i = 0; i < writeResults_.size(); i++) {
      output.writeMessage(3, writeResults_.get(i));
    }
    if (commitTime_ != null) {
      output.writeMessage(4, getCommitTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getStreamIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, streamId_);
    }
    if (!streamToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, streamToken_);
    }
    for (int i = 0; i < writeResults_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, writeResults_.get(i));
    }
    if (commitTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCommitTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1beta1.WriteResponse)) {
      return super.equals(obj);
    }
    com.google.firestore.v1beta1.WriteResponse other =
        (com.google.firestore.v1beta1.WriteResponse) obj;

    if (!getStreamId().equals(other.getStreamId())) return false;
    if (!getStreamToken().equals(other.getStreamToken())) return false;
    if (!getWriteResultsList().equals(other.getWriteResultsList())) return false;
    if (hasCommitTime() != other.hasCommitTime()) return false;
    if (hasCommitTime()) {
      if (!getCommitTime().equals(other.getCommitTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STREAM_ID_FIELD_NUMBER;
    hash = (53 * hash) + getStreamId().hashCode();
    hash = (37 * hash) + STREAM_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getStreamToken().hashCode();
    if (getWriteResultsCount() > 0) {
      hash = (37 * hash) + WRITE_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getWriteResultsList().hashCode();
    }
    if (hasCommitTime()) {
      hash = (37 * hash) + COMMIT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCommitTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1beta1.WriteResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1beta1.WriteResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for [Firestore.Write][google.firestore.v1beta1.Firestore.Write].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1beta1.WriteResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1beta1.WriteResponse)
      com.google.firestore.v1beta1.WriteResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1beta1.FirestoreProto
          .internal_static_google_firestore_v1beta1_WriteResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1beta1.FirestoreProto
          .internal_static_google_firestore_v1beta1_WriteResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1beta1.WriteResponse.class,
              com.google.firestore.v1beta1.WriteResponse.Builder.class);
    }

    // Construct using com.google.firestore.v1beta1.WriteResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWriteResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      streamId_ = "";

      streamToken_ = com.google.protobuf.ByteString.EMPTY;

      if (writeResultsBuilder_ == null) {
        writeResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        writeResultsBuilder_.clear();
      }
      if (commitTimeBuilder_ == null) {
        commitTime_ = null;
      } else {
        commitTime_ = null;
        commitTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1beta1.FirestoreProto
          .internal_static_google_firestore_v1beta1_WriteResponse_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.WriteResponse getDefaultInstanceForType() {
      return com.google.firestore.v1beta1.WriteResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.WriteResponse build() {
      com.google.firestore.v1beta1.WriteResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1beta1.WriteResponse buildPartial() {
      com.google.firestore.v1beta1.WriteResponse result =
          new com.google.firestore.v1beta1.WriteResponse(this);
      int from_bitField0_ = bitField0_;
      result.streamId_ = streamId_;
      result.streamToken_ = streamToken_;
      if (writeResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          writeResults_ = java.util.Collections.unmodifiableList(writeResults_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.writeResults_ = writeResults_;
      } else {
        result.writeResults_ = writeResultsBuilder_.build();
      }
      if (commitTimeBuilder_ == null) {
        result.commitTime_ = commitTime_;
      } else {
        result.commitTime_ = commitTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1beta1.WriteResponse) {
        return mergeFrom((com.google.firestore.v1beta1.WriteResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1beta1.WriteResponse other) {
      if (other == com.google.firestore.v1beta1.WriteResponse.getDefaultInstance()) return this;
      if (!other.getStreamId().isEmpty()) {
        streamId_ = other.streamId_;
        onChanged();
      }
      if (other.getStreamToken() != com.google.protobuf.ByteString.EMPTY) {
        setStreamToken(other.getStreamToken());
      }
      if (writeResultsBuilder_ == null) {
        if (!other.writeResults_.isEmpty()) {
          if (writeResults_.isEmpty()) {
            writeResults_ = other.writeResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureWriteResultsIsMutable();
            writeResults_.addAll(other.writeResults_);
          }
          onChanged();
        }
      } else {
        if (!other.writeResults_.isEmpty()) {
          if (writeResultsBuilder_.isEmpty()) {
            writeResultsBuilder_.dispose();
            writeResultsBuilder_ = null;
            writeResults_ = other.writeResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
            writeResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWriteResultsFieldBuilder()
                    : null;
          } else {
            writeResultsBuilder_.addAllMessages(other.writeResults_);
          }
        }
      }
      if (other.hasCommitTime()) {
        mergeCommitTime(other.getCommitTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.v1beta1.WriteResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.v1beta1.WriteResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object streamId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the stream.
     * Only set on the first message, when a new stream was created.
     * </pre>
     *
     * <code>string stream_id = 1;</code>
     *
     * @return The streamId.
     */
    public java.lang.String getStreamId() {
      java.lang.Object ref = streamId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        streamId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the stream.
     * Only set on the first message, when a new stream was created.
     * </pre>
     *
     * <code>string stream_id = 1;</code>
     *
     * @return The bytes for streamId.
     */
    public com.google.protobuf.ByteString getStreamIdBytes() {
      java.lang.Object ref = streamId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        streamId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the stream.
     * Only set on the first message, when a new stream was created.
     * </pre>
     *
     * <code>string stream_id = 1;</code>
     *
     * @param value The streamId to set.
     * @return This builder for chaining.
     */
    public Builder setStreamId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      streamId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the stream.
     * Only set on the first message, when a new stream was created.
     * </pre>
     *
     * <code>string stream_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStreamId() {

      streamId_ = getDefaultInstance().getStreamId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the stream.
     * Only set on the first message, when a new stream was created.
     * </pre>
     *
     * <code>string stream_id = 1;</code>
     *
     * @param value The bytes for streamId to set.
     * @return This builder for chaining.
     */
    public Builder setStreamIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      streamId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString streamToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * A token that represents the position of this response in the stream.
     * This can be used by a client to resume the stream at this point.
     * This field is always set.
     * </pre>
     *
     * <code>bytes stream_token = 2;</code>
     *
     * @return The streamToken.
     */
    public com.google.protobuf.ByteString getStreamToken() {
      return streamToken_;
    }
    /**
     *
     *
     * <pre>
     * A token that represents the position of this response in the stream.
     * This can be used by a client to resume the stream at this point.
     * This field is always set.
     * </pre>
     *
     * <code>bytes stream_token = 2;</code>
     *
     * @param value The streamToken to set.
     * @return This builder for chaining.
     */
    public Builder setStreamToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      streamToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token that represents the position of this response in the stream.
     * This can be used by a client to resume the stream at this point.
     * This field is always set.
     * </pre>
     *
     * <code>bytes stream_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStreamToken() {

      streamToken_ = getDefaultInstance().getStreamToken();
      onChanged();
      return this;
    }

    private java.util.List<com.google.firestore.v1beta1.WriteResult> writeResults_ =
        java.util.Collections.emptyList();

    private void ensureWriteResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        writeResults_ =
            new java.util.ArrayList<com.google.firestore.v1beta1.WriteResult>(writeResults_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1beta1.WriteResult,
            com.google.firestore.v1beta1.WriteResult.Builder,
            com.google.firestore.v1beta1.WriteResultOrBuilder>
        writeResultsBuilder_;

    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public java.util.List<com.google.firestore.v1beta1.WriteResult> getWriteResultsList() {
      if (writeResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(writeResults_);
      } else {
        return writeResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public int getWriteResultsCount() {
      if (writeResultsBuilder_ == null) {
        return writeResults_.size();
      } else {
        return writeResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public com.google.firestore.v1beta1.WriteResult getWriteResults(int index) {
      if (writeResultsBuilder_ == null) {
        return writeResults_.get(index);
      } else {
        return writeResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder setWriteResults(int index, com.google.firestore.v1beta1.WriteResult value) {
      if (writeResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWriteResultsIsMutable();
        writeResults_.set(index, value);
        onChanged();
      } else {
        writeResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder setWriteResults(
        int index, com.google.firestore.v1beta1.WriteResult.Builder builderForValue) {
      if (writeResultsBuilder_ == null) {
        ensureWriteResultsIsMutable();
        writeResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        writeResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder addWriteResults(com.google.firestore.v1beta1.WriteResult value) {
      if (writeResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWriteResultsIsMutable();
        writeResults_.add(value);
        onChanged();
      } else {
        writeResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder addWriteResults(int index, com.google.firestore.v1beta1.WriteResult value) {
      if (writeResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWriteResultsIsMutable();
        writeResults_.add(index, value);
        onChanged();
      } else {
        writeResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder addWriteResults(
        com.google.firestore.v1beta1.WriteResult.Builder builderForValue) {
      if (writeResultsBuilder_ == null) {
        ensureWriteResultsIsMutable();
        writeResults_.add(builderForValue.build());
        onChanged();
      } else {
        writeResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder addWriteResults(
        int index, com.google.firestore.v1beta1.WriteResult.Builder builderForValue) {
      if (writeResultsBuilder_ == null) {
        ensureWriteResultsIsMutable();
        writeResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        writeResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder addAllWriteResults(
        java.lang.Iterable<? extends com.google.firestore.v1beta1.WriteResult> values) {
      if (writeResultsBuilder_ == null) {
        ensureWriteResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, writeResults_);
        onChanged();
      } else {
        writeResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder clearWriteResults() {
      if (writeResultsBuilder_ == null) {
        writeResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        writeResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public Builder removeWriteResults(int index) {
      if (writeResultsBuilder_ == null) {
        ensureWriteResultsIsMutable();
        writeResults_.remove(index);
        onChanged();
      } else {
        writeResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public com.google.firestore.v1beta1.WriteResult.Builder getWriteResultsBuilder(int index) {
      return getWriteResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public com.google.firestore.v1beta1.WriteResultOrBuilder getWriteResultsOrBuilder(int index) {
      if (writeResultsBuilder_ == null) {
        return writeResults_.get(index);
      } else {
        return writeResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public java.util.List<? extends com.google.firestore.v1beta1.WriteResultOrBuilder>
        getWriteResultsOrBuilderList() {
      if (writeResultsBuilder_ != null) {
        return writeResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(writeResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public com.google.firestore.v1beta1.WriteResult.Builder addWriteResultsBuilder() {
      return getWriteResultsFieldBuilder()
          .addBuilder(com.google.firestore.v1beta1.WriteResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public com.google.firestore.v1beta1.WriteResult.Builder addWriteResultsBuilder(int index) {
      return getWriteResultsFieldBuilder()
          .addBuilder(index, com.google.firestore.v1beta1.WriteResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The result of applying the writes.
     * This i-th write result corresponds to the i-th write in the
     * request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1beta1.WriteResult write_results = 3;</code>
     */
    public java.util.List<com.google.firestore.v1beta1.WriteResult.Builder>
        getWriteResultsBuilderList() {
      return getWriteResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1beta1.WriteResult,
            com.google.firestore.v1beta1.WriteResult.Builder,
            com.google.firestore.v1beta1.WriteResultOrBuilder>
        getWriteResultsFieldBuilder() {
      if (writeResultsBuilder_ == null) {
        writeResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.firestore.v1beta1.WriteResult,
                com.google.firestore.v1beta1.WriteResult.Builder,
                com.google.firestore.v1beta1.WriteResultOrBuilder>(
                writeResults_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        writeResults_ = null;
      }
      return writeResultsBuilder_;
    }

    private com.google.protobuf.Timestamp commitTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     *
     * @return Whether the commitTime field is set.
     */
    public boolean hasCommitTime() {
      return commitTimeBuilder_ != null || commitTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     *
     * @return The commitTime.
     */
    public com.google.protobuf.Timestamp getCommitTime() {
      if (commitTimeBuilder_ == null) {
        return commitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTime_;
      } else {
        return commitTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     */
    public Builder setCommitTime(com.google.protobuf.Timestamp value) {
      if (commitTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitTime_ = value;
        onChanged();
      } else {
        commitTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     */
    public Builder setCommitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimeBuilder_ == null) {
        commitTime_ = builderForValue.build();
        onChanged();
      } else {
        commitTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     */
    public Builder mergeCommitTime(com.google.protobuf.Timestamp value) {
      if (commitTimeBuilder_ == null) {
        if (commitTime_ != null) {
          commitTime_ =
              com.google.protobuf.Timestamp.newBuilder(commitTime_).mergeFrom(value).buildPartial();
        } else {
          commitTime_ = value;
        }
        onChanged();
      } else {
        commitTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     */
    public Builder clearCommitTime() {
      if (commitTimeBuilder_ == null) {
        commitTime_ = null;
        onChanged();
      } else {
        commitTime_ = null;
        commitTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitTimeBuilder() {

      onChanged();
      return getCommitTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
      if (commitTimeBuilder_ != null) {
        return commitTimeBuilder_.getMessageOrBuilder();
      } else {
        return commitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the commit occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitTimeFieldBuilder() {
      if (commitTimeBuilder_ == null) {
        commitTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCommitTime(), getParentForChildren(), isClean());
        commitTime_ = null;
      }
      return commitTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1beta1.WriteResponse)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1beta1.WriteResponse)
  private static final com.google.firestore.v1beta1.WriteResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1beta1.WriteResponse();
  }

  public static com.google.firestore.v1beta1.WriteResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WriteResponse> PARSER =
      new com.google.protobuf.AbstractParser<WriteResponse>() {
        @java.lang.Override
        public WriteResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WriteResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WriteResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WriteResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1beta1.WriteResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
