/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.groupssettings;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.groupssettings.GroupssettingsRequest;
import com.google.api.services.groupssettings.GroupssettingsRequestInitializer;
import java.io.IOException;

public class Groupssettings
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://www.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "groups/v1/groups/";
    public static final String DEFAULT_BATCH_PATH = "batch/groupssettings/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/groups/v1/groups/";

    public Groupssettings(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Groupssettings(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Groups groups() {
        return new Groups();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the Groups Settings API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Groupssettings.DEFAULT_MTLS_ROOT_URL;
            }
            return Groupssettings.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Groupssettings.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Groupssettings.DEFAULT_BATCH_PATH);
        }

        public Groupssettings build() {
            return new Groupssettings(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setGroupssettingsRequestInitializer(GroupssettingsRequestInitializer groupssettingsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)groupssettingsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Groups {
        public Get get(String groupUniqueId) throws IOException {
            Get result = new Get(groupUniqueId);
            Groupssettings.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String groupUniqueId, com.google.api.services.groupssettings.model.Groups content) throws IOException {
            Patch result = new Patch(groupUniqueId, content);
            Groupssettings.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String groupUniqueId, com.google.api.services.groupssettings.model.Groups content) throws IOException {
            Update result = new Update(groupUniqueId, content);
            Groupssettings.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends GroupssettingsRequest<com.google.api.services.groupssettings.model.Groups> {
            private static final String REST_PATH = "{groupUniqueId}";
            @Key
            private String groupUniqueId;

            protected Update(String groupUniqueId, com.google.api.services.groupssettings.model.Groups content) {
                super(Groupssettings.this, "PUT", REST_PATH, (Object)content, com.google.api.services.groupssettings.model.Groups.class);
                this.groupUniqueId = (String)Preconditions.checkNotNull((Object)groupUniqueId, (Object)"Required parameter groupUniqueId must be specified.");
                this.set("alt", "json");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getGroupUniqueId() {
                return this.groupUniqueId;
            }

            public Update setGroupUniqueId(String groupUniqueId) {
                this.groupUniqueId = groupUniqueId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends GroupssettingsRequest<com.google.api.services.groupssettings.model.Groups> {
            private static final String REST_PATH = "{groupUniqueId}";
            @Key
            private String groupUniqueId;

            protected Patch(String groupUniqueId, com.google.api.services.groupssettings.model.Groups content) {
                super(Groupssettings.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.groupssettings.model.Groups.class);
                this.groupUniqueId = (String)Preconditions.checkNotNull((Object)groupUniqueId, (Object)"Required parameter groupUniqueId must be specified.");
                this.set("alt", "json");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getGroupUniqueId() {
                return this.groupUniqueId;
            }

            public Patch setGroupUniqueId(String groupUniqueId) {
                this.groupUniqueId = groupUniqueId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Get
        extends GroupssettingsRequest<com.google.api.services.groupssettings.model.Groups> {
            private static final String REST_PATH = "{groupUniqueId}";
            @Key
            private String groupUniqueId;

            protected Get(String groupUniqueId) {
                super(Groupssettings.this, "GET", REST_PATH, null, com.google.api.services.groupssettings.model.Groups.class);
                this.groupUniqueId = (String)Preconditions.checkNotNull((Object)groupUniqueId, (Object)"Required parameter groupUniqueId must be specified.");
                this.set("alt", "json");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getGroupUniqueId() {
                return this.groupUniqueId;
            }

            public Get setGroupUniqueId(String groupUniqueId) {
                this.groupUniqueId = groupUniqueId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

